/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagent.model.ActionGroupState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ActionGroupSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ActionGroupSummary> {
    private static final SdkField<String> ACTION_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("actionGroupId").getter(ActionGroupSummary.getter(ActionGroupSummary::actionGroupId)).setter(ActionGroupSummary.setter(Builder::actionGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionGroupId").build()}).build();
    private static final SdkField<String> ACTION_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("actionGroupName").getter(ActionGroupSummary.getter(ActionGroupSummary::actionGroupName)).setter(ActionGroupSummary.setter(Builder::actionGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionGroupName").build()}).build();
    private static final SdkField<String> ACTION_GROUP_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("actionGroupState").getter(ActionGroupSummary.getter(ActionGroupSummary::actionGroupStateAsString)).setter(ActionGroupSummary.setter(Builder::actionGroupState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionGroupState").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(ActionGroupSummary.getter(ActionGroupSummary::description)).setter(ActionGroupSummary.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(ActionGroupSummary.getter(ActionGroupSummary::updatedAt)).setter(ActionGroupSummary.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_GROUP_ID_FIELD, ACTION_GROUP_NAME_FIELD, ACTION_GROUP_STATE_FIELD, DESCRIPTION_FIELD, UPDATED_AT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ActionGroupSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String actionGroupId;
    private final String actionGroupName;
    private final String actionGroupState;
    private final String description;
    private final Instant updatedAt;

    private ActionGroupSummary(BuilderImpl builder) {
        this.actionGroupId = builder.actionGroupId;
        this.actionGroupName = builder.actionGroupName;
        this.actionGroupState = builder.actionGroupState;
        this.description = builder.description;
        this.updatedAt = builder.updatedAt;
    }

    public final String actionGroupId() {
        return this.actionGroupId;
    }

    public final String actionGroupName() {
        return this.actionGroupName;
    }

    public final ActionGroupState actionGroupState() {
        return ActionGroupState.fromValue(this.actionGroupState);
    }

    public final String actionGroupStateAsString() {
        return this.actionGroupState;
    }

    public final String description() {
        return this.description;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actionGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionGroupStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActionGroupSummary)) {
            return false;
        }
        ActionGroupSummary other = (ActionGroupSummary)obj;
        return Objects.equals(this.actionGroupId(), other.actionGroupId()) && Objects.equals(this.actionGroupName(), other.actionGroupName()) && Objects.equals(this.actionGroupStateAsString(), other.actionGroupStateAsString()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.updatedAt(), other.updatedAt());
    }

    public final String toString() {
        return ToString.builder((String)"ActionGroupSummary").add("ActionGroupId", (Object)this.actionGroupId()).add("ActionGroupName", (Object)this.actionGroupName()).add("ActionGroupState", (Object)this.actionGroupStateAsString()).add("Description", (Object)this.description()).add("UpdatedAt", (Object)this.updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "actionGroupId": {
                return Optional.ofNullable(clazz.cast(this.actionGroupId()));
            }
            case "actionGroupName": {
                return Optional.ofNullable(clazz.cast(this.actionGroupName()));
            }
            case "actionGroupState": {
                return Optional.ofNullable(clazz.cast(this.actionGroupStateAsString()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("actionGroupId", ACTION_GROUP_ID_FIELD);
        map.put("actionGroupName", ACTION_GROUP_NAME_FIELD);
        map.put("actionGroupState", ACTION_GROUP_STATE_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ActionGroupSummary, T> g) {
        return obj -> g.apply((ActionGroupSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String actionGroupId;
        private String actionGroupName;
        private String actionGroupState;
        private String description;
        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(ActionGroupSummary model) {
            this.actionGroupId(model.actionGroupId);
            this.actionGroupName(model.actionGroupName);
            this.actionGroupState(model.actionGroupState);
            this.description(model.description);
            this.updatedAt(model.updatedAt);
        }

        public final String getActionGroupId() {
            return this.actionGroupId;
        }

        public final void setActionGroupId(String actionGroupId) {
            this.actionGroupId = actionGroupId;
        }

        @Override
        public final Builder actionGroupId(String actionGroupId) {
            this.actionGroupId = actionGroupId;
            return this;
        }

        public final String getActionGroupName() {
            return this.actionGroupName;
        }

        public final void setActionGroupName(String actionGroupName) {
            this.actionGroupName = actionGroupName;
        }

        @Override
        public final Builder actionGroupName(String actionGroupName) {
            this.actionGroupName = actionGroupName;
            return this;
        }

        public final String getActionGroupState() {
            return this.actionGroupState;
        }

        public final void setActionGroupState(String actionGroupState) {
            this.actionGroupState = actionGroupState;
        }

        @Override
        public final Builder actionGroupState(String actionGroupState) {
            this.actionGroupState = actionGroupState;
            return this;
        }

        @Override
        public final Builder actionGroupState(ActionGroupState actionGroupState) {
            this.actionGroupState(actionGroupState == null ? null : actionGroupState.toString());
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public ActionGroupSummary build() {
            return new ActionGroupSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ActionGroupSummary> {
        public Builder actionGroupId(String var1);

        public Builder actionGroupName(String var1);

        public Builder actionGroupState(String var1);

        public Builder actionGroupState(ActionGroupState var1);

        public Builder description(String var1);

        public Builder updatedAt(Instant var1);
    }
}

