/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.bedrockagent.model.AgentFlowNodeConfiguration;
import software.amazon.awssdk.services.bedrockagent.model.CollectorFlowNodeConfiguration;
import software.amazon.awssdk.services.bedrockagent.model.ConditionFlowNodeConfiguration;
import software.amazon.awssdk.services.bedrockagent.model.InlineCodeFlowNodeConfiguration;
import software.amazon.awssdk.services.bedrockagent.model.InputFlowNodeConfiguration;
import software.amazon.awssdk.services.bedrockagent.model.IteratorFlowNodeConfiguration;
import software.amazon.awssdk.services.bedrockagent.model.KnowledgeBaseFlowNodeConfiguration;
import software.amazon.awssdk.services.bedrockagent.model.LambdaFunctionFlowNodeConfiguration;
import software.amazon.awssdk.services.bedrockagent.model.LexFlowNodeConfiguration;
import software.amazon.awssdk.services.bedrockagent.model.OutputFlowNodeConfiguration;
import software.amazon.awssdk.services.bedrockagent.model.PromptFlowNodeConfiguration;
import software.amazon.awssdk.services.bedrockagent.model.RetrievalFlowNodeConfiguration;
import software.amazon.awssdk.services.bedrockagent.model.StorageFlowNodeConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FlowNodeConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FlowNodeConfiguration> {
    private static final SdkField<AgentFlowNodeConfiguration> AGENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("agent").getter(FlowNodeConfiguration.getter(FlowNodeConfiguration::agent)).setter(FlowNodeConfiguration.setter(Builder::agent)).constructor(AgentFlowNodeConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agent").build()}).build();
    private static final SdkField<CollectorFlowNodeConfiguration> COLLECTOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("collector").getter(FlowNodeConfiguration.getter(FlowNodeConfiguration::collector)).setter(FlowNodeConfiguration.setter(Builder::collector)).constructor(CollectorFlowNodeConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collector").build()}).build();
    private static final SdkField<ConditionFlowNodeConfiguration> CONDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("condition").getter(FlowNodeConfiguration.getter(FlowNodeConfiguration::condition)).setter(FlowNodeConfiguration.setter(Builder::condition)).constructor(ConditionFlowNodeConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("condition").build()}).build();
    private static final SdkField<InlineCodeFlowNodeConfiguration> INLINE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("inlineCode").getter(FlowNodeConfiguration.getter(FlowNodeConfiguration::inlineCode)).setter(FlowNodeConfiguration.setter(Builder::inlineCode)).constructor(InlineCodeFlowNodeConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inlineCode").build()}).build();
    private static final SdkField<InputFlowNodeConfiguration> INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("input").getter(FlowNodeConfiguration.getter(FlowNodeConfiguration::input)).setter(FlowNodeConfiguration.setter(Builder::input)).constructor(InputFlowNodeConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("input").build()}).build();
    private static final SdkField<IteratorFlowNodeConfiguration> ITERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("iterator").getter(FlowNodeConfiguration.getter(FlowNodeConfiguration::iterator)).setter(FlowNodeConfiguration.setter(Builder::iterator)).constructor(IteratorFlowNodeConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iterator").build()}).build();
    private static final SdkField<KnowledgeBaseFlowNodeConfiguration> KNOWLEDGE_BASE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("knowledgeBase").getter(FlowNodeConfiguration.getter(FlowNodeConfiguration::knowledgeBase)).setter(FlowNodeConfiguration.setter(Builder::knowledgeBase)).constructor(KnowledgeBaseFlowNodeConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeBase").build()}).build();
    private static final SdkField<LambdaFunctionFlowNodeConfiguration> LAMBDA_FUNCTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("lambdaFunction").getter(FlowNodeConfiguration.getter(FlowNodeConfiguration::lambdaFunction)).setter(FlowNodeConfiguration.setter(Builder::lambdaFunction)).constructor(LambdaFunctionFlowNodeConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lambdaFunction").build()}).build();
    private static final SdkField<LexFlowNodeConfiguration> LEX_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("lex").getter(FlowNodeConfiguration.getter(FlowNodeConfiguration::lex)).setter(FlowNodeConfiguration.setter(Builder::lex)).constructor(LexFlowNodeConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lex").build()}).build();
    private static final SdkField<OutputFlowNodeConfiguration> OUTPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("output").getter(FlowNodeConfiguration.getter(FlowNodeConfiguration::output)).setter(FlowNodeConfiguration.setter(Builder::output)).constructor(OutputFlowNodeConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("output").build()}).build();
    private static final SdkField<PromptFlowNodeConfiguration> PROMPT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("prompt").getter(FlowNodeConfiguration.getter(FlowNodeConfiguration::prompt)).setter(FlowNodeConfiguration.setter(Builder::prompt)).constructor(PromptFlowNodeConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("prompt").build()}).build();
    private static final SdkField<RetrievalFlowNodeConfiguration> RETRIEVAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("retrieval").getter(FlowNodeConfiguration.getter(FlowNodeConfiguration::retrieval)).setter(FlowNodeConfiguration.setter(Builder::retrieval)).constructor(RetrievalFlowNodeConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retrieval").build()}).build();
    private static final SdkField<StorageFlowNodeConfiguration> STORAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("storage").getter(FlowNodeConfiguration.getter(FlowNodeConfiguration::storage)).setter(FlowNodeConfiguration.setter(Builder::storage)).constructor(StorageFlowNodeConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_FIELD, COLLECTOR_FIELD, CONDITION_FIELD, INLINE_CODE_FIELD, INPUT_FIELD, ITERATOR_FIELD, KNOWLEDGE_BASE_FIELD, LAMBDA_FUNCTION_FIELD, LEX_FIELD, OUTPUT_FIELD, PROMPT_FIELD, RETRIEVAL_FIELD, STORAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FlowNodeConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final AgentFlowNodeConfiguration agent;
    private final CollectorFlowNodeConfiguration collector;
    private final ConditionFlowNodeConfiguration condition;
    private final InlineCodeFlowNodeConfiguration inlineCode;
    private final InputFlowNodeConfiguration input;
    private final IteratorFlowNodeConfiguration iterator;
    private final KnowledgeBaseFlowNodeConfiguration knowledgeBase;
    private final LambdaFunctionFlowNodeConfiguration lambdaFunction;
    private final LexFlowNodeConfiguration lex;
    private final OutputFlowNodeConfiguration output;
    private final PromptFlowNodeConfiguration prompt;
    private final RetrievalFlowNodeConfiguration retrieval;
    private final StorageFlowNodeConfiguration storage;
    private final Type type;

    private FlowNodeConfiguration(BuilderImpl builder) {
        this.agent = builder.agent;
        this.collector = builder.collector;
        this.condition = builder.condition;
        this.inlineCode = builder.inlineCode;
        this.input = builder.input;
        this.iterator = builder.iterator;
        this.knowledgeBase = builder.knowledgeBase;
        this.lambdaFunction = builder.lambdaFunction;
        this.lex = builder.lex;
        this.output = builder.output;
        this.prompt = builder.prompt;
        this.retrieval = builder.retrieval;
        this.storage = builder.storage;
        this.type = builder.type;
    }

    public final AgentFlowNodeConfiguration agent() {
        return this.agent;
    }

    public final CollectorFlowNodeConfiguration collector() {
        return this.collector;
    }

    public final ConditionFlowNodeConfiguration condition() {
        return this.condition;
    }

    public final InlineCodeFlowNodeConfiguration inlineCode() {
        return this.inlineCode;
    }

    public final InputFlowNodeConfiguration input() {
        return this.input;
    }

    public final IteratorFlowNodeConfiguration iterator() {
        return this.iterator;
    }

    public final KnowledgeBaseFlowNodeConfiguration knowledgeBase() {
        return this.knowledgeBase;
    }

    public final LambdaFunctionFlowNodeConfiguration lambdaFunction() {
        return this.lambdaFunction;
    }

    public final LexFlowNodeConfiguration lex() {
        return this.lex;
    }

    public final OutputFlowNodeConfiguration output() {
        return this.output;
    }

    public final PromptFlowNodeConfiguration prompt() {
        return this.prompt;
    }

    public final RetrievalFlowNodeConfiguration retrieval() {
        return this.retrieval;
    }

    public final StorageFlowNodeConfiguration storage() {
        return this.storage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.agent());
        hashCode = 31 * hashCode + Objects.hashCode(this.collector());
        hashCode = 31 * hashCode + Objects.hashCode(this.condition());
        hashCode = 31 * hashCode + Objects.hashCode(this.inlineCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.input());
        hashCode = 31 * hashCode + Objects.hashCode(this.iterator());
        hashCode = 31 * hashCode + Objects.hashCode(this.knowledgeBase());
        hashCode = 31 * hashCode + Objects.hashCode(this.lambdaFunction());
        hashCode = 31 * hashCode + Objects.hashCode(this.lex());
        hashCode = 31 * hashCode + Objects.hashCode(this.output());
        hashCode = 31 * hashCode + Objects.hashCode(this.prompt());
        hashCode = 31 * hashCode + Objects.hashCode(this.retrieval());
        hashCode = 31 * hashCode + Objects.hashCode(this.storage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FlowNodeConfiguration)) {
            return false;
        }
        FlowNodeConfiguration other = (FlowNodeConfiguration)obj;
        return Objects.equals(this.agent(), other.agent()) && Objects.equals(this.collector(), other.collector()) && Objects.equals(this.condition(), other.condition()) && Objects.equals(this.inlineCode(), other.inlineCode()) && Objects.equals(this.input(), other.input()) && Objects.equals(this.iterator(), other.iterator()) && Objects.equals(this.knowledgeBase(), other.knowledgeBase()) && Objects.equals(this.lambdaFunction(), other.lambdaFunction()) && Objects.equals(this.lex(), other.lex()) && Objects.equals(this.output(), other.output()) && Objects.equals(this.prompt(), other.prompt()) && Objects.equals(this.retrieval(), other.retrieval()) && Objects.equals(this.storage(), other.storage());
    }

    public final String toString() {
        return ToString.builder((String)"FlowNodeConfiguration").add("Agent", (Object)this.agent()).add("Collector", (Object)this.collector()).add("Condition", (Object)this.condition()).add("InlineCode", (Object)this.inlineCode()).add("Input", (Object)this.input()).add("Iterator", (Object)this.iterator()).add("KnowledgeBase", (Object)this.knowledgeBase()).add("LambdaFunction", (Object)this.lambdaFunction()).add("Lex", (Object)this.lex()).add("Output", (Object)this.output()).add("Prompt", (Object)this.prompt()).add("Retrieval", (Object)this.retrieval()).add("Storage", (Object)this.storage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "agent": {
                return Optional.ofNullable(clazz.cast(this.agent()));
            }
            case "collector": {
                return Optional.ofNullable(clazz.cast(this.collector()));
            }
            case "condition": {
                return Optional.ofNullable(clazz.cast(this.condition()));
            }
            case "inlineCode": {
                return Optional.ofNullable(clazz.cast(this.inlineCode()));
            }
            case "input": {
                return Optional.ofNullable(clazz.cast(this.input()));
            }
            case "iterator": {
                return Optional.ofNullable(clazz.cast(this.iterator()));
            }
            case "knowledgeBase": {
                return Optional.ofNullable(clazz.cast(this.knowledgeBase()));
            }
            case "lambdaFunction": {
                return Optional.ofNullable(clazz.cast(this.lambdaFunction()));
            }
            case "lex": {
                return Optional.ofNullable(clazz.cast(this.lex()));
            }
            case "output": {
                return Optional.ofNullable(clazz.cast(this.output()));
            }
            case "prompt": {
                return Optional.ofNullable(clazz.cast(this.prompt()));
            }
            case "retrieval": {
                return Optional.ofNullable(clazz.cast(this.retrieval()));
            }
            case "storage": {
                return Optional.ofNullable(clazz.cast(this.storage()));
            }
        }
        return Optional.empty();
    }

    public static FlowNodeConfiguration fromAgent(AgentFlowNodeConfiguration agent) {
        return (FlowNodeConfiguration)FlowNodeConfiguration.builder().agent(agent).build();
    }

    public static FlowNodeConfiguration fromAgent(Consumer<AgentFlowNodeConfiguration.Builder> agent) {
        AgentFlowNodeConfiguration.Builder builder = AgentFlowNodeConfiguration.builder();
        agent.accept(builder);
        return FlowNodeConfiguration.fromAgent((AgentFlowNodeConfiguration)builder.build());
    }

    public static FlowNodeConfiguration fromCollector(CollectorFlowNodeConfiguration collector) {
        return (FlowNodeConfiguration)FlowNodeConfiguration.builder().collector(collector).build();
    }

    public static FlowNodeConfiguration fromCollector(Consumer<CollectorFlowNodeConfiguration.Builder> collector) {
        CollectorFlowNodeConfiguration.Builder builder = CollectorFlowNodeConfiguration.builder();
        collector.accept(builder);
        return FlowNodeConfiguration.fromCollector((CollectorFlowNodeConfiguration)builder.build());
    }

    public static FlowNodeConfiguration fromCondition(ConditionFlowNodeConfiguration condition) {
        return (FlowNodeConfiguration)FlowNodeConfiguration.builder().condition(condition).build();
    }

    public static FlowNodeConfiguration fromCondition(Consumer<ConditionFlowNodeConfiguration.Builder> condition) {
        ConditionFlowNodeConfiguration.Builder builder = ConditionFlowNodeConfiguration.builder();
        condition.accept(builder);
        return FlowNodeConfiguration.fromCondition((ConditionFlowNodeConfiguration)builder.build());
    }

    public static FlowNodeConfiguration fromInlineCode(InlineCodeFlowNodeConfiguration inlineCode) {
        return (FlowNodeConfiguration)FlowNodeConfiguration.builder().inlineCode(inlineCode).build();
    }

    public static FlowNodeConfiguration fromInlineCode(Consumer<InlineCodeFlowNodeConfiguration.Builder> inlineCode) {
        InlineCodeFlowNodeConfiguration.Builder builder = InlineCodeFlowNodeConfiguration.builder();
        inlineCode.accept(builder);
        return FlowNodeConfiguration.fromInlineCode((InlineCodeFlowNodeConfiguration)builder.build());
    }

    public static FlowNodeConfiguration fromInput(InputFlowNodeConfiguration input) {
        return (FlowNodeConfiguration)FlowNodeConfiguration.builder().input(input).build();
    }

    public static FlowNodeConfiguration fromInput(Consumer<InputFlowNodeConfiguration.Builder> input) {
        InputFlowNodeConfiguration.Builder builder = InputFlowNodeConfiguration.builder();
        input.accept(builder);
        return FlowNodeConfiguration.fromInput((InputFlowNodeConfiguration)builder.build());
    }

    public static FlowNodeConfiguration fromIterator(IteratorFlowNodeConfiguration iterator) {
        return (FlowNodeConfiguration)FlowNodeConfiguration.builder().iterator(iterator).build();
    }

    public static FlowNodeConfiguration fromIterator(Consumer<IteratorFlowNodeConfiguration.Builder> iterator) {
        IteratorFlowNodeConfiguration.Builder builder = IteratorFlowNodeConfiguration.builder();
        iterator.accept(builder);
        return FlowNodeConfiguration.fromIterator((IteratorFlowNodeConfiguration)builder.build());
    }

    public static FlowNodeConfiguration fromKnowledgeBase(KnowledgeBaseFlowNodeConfiguration knowledgeBase) {
        return (FlowNodeConfiguration)FlowNodeConfiguration.builder().knowledgeBase(knowledgeBase).build();
    }

    public static FlowNodeConfiguration fromKnowledgeBase(Consumer<KnowledgeBaseFlowNodeConfiguration.Builder> knowledgeBase) {
        KnowledgeBaseFlowNodeConfiguration.Builder builder = KnowledgeBaseFlowNodeConfiguration.builder();
        knowledgeBase.accept(builder);
        return FlowNodeConfiguration.fromKnowledgeBase((KnowledgeBaseFlowNodeConfiguration)builder.build());
    }

    public static FlowNodeConfiguration fromLambdaFunction(LambdaFunctionFlowNodeConfiguration lambdaFunction) {
        return (FlowNodeConfiguration)FlowNodeConfiguration.builder().lambdaFunction(lambdaFunction).build();
    }

    public static FlowNodeConfiguration fromLambdaFunction(Consumer<LambdaFunctionFlowNodeConfiguration.Builder> lambdaFunction) {
        LambdaFunctionFlowNodeConfiguration.Builder builder = LambdaFunctionFlowNodeConfiguration.builder();
        lambdaFunction.accept(builder);
        return FlowNodeConfiguration.fromLambdaFunction((LambdaFunctionFlowNodeConfiguration)builder.build());
    }

    public static FlowNodeConfiguration fromLex(LexFlowNodeConfiguration lex) {
        return (FlowNodeConfiguration)FlowNodeConfiguration.builder().lex(lex).build();
    }

    public static FlowNodeConfiguration fromLex(Consumer<LexFlowNodeConfiguration.Builder> lex) {
        LexFlowNodeConfiguration.Builder builder = LexFlowNodeConfiguration.builder();
        lex.accept(builder);
        return FlowNodeConfiguration.fromLex((LexFlowNodeConfiguration)builder.build());
    }

    public static FlowNodeConfiguration fromOutput(OutputFlowNodeConfiguration output) {
        return (FlowNodeConfiguration)FlowNodeConfiguration.builder().output(output).build();
    }

    public static FlowNodeConfiguration fromOutput(Consumer<OutputFlowNodeConfiguration.Builder> output) {
        OutputFlowNodeConfiguration.Builder builder = OutputFlowNodeConfiguration.builder();
        output.accept(builder);
        return FlowNodeConfiguration.fromOutput((OutputFlowNodeConfiguration)builder.build());
    }

    public static FlowNodeConfiguration fromPrompt(PromptFlowNodeConfiguration prompt) {
        return (FlowNodeConfiguration)FlowNodeConfiguration.builder().prompt(prompt).build();
    }

    public static FlowNodeConfiguration fromPrompt(Consumer<PromptFlowNodeConfiguration.Builder> prompt) {
        PromptFlowNodeConfiguration.Builder builder = PromptFlowNodeConfiguration.builder();
        prompt.accept(builder);
        return FlowNodeConfiguration.fromPrompt((PromptFlowNodeConfiguration)builder.build());
    }

    public static FlowNodeConfiguration fromRetrieval(RetrievalFlowNodeConfiguration retrieval) {
        return (FlowNodeConfiguration)FlowNodeConfiguration.builder().retrieval(retrieval).build();
    }

    public static FlowNodeConfiguration fromRetrieval(Consumer<RetrievalFlowNodeConfiguration.Builder> retrieval) {
        RetrievalFlowNodeConfiguration.Builder builder = RetrievalFlowNodeConfiguration.builder();
        retrieval.accept(builder);
        return FlowNodeConfiguration.fromRetrieval((RetrievalFlowNodeConfiguration)builder.build());
    }

    public static FlowNodeConfiguration fromStorage(StorageFlowNodeConfiguration storage) {
        return (FlowNodeConfiguration)FlowNodeConfiguration.builder().storage(storage).build();
    }

    public static FlowNodeConfiguration fromStorage(Consumer<StorageFlowNodeConfiguration.Builder> storage) {
        StorageFlowNodeConfiguration.Builder builder = StorageFlowNodeConfiguration.builder();
        storage.accept(builder);
        return FlowNodeConfiguration.fromStorage((StorageFlowNodeConfiguration)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("agent", AGENT_FIELD);
        map.put("collector", COLLECTOR_FIELD);
        map.put("condition", CONDITION_FIELD);
        map.put("inlineCode", INLINE_CODE_FIELD);
        map.put("input", INPUT_FIELD);
        map.put("iterator", ITERATOR_FIELD);
        map.put("knowledgeBase", KNOWLEDGE_BASE_FIELD);
        map.put("lambdaFunction", LAMBDA_FUNCTION_FIELD);
        map.put("lex", LEX_FIELD);
        map.put("output", OUTPUT_FIELD);
        map.put("prompt", PROMPT_FIELD);
        map.put("retrieval", RETRIEVAL_FIELD);
        map.put("storage", STORAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FlowNodeConfiguration, T> g) {
        return obj -> g.apply((FlowNodeConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        AGENT,
        COLLECTOR,
        CONDITION,
        INLINE_CODE,
        INPUT,
        ITERATOR,
        KNOWLEDGE_BASE,
        LAMBDA_FUNCTION,
        LEX,
        OUTPUT,
        PROMPT,
        RETRIEVAL,
        STORAGE,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private AgentFlowNodeConfiguration agent;
        private CollectorFlowNodeConfiguration collector;
        private ConditionFlowNodeConfiguration condition;
        private InlineCodeFlowNodeConfiguration inlineCode;
        private InputFlowNodeConfiguration input;
        private IteratorFlowNodeConfiguration iterator;
        private KnowledgeBaseFlowNodeConfiguration knowledgeBase;
        private LambdaFunctionFlowNodeConfiguration lambdaFunction;
        private LexFlowNodeConfiguration lex;
        private OutputFlowNodeConfiguration output;
        private PromptFlowNodeConfiguration prompt;
        private RetrievalFlowNodeConfiguration retrieval;
        private StorageFlowNodeConfiguration storage;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(FlowNodeConfiguration model) {
            this.agent(model.agent);
            this.collector(model.collector);
            this.condition(model.condition);
            this.inlineCode(model.inlineCode);
            this.input(model.input);
            this.iterator(model.iterator);
            this.knowledgeBase(model.knowledgeBase);
            this.lambdaFunction(model.lambdaFunction);
            this.lex(model.lex);
            this.output(model.output);
            this.prompt(model.prompt);
            this.retrieval(model.retrieval);
            this.storage(model.storage);
        }

        public final AgentFlowNodeConfiguration.Builder getAgent() {
            return this.agent != null ? this.agent.toBuilder() : null;
        }

        public final void setAgent(AgentFlowNodeConfiguration.BuilderImpl agent) {
            AgentFlowNodeConfiguration oldValue = this.agent;
            this.agent = agent != null ? agent.build() : null;
            this.handleUnionValueChange(Type.AGENT, oldValue, this.agent);
        }

        @Override
        public final Builder agent(AgentFlowNodeConfiguration agent) {
            AgentFlowNodeConfiguration oldValue = this.agent;
            this.agent = agent;
            this.handleUnionValueChange(Type.AGENT, oldValue, this.agent);
            return this;
        }

        public final CollectorFlowNodeConfiguration.Builder getCollector() {
            return this.collector != null ? this.collector.toBuilder() : null;
        }

        public final void setCollector(CollectorFlowNodeConfiguration.BuilderImpl collector) {
            CollectorFlowNodeConfiguration oldValue = this.collector;
            this.collector = collector != null ? collector.build() : null;
            this.handleUnionValueChange(Type.COLLECTOR, oldValue, this.collector);
        }

        @Override
        public final Builder collector(CollectorFlowNodeConfiguration collector) {
            CollectorFlowNodeConfiguration oldValue = this.collector;
            this.collector = collector;
            this.handleUnionValueChange(Type.COLLECTOR, oldValue, this.collector);
            return this;
        }

        public final ConditionFlowNodeConfiguration.Builder getCondition() {
            return this.condition != null ? this.condition.toBuilder() : null;
        }

        public final void setCondition(ConditionFlowNodeConfiguration.BuilderImpl condition) {
            ConditionFlowNodeConfiguration oldValue = this.condition;
            this.condition = condition != null ? condition.build() : null;
            this.handleUnionValueChange(Type.CONDITION, oldValue, this.condition);
        }

        @Override
        public final Builder condition(ConditionFlowNodeConfiguration condition) {
            ConditionFlowNodeConfiguration oldValue = this.condition;
            this.condition = condition;
            this.handleUnionValueChange(Type.CONDITION, oldValue, this.condition);
            return this;
        }

        public final InlineCodeFlowNodeConfiguration.Builder getInlineCode() {
            return this.inlineCode != null ? this.inlineCode.toBuilder() : null;
        }

        public final void setInlineCode(InlineCodeFlowNodeConfiguration.BuilderImpl inlineCode) {
            InlineCodeFlowNodeConfiguration oldValue = this.inlineCode;
            this.inlineCode = inlineCode != null ? inlineCode.build() : null;
            this.handleUnionValueChange(Type.INLINE_CODE, oldValue, this.inlineCode);
        }

        @Override
        public final Builder inlineCode(InlineCodeFlowNodeConfiguration inlineCode) {
            InlineCodeFlowNodeConfiguration oldValue = this.inlineCode;
            this.inlineCode = inlineCode;
            this.handleUnionValueChange(Type.INLINE_CODE, oldValue, this.inlineCode);
            return this;
        }

        public final InputFlowNodeConfiguration.Builder getInput() {
            return this.input != null ? this.input.toBuilder() : null;
        }

        public final void setInput(InputFlowNodeConfiguration.BuilderImpl input) {
            InputFlowNodeConfiguration oldValue = this.input;
            this.input = input != null ? input.build() : null;
            this.handleUnionValueChange(Type.INPUT, oldValue, this.input);
        }

        @Override
        public final Builder input(InputFlowNodeConfiguration input) {
            InputFlowNodeConfiguration oldValue = this.input;
            this.input = input;
            this.handleUnionValueChange(Type.INPUT, oldValue, this.input);
            return this;
        }

        public final IteratorFlowNodeConfiguration.Builder getIterator() {
            return this.iterator != null ? this.iterator.toBuilder() : null;
        }

        public final void setIterator(IteratorFlowNodeConfiguration.BuilderImpl iterator) {
            IteratorFlowNodeConfiguration oldValue = this.iterator;
            this.iterator = iterator != null ? iterator.build() : null;
            this.handleUnionValueChange(Type.ITERATOR, oldValue, this.iterator);
        }

        @Override
        public final Builder iterator(IteratorFlowNodeConfiguration iterator) {
            IteratorFlowNodeConfiguration oldValue = this.iterator;
            this.iterator = iterator;
            this.handleUnionValueChange(Type.ITERATOR, oldValue, this.iterator);
            return this;
        }

        public final KnowledgeBaseFlowNodeConfiguration.Builder getKnowledgeBase() {
            return this.knowledgeBase != null ? this.knowledgeBase.toBuilder() : null;
        }

        public final void setKnowledgeBase(KnowledgeBaseFlowNodeConfiguration.BuilderImpl knowledgeBase) {
            KnowledgeBaseFlowNodeConfiguration oldValue = this.knowledgeBase;
            this.knowledgeBase = knowledgeBase != null ? knowledgeBase.build() : null;
            this.handleUnionValueChange(Type.KNOWLEDGE_BASE, oldValue, this.knowledgeBase);
        }

        @Override
        public final Builder knowledgeBase(KnowledgeBaseFlowNodeConfiguration knowledgeBase) {
            KnowledgeBaseFlowNodeConfiguration oldValue = this.knowledgeBase;
            this.knowledgeBase = knowledgeBase;
            this.handleUnionValueChange(Type.KNOWLEDGE_BASE, oldValue, this.knowledgeBase);
            return this;
        }

        public final LambdaFunctionFlowNodeConfiguration.Builder getLambdaFunction() {
            return this.lambdaFunction != null ? this.lambdaFunction.toBuilder() : null;
        }

        public final void setLambdaFunction(LambdaFunctionFlowNodeConfiguration.BuilderImpl lambdaFunction) {
            LambdaFunctionFlowNodeConfiguration oldValue = this.lambdaFunction;
            this.lambdaFunction = lambdaFunction != null ? lambdaFunction.build() : null;
            this.handleUnionValueChange(Type.LAMBDA_FUNCTION, oldValue, this.lambdaFunction);
        }

        @Override
        public final Builder lambdaFunction(LambdaFunctionFlowNodeConfiguration lambdaFunction) {
            LambdaFunctionFlowNodeConfiguration oldValue = this.lambdaFunction;
            this.lambdaFunction = lambdaFunction;
            this.handleUnionValueChange(Type.LAMBDA_FUNCTION, oldValue, this.lambdaFunction);
            return this;
        }

        public final LexFlowNodeConfiguration.Builder getLex() {
            return this.lex != null ? this.lex.toBuilder() : null;
        }

        public final void setLex(LexFlowNodeConfiguration.BuilderImpl lex) {
            LexFlowNodeConfiguration oldValue = this.lex;
            this.lex = lex != null ? lex.build() : null;
            this.handleUnionValueChange(Type.LEX, oldValue, this.lex);
        }

        @Override
        public final Builder lex(LexFlowNodeConfiguration lex) {
            LexFlowNodeConfiguration oldValue = this.lex;
            this.lex = lex;
            this.handleUnionValueChange(Type.LEX, oldValue, this.lex);
            return this;
        }

        public final OutputFlowNodeConfiguration.Builder getOutput() {
            return this.output != null ? this.output.toBuilder() : null;
        }

        public final void setOutput(OutputFlowNodeConfiguration.BuilderImpl output) {
            OutputFlowNodeConfiguration oldValue = this.output;
            this.output = output != null ? output.build() : null;
            this.handleUnionValueChange(Type.OUTPUT, oldValue, this.output);
        }

        @Override
        public final Builder output(OutputFlowNodeConfiguration output) {
            OutputFlowNodeConfiguration oldValue = this.output;
            this.output = output;
            this.handleUnionValueChange(Type.OUTPUT, oldValue, this.output);
            return this;
        }

        public final PromptFlowNodeConfiguration.Builder getPrompt() {
            return this.prompt != null ? this.prompt.toBuilder() : null;
        }

        public final void setPrompt(PromptFlowNodeConfiguration.BuilderImpl prompt) {
            PromptFlowNodeConfiguration oldValue = this.prompt;
            this.prompt = prompt != null ? prompt.build() : null;
            this.handleUnionValueChange(Type.PROMPT, oldValue, this.prompt);
        }

        @Override
        public final Builder prompt(PromptFlowNodeConfiguration prompt) {
            PromptFlowNodeConfiguration oldValue = this.prompt;
            this.prompt = prompt;
            this.handleUnionValueChange(Type.PROMPT, oldValue, this.prompt);
            return this;
        }

        public final RetrievalFlowNodeConfiguration.Builder getRetrieval() {
            return this.retrieval != null ? this.retrieval.toBuilder() : null;
        }

        public final void setRetrieval(RetrievalFlowNodeConfiguration.BuilderImpl retrieval) {
            RetrievalFlowNodeConfiguration oldValue = this.retrieval;
            this.retrieval = retrieval != null ? retrieval.build() : null;
            this.handleUnionValueChange(Type.RETRIEVAL, oldValue, this.retrieval);
        }

        @Override
        public final Builder retrieval(RetrievalFlowNodeConfiguration retrieval) {
            RetrievalFlowNodeConfiguration oldValue = this.retrieval;
            this.retrieval = retrieval;
            this.handleUnionValueChange(Type.RETRIEVAL, oldValue, this.retrieval);
            return this;
        }

        public final StorageFlowNodeConfiguration.Builder getStorage() {
            return this.storage != null ? this.storage.toBuilder() : null;
        }

        public final void setStorage(StorageFlowNodeConfiguration.BuilderImpl storage) {
            StorageFlowNodeConfiguration oldValue = this.storage;
            this.storage = storage != null ? storage.build() : null;
            this.handleUnionValueChange(Type.STORAGE, oldValue, this.storage);
        }

        @Override
        public final Builder storage(StorageFlowNodeConfiguration storage) {
            StorageFlowNodeConfiguration oldValue = this.storage;
            this.storage = storage;
            this.handleUnionValueChange(Type.STORAGE, oldValue, this.storage);
            return this;
        }

        public FlowNodeConfiguration build() {
            return new FlowNodeConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FlowNodeConfiguration> {
        public Builder agent(AgentFlowNodeConfiguration var1);

        default public Builder agent(Consumer<AgentFlowNodeConfiguration.Builder> agent) {
            return this.agent((AgentFlowNodeConfiguration)((AgentFlowNodeConfiguration.Builder)AgentFlowNodeConfiguration.builder().applyMutation(agent)).build());
        }

        public Builder collector(CollectorFlowNodeConfiguration var1);

        default public Builder collector(Consumer<CollectorFlowNodeConfiguration.Builder> collector) {
            return this.collector((CollectorFlowNodeConfiguration)((CollectorFlowNodeConfiguration.Builder)CollectorFlowNodeConfiguration.builder().applyMutation(collector)).build());
        }

        public Builder condition(ConditionFlowNodeConfiguration var1);

        default public Builder condition(Consumer<ConditionFlowNodeConfiguration.Builder> condition) {
            return this.condition((ConditionFlowNodeConfiguration)((ConditionFlowNodeConfiguration.Builder)ConditionFlowNodeConfiguration.builder().applyMutation(condition)).build());
        }

        public Builder inlineCode(InlineCodeFlowNodeConfiguration var1);

        default public Builder inlineCode(Consumer<InlineCodeFlowNodeConfiguration.Builder> inlineCode) {
            return this.inlineCode((InlineCodeFlowNodeConfiguration)((InlineCodeFlowNodeConfiguration.Builder)InlineCodeFlowNodeConfiguration.builder().applyMutation(inlineCode)).build());
        }

        public Builder input(InputFlowNodeConfiguration var1);

        default public Builder input(Consumer<InputFlowNodeConfiguration.Builder> input) {
            return this.input((InputFlowNodeConfiguration)((InputFlowNodeConfiguration.Builder)InputFlowNodeConfiguration.builder().applyMutation(input)).build());
        }

        public Builder iterator(IteratorFlowNodeConfiguration var1);

        default public Builder iterator(Consumer<IteratorFlowNodeConfiguration.Builder> iterator) {
            return this.iterator((IteratorFlowNodeConfiguration)((IteratorFlowNodeConfiguration.Builder)IteratorFlowNodeConfiguration.builder().applyMutation(iterator)).build());
        }

        public Builder knowledgeBase(KnowledgeBaseFlowNodeConfiguration var1);

        default public Builder knowledgeBase(Consumer<KnowledgeBaseFlowNodeConfiguration.Builder> knowledgeBase) {
            return this.knowledgeBase((KnowledgeBaseFlowNodeConfiguration)((KnowledgeBaseFlowNodeConfiguration.Builder)KnowledgeBaseFlowNodeConfiguration.builder().applyMutation(knowledgeBase)).build());
        }

        public Builder lambdaFunction(LambdaFunctionFlowNodeConfiguration var1);

        default public Builder lambdaFunction(Consumer<LambdaFunctionFlowNodeConfiguration.Builder> lambdaFunction) {
            return this.lambdaFunction((LambdaFunctionFlowNodeConfiguration)((LambdaFunctionFlowNodeConfiguration.Builder)LambdaFunctionFlowNodeConfiguration.builder().applyMutation(lambdaFunction)).build());
        }

        public Builder lex(LexFlowNodeConfiguration var1);

        default public Builder lex(Consumer<LexFlowNodeConfiguration.Builder> lex) {
            return this.lex((LexFlowNodeConfiguration)((LexFlowNodeConfiguration.Builder)LexFlowNodeConfiguration.builder().applyMutation(lex)).build());
        }

        public Builder output(OutputFlowNodeConfiguration var1);

        default public Builder output(Consumer<OutputFlowNodeConfiguration.Builder> output) {
            return this.output((OutputFlowNodeConfiguration)((OutputFlowNodeConfiguration.Builder)OutputFlowNodeConfiguration.builder().applyMutation(output)).build());
        }

        public Builder prompt(PromptFlowNodeConfiguration var1);

        default public Builder prompt(Consumer<PromptFlowNodeConfiguration.Builder> prompt) {
            return this.prompt((PromptFlowNodeConfiguration)((PromptFlowNodeConfiguration.Builder)PromptFlowNodeConfiguration.builder().applyMutation(prompt)).build());
        }

        public Builder retrieval(RetrievalFlowNodeConfiguration var1);

        default public Builder retrieval(Consumer<RetrievalFlowNodeConfiguration.Builder> retrieval) {
            return this.retrieval((RetrievalFlowNodeConfiguration)((RetrievalFlowNodeConfiguration.Builder)RetrievalFlowNodeConfiguration.builder().applyMutation(retrieval)).build());
        }

        public Builder storage(StorageFlowNodeConfiguration var1);

        default public Builder storage(Consumer<StorageFlowNodeConfiguration.Builder> storage) {
            return this.storage((StorageFlowNodeConfiguration)((StorageFlowNodeConfiguration.Builder)StorageFlowNodeConfiguration.builder().applyMutation(storage)).build());
        }
    }
}

