/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SupportedLanguages {
    PYTHON_3("Python_3"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SupportedLanguages> VALUE_MAP;
    private final String value;

    private SupportedLanguages(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SupportedLanguages fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SupportedLanguages> knownValues() {
        EnumSet<SupportedLanguages> knownValues = EnumSet.allOf(SupportedLanguages.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SupportedLanguages.class, SupportedLanguages::toString);
    }
}

