/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagent.model.BedrockAgentRequest;
import software.amazon.awssdk.services.bedrockagent.model.FlowAliasRoutingConfigurationCopier;
import software.amazon.awssdk.services.bedrockagent.model.FlowAliasRoutingConfigurationListItem;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateFlowAliasRequest
extends BedrockAgentRequest
implements ToCopyableBuilder<Builder, UpdateFlowAliasRequest> {
    private static final SdkField<String> ALIAS_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("aliasIdentifier").getter(UpdateFlowAliasRequest.getter(UpdateFlowAliasRequest::aliasIdentifier)).setter(UpdateFlowAliasRequest.setter(Builder::aliasIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("aliasIdentifier").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdateFlowAliasRequest.getter(UpdateFlowAliasRequest::description)).setter(UpdateFlowAliasRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> FLOW_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("flowIdentifier").getter(UpdateFlowAliasRequest.getter(UpdateFlowAliasRequest::flowIdentifier)).setter(UpdateFlowAliasRequest.setter(Builder::flowIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("flowIdentifier").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(UpdateFlowAliasRequest.getter(UpdateFlowAliasRequest::name)).setter(UpdateFlowAliasRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<List<FlowAliasRoutingConfigurationListItem>> ROUTING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("routingConfiguration").getter(UpdateFlowAliasRequest.getter(UpdateFlowAliasRequest::routingConfiguration)).setter(UpdateFlowAliasRequest.setter(Builder::routingConfiguration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routingConfiguration").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FlowAliasRoutingConfigurationListItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALIAS_IDENTIFIER_FIELD, DESCRIPTION_FIELD, FLOW_IDENTIFIER_FIELD, NAME_FIELD, ROUTING_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateFlowAliasRequest.memberNameToFieldInitializer();
    private final String aliasIdentifier;
    private final String description;
    private final String flowIdentifier;
    private final String name;
    private final List<FlowAliasRoutingConfigurationListItem> routingConfiguration;

    private UpdateFlowAliasRequest(BuilderImpl builder) {
        super(builder);
        this.aliasIdentifier = builder.aliasIdentifier;
        this.description = builder.description;
        this.flowIdentifier = builder.flowIdentifier;
        this.name = builder.name;
        this.routingConfiguration = builder.routingConfiguration;
    }

    public final String aliasIdentifier() {
        return this.aliasIdentifier;
    }

    public final String description() {
        return this.description;
    }

    public final String flowIdentifier() {
        return this.flowIdentifier;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasRoutingConfiguration() {
        return this.routingConfiguration != null && !(this.routingConfiguration instanceof SdkAutoConstructList);
    }

    public final List<FlowAliasRoutingConfigurationListItem> routingConfiguration() {
        return this.routingConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.aliasIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.flowIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRoutingConfiguration() ? this.routingConfiguration() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFlowAliasRequest)) {
            return false;
        }
        UpdateFlowAliasRequest other = (UpdateFlowAliasRequest)((Object)obj);
        return Objects.equals(this.aliasIdentifier(), other.aliasIdentifier()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.flowIdentifier(), other.flowIdentifier()) && Objects.equals(this.name(), other.name()) && this.hasRoutingConfiguration() == other.hasRoutingConfiguration() && Objects.equals(this.routingConfiguration(), other.routingConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateFlowAliasRequest").add("AliasIdentifier", (Object)this.aliasIdentifier()).add("Description", (Object)this.description()).add("FlowIdentifier", (Object)this.flowIdentifier()).add("Name", (Object)this.name()).add("RoutingConfiguration", this.hasRoutingConfiguration() ? this.routingConfiguration() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "aliasIdentifier": {
                return Optional.ofNullable(clazz.cast(this.aliasIdentifier()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "flowIdentifier": {
                return Optional.ofNullable(clazz.cast(this.flowIdentifier()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "routingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.routingConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("aliasIdentifier", ALIAS_IDENTIFIER_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("flowIdentifier", FLOW_IDENTIFIER_FIELD);
        map.put("name", NAME_FIELD);
        map.put("routingConfiguration", ROUTING_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateFlowAliasRequest, T> g) {
        return obj -> g.apply((UpdateFlowAliasRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentRequest.BuilderImpl
    implements Builder {
        private String aliasIdentifier;
        private String description;
        private String flowIdentifier;
        private String name;
        private List<FlowAliasRoutingConfigurationListItem> routingConfiguration = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFlowAliasRequest model) {
            super(model);
            this.aliasIdentifier(model.aliasIdentifier);
            this.description(model.description);
            this.flowIdentifier(model.flowIdentifier);
            this.name(model.name);
            this.routingConfiguration(model.routingConfiguration);
        }

        public final String getAliasIdentifier() {
            return this.aliasIdentifier;
        }

        public final void setAliasIdentifier(String aliasIdentifier) {
            this.aliasIdentifier = aliasIdentifier;
        }

        @Override
        public final Builder aliasIdentifier(String aliasIdentifier) {
            this.aliasIdentifier = aliasIdentifier;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getFlowIdentifier() {
            return this.flowIdentifier;
        }

        public final void setFlowIdentifier(String flowIdentifier) {
            this.flowIdentifier = flowIdentifier;
        }

        @Override
        public final Builder flowIdentifier(String flowIdentifier) {
            this.flowIdentifier = flowIdentifier;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<FlowAliasRoutingConfigurationListItem.Builder> getRoutingConfiguration() {
            List<FlowAliasRoutingConfigurationListItem.Builder> result = FlowAliasRoutingConfigurationCopier.copyToBuilder(this.routingConfiguration);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRoutingConfiguration(Collection<FlowAliasRoutingConfigurationListItem.BuilderImpl> routingConfiguration) {
            this.routingConfiguration = FlowAliasRoutingConfigurationCopier.copyFromBuilder(routingConfiguration);
        }

        @Override
        public final Builder routingConfiguration(Collection<FlowAliasRoutingConfigurationListItem> routingConfiguration) {
            this.routingConfiguration = FlowAliasRoutingConfigurationCopier.copy(routingConfiguration);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routingConfiguration(FlowAliasRoutingConfigurationListItem ... routingConfiguration) {
            this.routingConfiguration(Arrays.asList(routingConfiguration));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routingConfiguration(Consumer<FlowAliasRoutingConfigurationListItem.Builder> ... routingConfiguration) {
            this.routingConfiguration(Stream.of(routingConfiguration).map(c -> (FlowAliasRoutingConfigurationListItem)((FlowAliasRoutingConfigurationListItem.Builder)FlowAliasRoutingConfigurationListItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateFlowAliasRequest build() {
            return new UpdateFlowAliasRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BedrockAgentRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateFlowAliasRequest> {
        public Builder aliasIdentifier(String var1);

        public Builder description(String var1);

        public Builder flowIdentifier(String var1);

        public Builder name(String var1);

        public Builder routingConfiguration(Collection<FlowAliasRoutingConfigurationListItem> var1);

        public Builder routingConfiguration(FlowAliasRoutingConfigurationListItem ... var1);

        public Builder routingConfiguration(Consumer<FlowAliasRoutingConfigurationListItem.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

