/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagent.model.RedshiftQueryEngineAwsDataCatalogStorageConfiguration;
import software.amazon.awssdk.services.bedrockagent.model.RedshiftQueryEngineRedshiftStorageConfiguration;
import software.amazon.awssdk.services.bedrockagent.model.RedshiftQueryEngineStorageType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RedshiftQueryEngineStorageConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RedshiftQueryEngineStorageConfiguration> {
    private static final SdkField<RedshiftQueryEngineAwsDataCatalogStorageConfiguration> AWS_DATA_CATALOG_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("awsDataCatalogConfiguration").getter(RedshiftQueryEngineStorageConfiguration.getter(RedshiftQueryEngineStorageConfiguration::awsDataCatalogConfiguration)).setter(RedshiftQueryEngineStorageConfiguration.setter(Builder::awsDataCatalogConfiguration)).constructor(RedshiftQueryEngineAwsDataCatalogStorageConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsDataCatalogConfiguration").build()}).build();
    private static final SdkField<RedshiftQueryEngineRedshiftStorageConfiguration> REDSHIFT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("redshiftConfiguration").getter(RedshiftQueryEngineStorageConfiguration.getter(RedshiftQueryEngineStorageConfiguration::redshiftConfiguration)).setter(RedshiftQueryEngineStorageConfiguration.setter(Builder::redshiftConfiguration)).constructor(RedshiftQueryEngineRedshiftStorageConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("redshiftConfiguration").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(RedshiftQueryEngineStorageConfiguration.getter(RedshiftQueryEngineStorageConfiguration::typeAsString)).setter(RedshiftQueryEngineStorageConfiguration.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_DATA_CATALOG_CONFIGURATION_FIELD, REDSHIFT_CONFIGURATION_FIELD, TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RedshiftQueryEngineStorageConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final RedshiftQueryEngineAwsDataCatalogStorageConfiguration awsDataCatalogConfiguration;
    private final RedshiftQueryEngineRedshiftStorageConfiguration redshiftConfiguration;
    private final String type;

    private RedshiftQueryEngineStorageConfiguration(BuilderImpl builder) {
        this.awsDataCatalogConfiguration = builder.awsDataCatalogConfiguration;
        this.redshiftConfiguration = builder.redshiftConfiguration;
        this.type = builder.type;
    }

    public final RedshiftQueryEngineAwsDataCatalogStorageConfiguration awsDataCatalogConfiguration() {
        return this.awsDataCatalogConfiguration;
    }

    public final RedshiftQueryEngineRedshiftStorageConfiguration redshiftConfiguration() {
        return this.redshiftConfiguration;
    }

    public final RedshiftQueryEngineStorageType type() {
        return RedshiftQueryEngineStorageType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.awsDataCatalogConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.redshiftConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RedshiftQueryEngineStorageConfiguration)) {
            return false;
        }
        RedshiftQueryEngineStorageConfiguration other = (RedshiftQueryEngineStorageConfiguration)obj;
        return Objects.equals(this.awsDataCatalogConfiguration(), other.awsDataCatalogConfiguration()) && Objects.equals(this.redshiftConfiguration(), other.redshiftConfiguration()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"RedshiftQueryEngineStorageConfiguration").add("AwsDataCatalogConfiguration", (Object)this.awsDataCatalogConfiguration()).add("RedshiftConfiguration", (Object)this.redshiftConfiguration()).add("Type", (Object)this.typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "awsDataCatalogConfiguration": {
                return Optional.ofNullable(clazz.cast(this.awsDataCatalogConfiguration()));
            }
            case "redshiftConfiguration": {
                return Optional.ofNullable(clazz.cast(this.redshiftConfiguration()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("awsDataCatalogConfiguration", AWS_DATA_CATALOG_CONFIGURATION_FIELD);
        map.put("redshiftConfiguration", REDSHIFT_CONFIGURATION_FIELD);
        map.put("type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RedshiftQueryEngineStorageConfiguration, T> g) {
        return obj -> g.apply((RedshiftQueryEngineStorageConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private RedshiftQueryEngineAwsDataCatalogStorageConfiguration awsDataCatalogConfiguration;
        private RedshiftQueryEngineRedshiftStorageConfiguration redshiftConfiguration;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(RedshiftQueryEngineStorageConfiguration model) {
            this.awsDataCatalogConfiguration(model.awsDataCatalogConfiguration);
            this.redshiftConfiguration(model.redshiftConfiguration);
            this.type(model.type);
        }

        public final RedshiftQueryEngineAwsDataCatalogStorageConfiguration.Builder getAwsDataCatalogConfiguration() {
            return this.awsDataCatalogConfiguration != null ? this.awsDataCatalogConfiguration.toBuilder() : null;
        }

        public final void setAwsDataCatalogConfiguration(RedshiftQueryEngineAwsDataCatalogStorageConfiguration.BuilderImpl awsDataCatalogConfiguration) {
            this.awsDataCatalogConfiguration = awsDataCatalogConfiguration != null ? awsDataCatalogConfiguration.build() : null;
        }

        @Override
        public final Builder awsDataCatalogConfiguration(RedshiftQueryEngineAwsDataCatalogStorageConfiguration awsDataCatalogConfiguration) {
            this.awsDataCatalogConfiguration = awsDataCatalogConfiguration;
            return this;
        }

        public final RedshiftQueryEngineRedshiftStorageConfiguration.Builder getRedshiftConfiguration() {
            return this.redshiftConfiguration != null ? this.redshiftConfiguration.toBuilder() : null;
        }

        public final void setRedshiftConfiguration(RedshiftQueryEngineRedshiftStorageConfiguration.BuilderImpl redshiftConfiguration) {
            this.redshiftConfiguration = redshiftConfiguration != null ? redshiftConfiguration.build() : null;
        }

        @Override
        public final Builder redshiftConfiguration(RedshiftQueryEngineRedshiftStorageConfiguration redshiftConfiguration) {
            this.redshiftConfiguration = redshiftConfiguration;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RedshiftQueryEngineStorageType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public RedshiftQueryEngineStorageConfiguration build() {
            return new RedshiftQueryEngineStorageConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RedshiftQueryEngineStorageConfiguration> {
        public Builder awsDataCatalogConfiguration(RedshiftQueryEngineAwsDataCatalogStorageConfiguration var1);

        default public Builder awsDataCatalogConfiguration(Consumer<RedshiftQueryEngineAwsDataCatalogStorageConfiguration.Builder> awsDataCatalogConfiguration) {
            return this.awsDataCatalogConfiguration((RedshiftQueryEngineAwsDataCatalogStorageConfiguration)((RedshiftQueryEngineAwsDataCatalogStorageConfiguration.Builder)RedshiftQueryEngineAwsDataCatalogStorageConfiguration.builder().applyMutation(awsDataCatalogConfiguration)).build());
        }

        public Builder redshiftConfiguration(RedshiftQueryEngineRedshiftStorageConfiguration var1);

        default public Builder redshiftConfiguration(Consumer<RedshiftQueryEngineRedshiftStorageConfiguration.Builder> redshiftConfiguration) {
            return this.redshiftConfiguration((RedshiftQueryEngineRedshiftStorageConfiguration)((RedshiftQueryEngineRedshiftStorageConfiguration.Builder)RedshiftQueryEngineRedshiftStorageConfiguration.builder().applyMutation(redshiftConfiguration)).build());
        }

        public Builder type(String var1);

        public Builder type(RedshiftQueryEngineStorageType var1);
    }
}

