/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagent.model.CustomS3Location;
import software.amazon.awssdk.services.bedrockagent.model.DocumentMetadataInlineAttributesListCopier;
import software.amazon.awssdk.services.bedrockagent.model.MetadataAttribute;
import software.amazon.awssdk.services.bedrockagent.model.MetadataSourceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DocumentMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DocumentMetadata> {
    private static final SdkField<List<MetadataAttribute>> INLINE_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("inlineAttributes").getter(DocumentMetadata.getter(DocumentMetadata::inlineAttributes)).setter(DocumentMetadata.setter(Builder::inlineAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inlineAttributes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MetadataAttribute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<CustomS3Location> S3_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("s3Location").getter(DocumentMetadata.getter(DocumentMetadata::s3Location)).setter(DocumentMetadata.setter(Builder::s3Location)).constructor(CustomS3Location::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Location").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(DocumentMetadata.getter(DocumentMetadata::typeAsString)).setter(DocumentMetadata.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INLINE_ATTRIBUTES_FIELD, S3_LOCATION_FIELD, TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DocumentMetadata.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<MetadataAttribute> inlineAttributes;
    private final CustomS3Location s3Location;
    private final String type;

    private DocumentMetadata(BuilderImpl builder) {
        this.inlineAttributes = builder.inlineAttributes;
        this.s3Location = builder.s3Location;
        this.type = builder.type;
    }

    public final boolean hasInlineAttributes() {
        return this.inlineAttributes != null && !(this.inlineAttributes instanceof SdkAutoConstructList);
    }

    public final List<MetadataAttribute> inlineAttributes() {
        return this.inlineAttributes;
    }

    public final CustomS3Location s3Location() {
        return this.s3Location;
    }

    public final MetadataSourceType type() {
        return MetadataSourceType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInlineAttributes() ? this.inlineAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Location());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentMetadata)) {
            return false;
        }
        DocumentMetadata other = (DocumentMetadata)obj;
        return this.hasInlineAttributes() == other.hasInlineAttributes() && Objects.equals(this.inlineAttributes(), other.inlineAttributes()) && Objects.equals(this.s3Location(), other.s3Location()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DocumentMetadata").add("InlineAttributes", this.hasInlineAttributes() ? this.inlineAttributes() : null).add("S3Location", (Object)this.s3Location()).add("Type", (Object)this.typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "inlineAttributes": {
                return Optional.ofNullable(clazz.cast(this.inlineAttributes()));
            }
            case "s3Location": {
                return Optional.ofNullable(clazz.cast(this.s3Location()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("inlineAttributes", INLINE_ATTRIBUTES_FIELD);
        map.put("s3Location", S3_LOCATION_FIELD);
        map.put("type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DocumentMetadata, T> g) {
        return obj -> g.apply((DocumentMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<MetadataAttribute> inlineAttributes = DefaultSdkAutoConstructList.getInstance();
        private CustomS3Location s3Location;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentMetadata model) {
            this.inlineAttributes(model.inlineAttributes);
            this.s3Location(model.s3Location);
            this.type(model.type);
        }

        public final List<MetadataAttribute.Builder> getInlineAttributes() {
            List<MetadataAttribute.Builder> result = DocumentMetadataInlineAttributesListCopier.copyToBuilder(this.inlineAttributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInlineAttributes(Collection<MetadataAttribute.BuilderImpl> inlineAttributes) {
            this.inlineAttributes = DocumentMetadataInlineAttributesListCopier.copyFromBuilder(inlineAttributes);
        }

        @Override
        public final Builder inlineAttributes(Collection<MetadataAttribute> inlineAttributes) {
            this.inlineAttributes = DocumentMetadataInlineAttributesListCopier.copy(inlineAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inlineAttributes(MetadataAttribute ... inlineAttributes) {
            this.inlineAttributes(Arrays.asList(inlineAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inlineAttributes(Consumer<MetadataAttribute.Builder> ... inlineAttributes) {
            this.inlineAttributes(Stream.of(inlineAttributes).map(c -> (MetadataAttribute)((MetadataAttribute.Builder)MetadataAttribute.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final CustomS3Location.Builder getS3Location() {
            return this.s3Location != null ? this.s3Location.toBuilder() : null;
        }

        public final void setS3Location(CustomS3Location.BuilderImpl s3Location) {
            this.s3Location = s3Location != null ? s3Location.build() : null;
        }

        @Override
        public final Builder s3Location(CustomS3Location s3Location) {
            this.s3Location = s3Location;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(MetadataSourceType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public DocumentMetadata build() {
            return new DocumentMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DocumentMetadata> {
        public Builder inlineAttributes(Collection<MetadataAttribute> var1);

        public Builder inlineAttributes(MetadataAttribute ... var1);

        public Builder inlineAttributes(Consumer<MetadataAttribute.Builder> ... var1);

        public Builder s3Location(CustomS3Location var1);

        default public Builder s3Location(Consumer<CustomS3Location.Builder> s3Location) {
            return this.s3Location((CustomS3Location)((CustomS3Location.Builder)CustomS3Location.builder().applyMutation(s3Location)).build());
        }

        public Builder type(String var1);

        public Builder type(MetadataSourceType var1);
    }
}

