/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagent.model.AgentAliasRoutingConfigurationCopier;
import software.amazon.awssdk.services.bedrockagent.model.AgentAliasRoutingConfigurationListItem;
import software.amazon.awssdk.services.bedrockagent.model.AgentAliasStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AgentAliasSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AgentAliasSummary> {
    private static final SdkField<String> AGENT_ALIAS_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("agentAliasId").getter(AgentAliasSummary.getter(AgentAliasSummary::agentAliasId)).setter(AgentAliasSummary.setter(Builder::agentAliasId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentAliasId").build()}).build();
    private static final SdkField<String> AGENT_ALIAS_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("agentAliasName").getter(AgentAliasSummary.getter(AgentAliasSummary::agentAliasName)).setter(AgentAliasSummary.setter(Builder::agentAliasName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentAliasName").build()}).build();
    private static final SdkField<String> AGENT_ALIAS_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("agentAliasStatus").getter(AgentAliasSummary.getter(AgentAliasSummary::agentAliasStatusAsString)).setter(AgentAliasSummary.setter(Builder::agentAliasStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentAliasStatus").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(AgentAliasSummary.getter(AgentAliasSummary::createdAt)).setter(AgentAliasSummary.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(AgentAliasSummary.getter(AgentAliasSummary::description)).setter(AgentAliasSummary.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<List<AgentAliasRoutingConfigurationListItem>> ROUTING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("routingConfiguration").getter(AgentAliasSummary.getter(AgentAliasSummary::routingConfiguration)).setter(AgentAliasSummary.setter(Builder::routingConfiguration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routingConfiguration").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AgentAliasRoutingConfigurationListItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(AgentAliasSummary.getter(AgentAliasSummary::updatedAt)).setter(AgentAliasSummary.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_ALIAS_ID_FIELD, AGENT_ALIAS_NAME_FIELD, AGENT_ALIAS_STATUS_FIELD, CREATED_AT_FIELD, DESCRIPTION_FIELD, ROUTING_CONFIGURATION_FIELD, UPDATED_AT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("agentAliasId", AGENT_ALIAS_ID_FIELD);
            this.put("agentAliasName", AGENT_ALIAS_NAME_FIELD);
            this.put("agentAliasStatus", AGENT_ALIAS_STATUS_FIELD);
            this.put("createdAt", CREATED_AT_FIELD);
            this.put("description", DESCRIPTION_FIELD);
            this.put("routingConfiguration", ROUTING_CONFIGURATION_FIELD);
            this.put("updatedAt", UPDATED_AT_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String agentAliasId;
    private final String agentAliasName;
    private final String agentAliasStatus;
    private final Instant createdAt;
    private final String description;
    private final List<AgentAliasRoutingConfigurationListItem> routingConfiguration;
    private final Instant updatedAt;

    private AgentAliasSummary(BuilderImpl builder) {
        this.agentAliasId = builder.agentAliasId;
        this.agentAliasName = builder.agentAliasName;
        this.agentAliasStatus = builder.agentAliasStatus;
        this.createdAt = builder.createdAt;
        this.description = builder.description;
        this.routingConfiguration = builder.routingConfiguration;
        this.updatedAt = builder.updatedAt;
    }

    public final String agentAliasId() {
        return this.agentAliasId;
    }

    public final String agentAliasName() {
        return this.agentAliasName;
    }

    public final AgentAliasStatus agentAliasStatus() {
        return AgentAliasStatus.fromValue(this.agentAliasStatus);
    }

    public final String agentAliasStatusAsString() {
        return this.agentAliasStatus;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasRoutingConfiguration() {
        return this.routingConfiguration != null && !(this.routingConfiguration instanceof SdkAutoConstructList);
    }

    public final List<AgentAliasRoutingConfigurationListItem> routingConfiguration() {
        return this.routingConfiguration;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.agentAliasId());
        hashCode = 31 * hashCode + Objects.hashCode(this.agentAliasName());
        hashCode = 31 * hashCode + Objects.hashCode(this.agentAliasStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRoutingConfiguration() ? this.routingConfiguration() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AgentAliasSummary)) {
            return false;
        }
        AgentAliasSummary other = (AgentAliasSummary)obj;
        return Objects.equals(this.agentAliasId(), other.agentAliasId()) && Objects.equals(this.agentAliasName(), other.agentAliasName()) && Objects.equals(this.agentAliasStatusAsString(), other.agentAliasStatusAsString()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.description(), other.description()) && this.hasRoutingConfiguration() == other.hasRoutingConfiguration() && Objects.equals(this.routingConfiguration(), other.routingConfiguration()) && Objects.equals(this.updatedAt(), other.updatedAt());
    }

    public final String toString() {
        return ToString.builder((String)"AgentAliasSummary").add("AgentAliasId", (Object)this.agentAliasId()).add("AgentAliasName", (Object)this.agentAliasName()).add("AgentAliasStatus", (Object)this.agentAliasStatusAsString()).add("CreatedAt", (Object)this.createdAt()).add("Description", (Object)this.description()).add("RoutingConfiguration", this.hasRoutingConfiguration() ? this.routingConfiguration() : null).add("UpdatedAt", (Object)this.updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "agentAliasId": {
                return Optional.ofNullable(clazz.cast(this.agentAliasId()));
            }
            case "agentAliasName": {
                return Optional.ofNullable(clazz.cast(this.agentAliasName()));
            }
            case "agentAliasStatus": {
                return Optional.ofNullable(clazz.cast(this.agentAliasStatusAsString()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "routingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.routingConfiguration()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AgentAliasSummary, T> g) {
        return obj -> g.apply((AgentAliasSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String agentAliasId;
        private String agentAliasName;
        private String agentAliasStatus;
        private Instant createdAt;
        private String description;
        private List<AgentAliasRoutingConfigurationListItem> routingConfiguration = DefaultSdkAutoConstructList.getInstance();
        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(AgentAliasSummary model) {
            this.agentAliasId(model.agentAliasId);
            this.agentAliasName(model.agentAliasName);
            this.agentAliasStatus(model.agentAliasStatus);
            this.createdAt(model.createdAt);
            this.description(model.description);
            this.routingConfiguration(model.routingConfiguration);
            this.updatedAt(model.updatedAt);
        }

        public final String getAgentAliasId() {
            return this.agentAliasId;
        }

        public final void setAgentAliasId(String agentAliasId) {
            this.agentAliasId = agentAliasId;
        }

        @Override
        public final Builder agentAliasId(String agentAliasId) {
            this.agentAliasId = agentAliasId;
            return this;
        }

        public final String getAgentAliasName() {
            return this.agentAliasName;
        }

        public final void setAgentAliasName(String agentAliasName) {
            this.agentAliasName = agentAliasName;
        }

        @Override
        public final Builder agentAliasName(String agentAliasName) {
            this.agentAliasName = agentAliasName;
            return this;
        }

        public final String getAgentAliasStatus() {
            return this.agentAliasStatus;
        }

        public final void setAgentAliasStatus(String agentAliasStatus) {
            this.agentAliasStatus = agentAliasStatus;
        }

        @Override
        public final Builder agentAliasStatus(String agentAliasStatus) {
            this.agentAliasStatus = agentAliasStatus;
            return this;
        }

        @Override
        public final Builder agentAliasStatus(AgentAliasStatus agentAliasStatus) {
            this.agentAliasStatus(agentAliasStatus == null ? null : agentAliasStatus.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<AgentAliasRoutingConfigurationListItem.Builder> getRoutingConfiguration() {
            List<AgentAliasRoutingConfigurationListItem.Builder> result = AgentAliasRoutingConfigurationCopier.copyToBuilder(this.routingConfiguration);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRoutingConfiguration(Collection<AgentAliasRoutingConfigurationListItem.BuilderImpl> routingConfiguration) {
            this.routingConfiguration = AgentAliasRoutingConfigurationCopier.copyFromBuilder(routingConfiguration);
        }

        @Override
        public final Builder routingConfiguration(Collection<AgentAliasRoutingConfigurationListItem> routingConfiguration) {
            this.routingConfiguration = AgentAliasRoutingConfigurationCopier.copy(routingConfiguration);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routingConfiguration(AgentAliasRoutingConfigurationListItem ... routingConfiguration) {
            this.routingConfiguration(Arrays.asList(routingConfiguration));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routingConfiguration(Consumer<AgentAliasRoutingConfigurationListItem.Builder> ... routingConfiguration) {
            this.routingConfiguration(Stream.of(routingConfiguration).map(c -> (AgentAliasRoutingConfigurationListItem)((AgentAliasRoutingConfigurationListItem.Builder)AgentAliasRoutingConfigurationListItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public AgentAliasSummary build() {
            return new AgentAliasSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AgentAliasSummary> {
        public Builder agentAliasId(String var1);

        public Builder agentAliasName(String var1);

        public Builder agentAliasStatus(String var1);

        public Builder agentAliasStatus(AgentAliasStatus var1);

        public Builder createdAt(Instant var1);

        public Builder description(String var1);

        public Builder routingConfiguration(Collection<AgentAliasRoutingConfigurationListItem> var1);

        public Builder routingConfiguration(AgentAliasRoutingConfigurationListItem ... var1);

        public Builder routingConfiguration(Consumer<AgentAliasRoutingConfigurationListItem.Builder> ... var1);

        public Builder updatedAt(Instant var1);
    }
}

