/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrockagent.BedrockAgentAsyncClient;
import software.amazon.awssdk.services.bedrockagent.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrockagent.model.FlowAliasSummary;
import software.amazon.awssdk.services.bedrockagent.model.ListFlowAliasesRequest;
import software.amazon.awssdk.services.bedrockagent.model.ListFlowAliasesResponse;

public class ListFlowAliasesPublisher
implements SdkPublisher<ListFlowAliasesResponse> {
    private final BedrockAgentAsyncClient client;
    private final ListFlowAliasesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListFlowAliasesPublisher(BedrockAgentAsyncClient client, ListFlowAliasesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListFlowAliasesPublisher(BedrockAgentAsyncClient client, ListFlowAliasesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListFlowAliasesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListFlowAliasesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<FlowAliasSummary> flowAliasSummaries() {
        Function<ListFlowAliasesResponse, Iterator> getIterator = response -> {
            if (response != null && response.flowAliasSummaries() != null) {
                return response.flowAliasSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListFlowAliasesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListFlowAliasesResponseFetcher
    implements AsyncPageFetcher<ListFlowAliasesResponse> {
        private ListFlowAliasesResponseFetcher() {
        }

        public boolean hasNextPage(ListFlowAliasesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListFlowAliasesResponse> nextPage(ListFlowAliasesResponse previousPage) {
            if (previousPage == null) {
                return ListFlowAliasesPublisher.this.client.listFlowAliases(ListFlowAliasesPublisher.this.firstRequest);
            }
            return ListFlowAliasesPublisher.this.client.listFlowAliases((ListFlowAliasesRequest)((Object)ListFlowAliasesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

