/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagent.model.QueryEngineType;
import software.amazon.awssdk.services.bedrockagent.model.RedshiftConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SqlKnowledgeBaseConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SqlKnowledgeBaseConfiguration> {
    private static final SdkField<RedshiftConfiguration> REDSHIFT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("redshiftConfiguration").getter(SqlKnowledgeBaseConfiguration.getter(SqlKnowledgeBaseConfiguration::redshiftConfiguration)).setter(SqlKnowledgeBaseConfiguration.setter(Builder::redshiftConfiguration)).constructor(RedshiftConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("redshiftConfiguration").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(SqlKnowledgeBaseConfiguration.getter(SqlKnowledgeBaseConfiguration::typeAsString)).setter(SqlKnowledgeBaseConfiguration.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REDSHIFT_CONFIGURATION_FIELD, TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("redshiftConfiguration", REDSHIFT_CONFIGURATION_FIELD);
            this.put("type", TYPE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final RedshiftConfiguration redshiftConfiguration;
    private final String type;

    private SqlKnowledgeBaseConfiguration(BuilderImpl builder) {
        this.redshiftConfiguration = builder.redshiftConfiguration;
        this.type = builder.type;
    }

    public final RedshiftConfiguration redshiftConfiguration() {
        return this.redshiftConfiguration;
    }

    public final QueryEngineType type() {
        return QueryEngineType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.redshiftConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SqlKnowledgeBaseConfiguration)) {
            return false;
        }
        SqlKnowledgeBaseConfiguration other = (SqlKnowledgeBaseConfiguration)obj;
        return Objects.equals(this.redshiftConfiguration(), other.redshiftConfiguration()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"SqlKnowledgeBaseConfiguration").add("RedshiftConfiguration", (Object)this.redshiftConfiguration()).add("Type", (Object)this.typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "redshiftConfiguration": {
                return Optional.ofNullable(clazz.cast(this.redshiftConfiguration()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SqlKnowledgeBaseConfiguration, T> g) {
        return obj -> g.apply((SqlKnowledgeBaseConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private RedshiftConfiguration redshiftConfiguration;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(SqlKnowledgeBaseConfiguration model) {
            this.redshiftConfiguration(model.redshiftConfiguration);
            this.type(model.type);
        }

        public final RedshiftConfiguration.Builder getRedshiftConfiguration() {
            return this.redshiftConfiguration != null ? this.redshiftConfiguration.toBuilder() : null;
        }

        public final void setRedshiftConfiguration(RedshiftConfiguration.BuilderImpl redshiftConfiguration) {
            this.redshiftConfiguration = redshiftConfiguration != null ? redshiftConfiguration.build() : null;
        }

        @Override
        public final Builder redshiftConfiguration(RedshiftConfiguration redshiftConfiguration) {
            this.redshiftConfiguration = redshiftConfiguration;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(QueryEngineType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public SqlKnowledgeBaseConfiguration build() {
            return new SqlKnowledgeBaseConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SqlKnowledgeBaseConfiguration> {
        public Builder redshiftConfiguration(RedshiftConfiguration var1);

        default public Builder redshiftConfiguration(Consumer<RedshiftConfiguration.Builder> redshiftConfiguration) {
            return this.redshiftConfiguration((RedshiftConfiguration)((RedshiftConfiguration.Builder)RedshiftConfiguration.builder().applyMutation(redshiftConfiguration)).build());
        }

        public Builder type(String var1);

        public Builder type(QueryEngineType var1);
    }
}

