/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum FlowValidationType {
    CYCLIC_CONNECTION("CyclicConnection"),
    DUPLICATE_CONNECTIONS("DuplicateConnections"),
    DUPLICATE_CONDITION_EXPRESSION("DuplicateConditionExpression"),
    UNREACHABLE_NODE("UnreachableNode"),
    UNKNOWN_CONNECTION_SOURCE("UnknownConnectionSource"),
    UNKNOWN_CONNECTION_SOURCE_OUTPUT("UnknownConnectionSourceOutput"),
    UNKNOWN_CONNECTION_TARGET("UnknownConnectionTarget"),
    UNKNOWN_CONNECTION_TARGET_INPUT("UnknownConnectionTargetInput"),
    UNKNOWN_CONNECTION_CONDITION("UnknownConnectionCondition"),
    MALFORMED_CONDITION_EXPRESSION("MalformedConditionExpression"),
    MALFORMED_NODE_INPUT_EXPRESSION("MalformedNodeInputExpression"),
    MISMATCHED_NODE_INPUT_TYPE("MismatchedNodeInputType"),
    MISMATCHED_NODE_OUTPUT_TYPE("MismatchedNodeOutputType"),
    INCOMPATIBLE_CONNECTION_DATA_TYPE("IncompatibleConnectionDataType"),
    MISSING_CONNECTION_CONFIGURATION("MissingConnectionConfiguration"),
    MISSING_DEFAULT_CONDITION("MissingDefaultCondition"),
    MISSING_ENDING_NODES("MissingEndingNodes"),
    MISSING_NODE_CONFIGURATION("MissingNodeConfiguration"),
    MISSING_NODE_INPUT("MissingNodeInput"),
    MISSING_NODE_OUTPUT("MissingNodeOutput"),
    MISSING_STARTING_NODES("MissingStartingNodes"),
    MULTIPLE_NODE_INPUT_CONNECTIONS("MultipleNodeInputConnections"),
    UNFULFILLED_NODE_INPUT("UnfulfilledNodeInput"),
    UNSATISFIED_CONNECTION_CONDITIONS("UnsatisfiedConnectionConditions"),
    UNSPECIFIED("Unspecified"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, FlowValidationType> VALUE_MAP;
    private final String value;

    private FlowValidationType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FlowValidationType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FlowValidationType> knownValues() {
        EnumSet<FlowValidationType> knownValues = EnumSet.allOf(FlowValidationType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(FlowValidationType.class, FlowValidationType::toString);
    }
}

