/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagent.model.RedshiftProvisionedConfiguration;
import software.amazon.awssdk.services.bedrockagent.model.RedshiftQueryEngineType;
import software.amazon.awssdk.services.bedrockagent.model.RedshiftServerlessConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RedshiftQueryEngineConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RedshiftQueryEngineConfiguration> {
    private static final SdkField<RedshiftProvisionedConfiguration> PROVISIONED_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("provisionedConfiguration").getter(RedshiftQueryEngineConfiguration.getter(RedshiftQueryEngineConfiguration::provisionedConfiguration)).setter(RedshiftQueryEngineConfiguration.setter(Builder::provisionedConfiguration)).constructor(RedshiftProvisionedConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provisionedConfiguration").build()}).build();
    private static final SdkField<RedshiftServerlessConfiguration> SERVERLESS_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("serverlessConfiguration").getter(RedshiftQueryEngineConfiguration.getter(RedshiftQueryEngineConfiguration::serverlessConfiguration)).setter(RedshiftQueryEngineConfiguration.setter(Builder::serverlessConfiguration)).constructor(RedshiftServerlessConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverlessConfiguration").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(RedshiftQueryEngineConfiguration.getter(RedshiftQueryEngineConfiguration::typeAsString)).setter(RedshiftQueryEngineConfiguration.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROVISIONED_CONFIGURATION_FIELD, SERVERLESS_CONFIGURATION_FIELD, TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("provisionedConfiguration", PROVISIONED_CONFIGURATION_FIELD);
            this.put("serverlessConfiguration", SERVERLESS_CONFIGURATION_FIELD);
            this.put("type", TYPE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final RedshiftProvisionedConfiguration provisionedConfiguration;
    private final RedshiftServerlessConfiguration serverlessConfiguration;
    private final String type;

    private RedshiftQueryEngineConfiguration(BuilderImpl builder) {
        this.provisionedConfiguration = builder.provisionedConfiguration;
        this.serverlessConfiguration = builder.serverlessConfiguration;
        this.type = builder.type;
    }

    public final RedshiftProvisionedConfiguration provisionedConfiguration() {
        return this.provisionedConfiguration;
    }

    public final RedshiftServerlessConfiguration serverlessConfiguration() {
        return this.serverlessConfiguration;
    }

    public final RedshiftQueryEngineType type() {
        return RedshiftQueryEngineType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionedConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverlessConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RedshiftQueryEngineConfiguration)) {
            return false;
        }
        RedshiftQueryEngineConfiguration other = (RedshiftQueryEngineConfiguration)obj;
        return Objects.equals(this.provisionedConfiguration(), other.provisionedConfiguration()) && Objects.equals(this.serverlessConfiguration(), other.serverlessConfiguration()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"RedshiftQueryEngineConfiguration").add("ProvisionedConfiguration", (Object)this.provisionedConfiguration()).add("ServerlessConfiguration", (Object)this.serverlessConfiguration()).add("Type", (Object)this.typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "provisionedConfiguration": {
                return Optional.ofNullable(clazz.cast(this.provisionedConfiguration()));
            }
            case "serverlessConfiguration": {
                return Optional.ofNullable(clazz.cast(this.serverlessConfiguration()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RedshiftQueryEngineConfiguration, T> g) {
        return obj -> g.apply((RedshiftQueryEngineConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private RedshiftProvisionedConfiguration provisionedConfiguration;
        private RedshiftServerlessConfiguration serverlessConfiguration;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(RedshiftQueryEngineConfiguration model) {
            this.provisionedConfiguration(model.provisionedConfiguration);
            this.serverlessConfiguration(model.serverlessConfiguration);
            this.type(model.type);
        }

        public final RedshiftProvisionedConfiguration.Builder getProvisionedConfiguration() {
            return this.provisionedConfiguration != null ? this.provisionedConfiguration.toBuilder() : null;
        }

        public final void setProvisionedConfiguration(RedshiftProvisionedConfiguration.BuilderImpl provisionedConfiguration) {
            this.provisionedConfiguration = provisionedConfiguration != null ? provisionedConfiguration.build() : null;
        }

        @Override
        public final Builder provisionedConfiguration(RedshiftProvisionedConfiguration provisionedConfiguration) {
            this.provisionedConfiguration = provisionedConfiguration;
            return this;
        }

        public final RedshiftServerlessConfiguration.Builder getServerlessConfiguration() {
            return this.serverlessConfiguration != null ? this.serverlessConfiguration.toBuilder() : null;
        }

        public final void setServerlessConfiguration(RedshiftServerlessConfiguration.BuilderImpl serverlessConfiguration) {
            this.serverlessConfiguration = serverlessConfiguration != null ? serverlessConfiguration.build() : null;
        }

        @Override
        public final Builder serverlessConfiguration(RedshiftServerlessConfiguration serverlessConfiguration) {
            this.serverlessConfiguration = serverlessConfiguration;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RedshiftQueryEngineType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public RedshiftQueryEngineConfiguration build() {
            return new RedshiftQueryEngineConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RedshiftQueryEngineConfiguration> {
        public Builder provisionedConfiguration(RedshiftProvisionedConfiguration var1);

        default public Builder provisionedConfiguration(Consumer<RedshiftProvisionedConfiguration.Builder> provisionedConfiguration) {
            return this.provisionedConfiguration((RedshiftProvisionedConfiguration)((RedshiftProvisionedConfiguration.Builder)RedshiftProvisionedConfiguration.builder().applyMutation(provisionedConfiguration)).build());
        }

        public Builder serverlessConfiguration(RedshiftServerlessConfiguration var1);

        default public Builder serverlessConfiguration(Consumer<RedshiftServerlessConfiguration.Builder> serverlessConfiguration) {
            return this.serverlessConfiguration((RedshiftServerlessConfiguration)((RedshiftServerlessConfiguration.Builder)RedshiftServerlessConfiguration.builder().applyMutation(serverlessConfiguration)).build());
        }

        public Builder type(String var1);

        public Builder type(RedshiftQueryEngineType var1);
    }
}

