/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CustomSourceType {
    IN_LINE("IN_LINE"),
    S3_LOCATION("S3_LOCATION"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CustomSourceType> VALUE_MAP;
    private final String value;

    private CustomSourceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CustomSourceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CustomSourceType> knownValues() {
        EnumSet<CustomSourceType> knownValues = EnumSet.allOf(CustomSourceType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CustomSourceType.class, CustomSourceType::toString);
    }
}

