/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the information of an Agent Knowledge Base.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AgentKnowledgeBase implements SdkPojo, Serializable,
        ToCopyableBuilder<AgentKnowledgeBase.Builder, AgentKnowledgeBase> {
    private static final SdkField<String> AGENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agentId").getter(getter(AgentKnowledgeBase::agentId)).setter(setter(Builder::agentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentId").build()).build();

    private static final SdkField<String> AGENT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agentVersion").getter(getter(AgentKnowledgeBase::agentVersion)).setter(setter(Builder::agentVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentVersion").build()).build();

    private static final SdkField<String> KNOWLEDGE_BASE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("knowledgeBaseId").getter(getter(AgentKnowledgeBase::knowledgeBaseId))
            .setter(setter(Builder::knowledgeBaseId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeBaseId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(AgentKnowledgeBase::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(AgentKnowledgeBase::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt")
            .getter(getter(AgentKnowledgeBase::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> KNOWLEDGE_BASE_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("knowledgeBaseState").getter(getter(AgentKnowledgeBase::knowledgeBaseStateAsString))
            .setter(setter(Builder::knowledgeBaseState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeBaseState").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_ID_FIELD,
            AGENT_VERSION_FIELD, KNOWLEDGE_BASE_ID_FIELD, DESCRIPTION_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD,
            KNOWLEDGE_BASE_STATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String agentId;

    private final String agentVersion;

    private final String knowledgeBaseId;

    private final String description;

    private final Instant createdAt;

    private final Instant updatedAt;

    private final String knowledgeBaseState;

    private AgentKnowledgeBase(BuilderImpl builder) {
        this.agentId = builder.agentId;
        this.agentVersion = builder.agentVersion;
        this.knowledgeBaseId = builder.knowledgeBaseId;
        this.description = builder.description;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.knowledgeBaseState = builder.knowledgeBaseState;
    }

    /**
     * Returns the value of the AgentId property for this object.
     * 
     * @return The value of the AgentId property for this object.
     */
    public final String agentId() {
        return agentId;
    }

    /**
     * Returns the value of the AgentVersion property for this object.
     * 
     * @return The value of the AgentVersion property for this object.
     */
    public final String agentVersion() {
        return agentVersion;
    }

    /**
     * Returns the value of the KnowledgeBaseId property for this object.
     * 
     * @return The value of the KnowledgeBaseId property for this object.
     */
    public final String knowledgeBaseId() {
        return knowledgeBaseId;
    }

    /**
     * Returns the value of the Description property for this object.
     * 
     * @return The value of the Description property for this object.
     */
    public final String description() {
        return description;
    }

    /**
     * Returns the value of the CreatedAt property for this object.
     * 
     * @return The value of the CreatedAt property for this object.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * Returns the value of the UpdatedAt property for this object.
     * 
     * @return The value of the UpdatedAt property for this object.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * Returns the value of the KnowledgeBaseState property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #knowledgeBaseState} will return {@link KnowledgeBaseState#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #knowledgeBaseStateAsString}.
     * </p>
     * 
     * @return The value of the KnowledgeBaseState property for this object.
     * @see KnowledgeBaseState
     */
    public final KnowledgeBaseState knowledgeBaseState() {
        return KnowledgeBaseState.fromValue(knowledgeBaseState);
    }

    /**
     * Returns the value of the KnowledgeBaseState property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #knowledgeBaseState} will return {@link KnowledgeBaseState#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #knowledgeBaseStateAsString}.
     * </p>
     * 
     * @return The value of the KnowledgeBaseState property for this object.
     * @see KnowledgeBaseState
     */
    public final String knowledgeBaseStateAsString() {
        return knowledgeBaseState;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(agentId());
        hashCode = 31 * hashCode + Objects.hashCode(agentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(knowledgeBaseId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(knowledgeBaseStateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AgentKnowledgeBase)) {
            return false;
        }
        AgentKnowledgeBase other = (AgentKnowledgeBase) obj;
        return Objects.equals(agentId(), other.agentId()) && Objects.equals(agentVersion(), other.agentVersion())
                && Objects.equals(knowledgeBaseId(), other.knowledgeBaseId())
                && Objects.equals(description(), other.description()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(updatedAt(), other.updatedAt())
                && Objects.equals(knowledgeBaseStateAsString(), other.knowledgeBaseStateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AgentKnowledgeBase").add("AgentId", agentId()).add("AgentVersion", agentVersion())
                .add("KnowledgeBaseId", knowledgeBaseId()).add("Description", description()).add("CreatedAt", createdAt())
                .add("UpdatedAt", updatedAt()).add("KnowledgeBaseState", knowledgeBaseStateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "agentId":
            return Optional.ofNullable(clazz.cast(agentId()));
        case "agentVersion":
            return Optional.ofNullable(clazz.cast(agentVersion()));
        case "knowledgeBaseId":
            return Optional.ofNullable(clazz.cast(knowledgeBaseId()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "knowledgeBaseState":
            return Optional.ofNullable(clazz.cast(knowledgeBaseStateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AgentKnowledgeBase, T> g) {
        return obj -> g.apply((AgentKnowledgeBase) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AgentKnowledgeBase> {
        /**
         * Sets the value of the AgentId property for this object.
         *
         * @param agentId
         *        The new value for the AgentId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentId(String agentId);

        /**
         * Sets the value of the AgentVersion property for this object.
         *
         * @param agentVersion
         *        The new value for the AgentVersion property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentVersion(String agentVersion);

        /**
         * Sets the value of the KnowledgeBaseId property for this object.
         *
         * @param knowledgeBaseId
         *        The new value for the KnowledgeBaseId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder knowledgeBaseId(String knowledgeBaseId);

        /**
         * Sets the value of the Description property for this object.
         *
         * @param description
         *        The new value for the Description property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * Sets the value of the CreatedAt property for this object.
         *
         * @param createdAt
         *        The new value for the CreatedAt property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * Sets the value of the UpdatedAt property for this object.
         *
         * @param updatedAt
         *        The new value for the UpdatedAt property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * Sets the value of the KnowledgeBaseState property for this object.
         *
         * @param knowledgeBaseState
         *        The new value for the KnowledgeBaseState property for this object.
         * @see KnowledgeBaseState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KnowledgeBaseState
         */
        Builder knowledgeBaseState(String knowledgeBaseState);

        /**
         * Sets the value of the KnowledgeBaseState property for this object.
         *
         * @param knowledgeBaseState
         *        The new value for the KnowledgeBaseState property for this object.
         * @see KnowledgeBaseState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KnowledgeBaseState
         */
        Builder knowledgeBaseState(KnowledgeBaseState knowledgeBaseState);
    }

    static final class BuilderImpl implements Builder {
        private String agentId;

        private String agentVersion;

        private String knowledgeBaseId;

        private String description;

        private Instant createdAt;

        private Instant updatedAt;

        private String knowledgeBaseState;

        private BuilderImpl() {
        }

        private BuilderImpl(AgentKnowledgeBase model) {
            agentId(model.agentId);
            agentVersion(model.agentVersion);
            knowledgeBaseId(model.knowledgeBaseId);
            description(model.description);
            createdAt(model.createdAt);
            updatedAt(model.updatedAt);
            knowledgeBaseState(model.knowledgeBaseState);
        }

        public final String getAgentId() {
            return agentId;
        }

        public final void setAgentId(String agentId) {
            this.agentId = agentId;
        }

        @Override
        public final Builder agentId(String agentId) {
            this.agentId = agentId;
            return this;
        }

        public final String getAgentVersion() {
            return agentVersion;
        }

        public final void setAgentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
        }

        @Override
        public final Builder agentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
            return this;
        }

        public final String getKnowledgeBaseId() {
            return knowledgeBaseId;
        }

        public final void setKnowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
        }

        @Override
        public final Builder knowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getKnowledgeBaseState() {
            return knowledgeBaseState;
        }

        public final void setKnowledgeBaseState(String knowledgeBaseState) {
            this.knowledgeBaseState = knowledgeBaseState;
        }

        @Override
        public final Builder knowledgeBaseState(String knowledgeBaseState) {
            this.knowledgeBaseState = knowledgeBaseState;
            return this;
        }

        @Override
        public final Builder knowledgeBaseState(KnowledgeBaseState knowledgeBaseState) {
            this.knowledgeBaseState(knowledgeBaseState == null ? null : knowledgeBaseState.toString());
            return this;
        }

        @Override
        public AgentKnowledgeBase build() {
            return new AgentKnowledgeBase(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
