/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrock.BedrockAsyncClient;
import software.amazon.awssdk.services.bedrock.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrock.model.AccountEnforcedGuardrailOutputConfiguration;
import software.amazon.awssdk.services.bedrock.model.ListEnforcedGuardrailsConfigurationRequest;
import software.amazon.awssdk.services.bedrock.model.ListEnforcedGuardrailsConfigurationResponse;

public class ListEnforcedGuardrailsConfigurationPublisher
implements SdkPublisher<ListEnforcedGuardrailsConfigurationResponse> {
    private final BedrockAsyncClient client;
    private final ListEnforcedGuardrailsConfigurationRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListEnforcedGuardrailsConfigurationPublisher(BedrockAsyncClient client, ListEnforcedGuardrailsConfigurationRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListEnforcedGuardrailsConfigurationPublisher(BedrockAsyncClient client, ListEnforcedGuardrailsConfigurationRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListEnforcedGuardrailsConfigurationResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListEnforcedGuardrailsConfigurationResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AccountEnforcedGuardrailOutputConfiguration> guardrailsConfig() {
        Function<ListEnforcedGuardrailsConfigurationResponse, Iterator> getIterator = response -> {
            if (response != null && response.guardrailsConfig() != null) {
                return response.guardrailsConfig().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListEnforcedGuardrailsConfigurationResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListEnforcedGuardrailsConfigurationResponseFetcher
    implements AsyncPageFetcher<ListEnforcedGuardrailsConfigurationResponse> {
        private ListEnforcedGuardrailsConfigurationResponseFetcher() {
        }

        public boolean hasNextPage(ListEnforcedGuardrailsConfigurationResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListEnforcedGuardrailsConfigurationResponse> nextPage(ListEnforcedGuardrailsConfigurationResponse previousPage) {
            if (previousPage == null) {
                return ListEnforcedGuardrailsConfigurationPublisher.this.client.listEnforcedGuardrailsConfiguration(ListEnforcedGuardrailsConfigurationPublisher.this.firstRequest);
            }
            return ListEnforcedGuardrailsConfigurationPublisher.this.client.listEnforcedGuardrailsConfiguration((ListEnforcedGuardrailsConfigurationRequest)((Object)ListEnforcedGuardrailsConfigurationPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

