/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ReasoningEffort {
    LOW("low"),
    MEDIUM("medium"),
    HIGH("high"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ReasoningEffort> VALUE_MAP;
    private final String value;

    private ReasoningEffort(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ReasoningEffort fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ReasoningEffort> knownValues() {
        EnumSet<ReasoningEffort> knownValues = EnumSet.allOf(ReasoningEffort.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ReasoningEffort.class, ReasoningEffort::toString);
    }
}

