/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrock.model.GuardrailContentFiltersTierName;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GuardrailContentFiltersTierConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GuardrailContentFiltersTierConfig> {
    private static final SdkField<String> TIER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("tierName").getter(GuardrailContentFiltersTierConfig.getter(GuardrailContentFiltersTierConfig::tierNameAsString)).setter(GuardrailContentFiltersTierConfig.setter(Builder::tierName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tierName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIER_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GuardrailContentFiltersTierConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String tierName;

    private GuardrailContentFiltersTierConfig(BuilderImpl builder) {
        this.tierName = builder.tierName;
    }

    public final GuardrailContentFiltersTierName tierName() {
        return GuardrailContentFiltersTierName.fromValue(this.tierName);
    }

    public final String tierNameAsString() {
        return this.tierName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.tierNameAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GuardrailContentFiltersTierConfig)) {
            return false;
        }
        GuardrailContentFiltersTierConfig other = (GuardrailContentFiltersTierConfig)obj;
        return Objects.equals(this.tierNameAsString(), other.tierNameAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GuardrailContentFiltersTierConfig").add("TierName", (Object)(this.tierNameAsString() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "tierName": {
                return Optional.ofNullable(clazz.cast(this.tierNameAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("tierName", TIER_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GuardrailContentFiltersTierConfig, T> g) {
        return obj -> g.apply((GuardrailContentFiltersTierConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String tierName;

        private BuilderImpl() {
        }

        private BuilderImpl(GuardrailContentFiltersTierConfig model) {
            this.tierName(model.tierName);
        }

        public final String getTierName() {
            return this.tierName;
        }

        public final void setTierName(String tierName) {
            this.tierName = tierName;
        }

        @Override
        public final Builder tierName(String tierName) {
            this.tierName = tierName;
            return this;
        }

        @Override
        public final Builder tierName(GuardrailContentFiltersTierName tierName) {
            this.tierName(tierName == null ? null : tierName.toString());
            return this;
        }

        public GuardrailContentFiltersTierConfig build() {
            return new GuardrailContentFiltersTierConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GuardrailContentFiltersTierConfig> {
        public Builder tierName(String var1);

        public Builder tierName(GuardrailContentFiltersTierName var1);
    }
}

