/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrock.model.CustomizationType;
import software.amazon.awssdk.services.bedrock.model.ModelStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CustomModelSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CustomModelSummary> {
    private static final SdkField<String> MODEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("modelArn").getter(CustomModelSummary.getter(CustomModelSummary::modelArn)).setter(CustomModelSummary.setter(Builder::modelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelArn").build()}).build();
    private static final SdkField<String> MODEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("modelName").getter(CustomModelSummary.getter(CustomModelSummary::modelName)).setter(CustomModelSummary.setter(Builder::modelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelName").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(CustomModelSummary.getter(CustomModelSummary::creationTime)).setter(CustomModelSummary.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> BASE_MODEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("baseModelArn").getter(CustomModelSummary.getter(CustomModelSummary::baseModelArn)).setter(CustomModelSummary.setter(Builder::baseModelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("baseModelArn").build()}).build();
    private static final SdkField<String> BASE_MODEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("baseModelName").getter(CustomModelSummary.getter(CustomModelSummary::baseModelName)).setter(CustomModelSummary.setter(Builder::baseModelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("baseModelName").build()}).build();
    private static final SdkField<String> CUSTOMIZATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("customizationType").getter(CustomModelSummary.getter(CustomModelSummary::customizationTypeAsString)).setter(CustomModelSummary.setter(Builder::customizationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customizationType").build()}).build();
    private static final SdkField<String> OWNER_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ownerAccountId").getter(CustomModelSummary.getter(CustomModelSummary::ownerAccountId)).setter(CustomModelSummary.setter(Builder::ownerAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ownerAccountId").build()}).build();
    private static final SdkField<String> MODEL_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("modelStatus").getter(CustomModelSummary.getter(CustomModelSummary::modelStatusAsString)).setter(CustomModelSummary.setter(Builder::modelStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_ARN_FIELD, MODEL_NAME_FIELD, CREATION_TIME_FIELD, BASE_MODEL_ARN_FIELD, BASE_MODEL_NAME_FIELD, CUSTOMIZATION_TYPE_FIELD, OWNER_ACCOUNT_ID_FIELD, MODEL_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CustomModelSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String modelArn;
    private final String modelName;
    private final Instant creationTime;
    private final String baseModelArn;
    private final String baseModelName;
    private final String customizationType;
    private final String ownerAccountId;
    private final String modelStatus;

    private CustomModelSummary(BuilderImpl builder) {
        this.modelArn = builder.modelArn;
        this.modelName = builder.modelName;
        this.creationTime = builder.creationTime;
        this.baseModelArn = builder.baseModelArn;
        this.baseModelName = builder.baseModelName;
        this.customizationType = builder.customizationType;
        this.ownerAccountId = builder.ownerAccountId;
        this.modelStatus = builder.modelStatus;
    }

    public final String modelArn() {
        return this.modelArn;
    }

    public final String modelName() {
        return this.modelName;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final String baseModelArn() {
        return this.baseModelArn;
    }

    public final String baseModelName() {
        return this.baseModelName;
    }

    public final CustomizationType customizationType() {
        return CustomizationType.fromValue(this.customizationType);
    }

    public final String customizationTypeAsString() {
        return this.customizationType;
    }

    public final String ownerAccountId() {
        return this.ownerAccountId;
    }

    public final ModelStatus modelStatus() {
        return ModelStatus.fromValue(this.modelStatus);
    }

    public final String modelStatusAsString() {
        return this.modelStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.modelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.baseModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.baseModelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.customizationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomModelSummary)) {
            return false;
        }
        CustomModelSummary other = (CustomModelSummary)obj;
        return Objects.equals(this.modelArn(), other.modelArn()) && Objects.equals(this.modelName(), other.modelName()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.baseModelArn(), other.baseModelArn()) && Objects.equals(this.baseModelName(), other.baseModelName()) && Objects.equals(this.customizationTypeAsString(), other.customizationTypeAsString()) && Objects.equals(this.ownerAccountId(), other.ownerAccountId()) && Objects.equals(this.modelStatusAsString(), other.modelStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CustomModelSummary").add("ModelArn", (Object)this.modelArn()).add("ModelName", (Object)this.modelName()).add("CreationTime", (Object)this.creationTime()).add("BaseModelArn", (Object)this.baseModelArn()).add("BaseModelName", (Object)this.baseModelName()).add("CustomizationType", (Object)this.customizationTypeAsString()).add("OwnerAccountId", (Object)this.ownerAccountId()).add("ModelStatus", (Object)this.modelStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "modelArn": {
                return Optional.ofNullable(clazz.cast(this.modelArn()));
            }
            case "modelName": {
                return Optional.ofNullable(clazz.cast(this.modelName()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "baseModelArn": {
                return Optional.ofNullable(clazz.cast(this.baseModelArn()));
            }
            case "baseModelName": {
                return Optional.ofNullable(clazz.cast(this.baseModelName()));
            }
            case "customizationType": {
                return Optional.ofNullable(clazz.cast(this.customizationTypeAsString()));
            }
            case "ownerAccountId": {
                return Optional.ofNullable(clazz.cast(this.ownerAccountId()));
            }
            case "modelStatus": {
                return Optional.ofNullable(clazz.cast(this.modelStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("modelArn", MODEL_ARN_FIELD);
        map.put("modelName", MODEL_NAME_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("baseModelArn", BASE_MODEL_ARN_FIELD);
        map.put("baseModelName", BASE_MODEL_NAME_FIELD);
        map.put("customizationType", CUSTOMIZATION_TYPE_FIELD);
        map.put("ownerAccountId", OWNER_ACCOUNT_ID_FIELD);
        map.put("modelStatus", MODEL_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CustomModelSummary, T> g) {
        return obj -> g.apply((CustomModelSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String modelArn;
        private String modelName;
        private Instant creationTime;
        private String baseModelArn;
        private String baseModelName;
        private String customizationType;
        private String ownerAccountId;
        private String modelStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomModelSummary model) {
            this.modelArn(model.modelArn);
            this.modelName(model.modelName);
            this.creationTime(model.creationTime);
            this.baseModelArn(model.baseModelArn);
            this.baseModelName(model.baseModelName);
            this.customizationType(model.customizationType);
            this.ownerAccountId(model.ownerAccountId);
            this.modelStatus(model.modelStatus);
        }

        public final String getModelArn() {
            return this.modelArn;
        }

        public final void setModelArn(String modelArn) {
            this.modelArn = modelArn;
        }

        @Override
        public final Builder modelArn(String modelArn) {
            this.modelArn = modelArn;
            return this;
        }

        public final String getModelName() {
            return this.modelName;
        }

        public final void setModelName(String modelName) {
            this.modelName = modelName;
        }

        @Override
        public final Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getBaseModelArn() {
            return this.baseModelArn;
        }

        public final void setBaseModelArn(String baseModelArn) {
            this.baseModelArn = baseModelArn;
        }

        @Override
        public final Builder baseModelArn(String baseModelArn) {
            this.baseModelArn = baseModelArn;
            return this;
        }

        public final String getBaseModelName() {
            return this.baseModelName;
        }

        public final void setBaseModelName(String baseModelName) {
            this.baseModelName = baseModelName;
        }

        @Override
        public final Builder baseModelName(String baseModelName) {
            this.baseModelName = baseModelName;
            return this;
        }

        public final String getCustomizationType() {
            return this.customizationType;
        }

        public final void setCustomizationType(String customizationType) {
            this.customizationType = customizationType;
        }

        @Override
        public final Builder customizationType(String customizationType) {
            this.customizationType = customizationType;
            return this;
        }

        @Override
        public final Builder customizationType(CustomizationType customizationType) {
            this.customizationType(customizationType == null ? null : customizationType.toString());
            return this;
        }

        public final String getOwnerAccountId() {
            return this.ownerAccountId;
        }

        public final void setOwnerAccountId(String ownerAccountId) {
            this.ownerAccountId = ownerAccountId;
        }

        @Override
        public final Builder ownerAccountId(String ownerAccountId) {
            this.ownerAccountId = ownerAccountId;
            return this;
        }

        public final String getModelStatus() {
            return this.modelStatus;
        }

        public final void setModelStatus(String modelStatus) {
            this.modelStatus = modelStatus;
        }

        @Override
        public final Builder modelStatus(String modelStatus) {
            this.modelStatus = modelStatus;
            return this;
        }

        @Override
        public final Builder modelStatus(ModelStatus modelStatus) {
            this.modelStatus(modelStatus == null ? null : modelStatus.toString());
            return this;
        }

        public CustomModelSummary build() {
            return new CustomModelSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CustomModelSummary> {
        public Builder modelArn(String var1);

        public Builder modelName(String var1);

        public Builder creationTime(Instant var1);

        public Builder baseModelArn(String var1);

        public Builder baseModelName(String var1);

        public Builder customizationType(String var1);

        public Builder customizationType(CustomizationType var1);

        public Builder ownerAccountId(String var1);

        public Builder modelStatus(String var1);

        public Builder modelStatus(ModelStatus var1);
    }
}

