/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyDefinitionRule;
import software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyDefinitionRuleListCopier;
import software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyDefinitionType;
import software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyDefinitionTypeListCopier;
import software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyDefinitionVariable;
import software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyDefinitionVariableListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AutomatedReasoningPolicyDefinition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AutomatedReasoningPolicyDefinition> {
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("version").getter(AutomatedReasoningPolicyDefinition.getter(AutomatedReasoningPolicyDefinition::version)).setter(AutomatedReasoningPolicyDefinition.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()}).build();
    private static final SdkField<List<AutomatedReasoningPolicyDefinitionType>> TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("types").getter(AutomatedReasoningPolicyDefinition.getter(AutomatedReasoningPolicyDefinition::types)).setter(AutomatedReasoningPolicyDefinition.setter(Builder::types)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("types").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AutomatedReasoningPolicyDefinitionType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AutomatedReasoningPolicyDefinitionRule>> RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("rules").getter(AutomatedReasoningPolicyDefinition.getter(AutomatedReasoningPolicyDefinition::rules)).setter(AutomatedReasoningPolicyDefinition.setter(Builder::rules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AutomatedReasoningPolicyDefinitionRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AutomatedReasoningPolicyDefinitionVariable>> VARIABLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("variables").getter(AutomatedReasoningPolicyDefinition.getter(AutomatedReasoningPolicyDefinition::variables)).setter(AutomatedReasoningPolicyDefinition.setter(Builder::variables)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("variables").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AutomatedReasoningPolicyDefinitionVariable::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VERSION_FIELD, TYPES_FIELD, RULES_FIELD, VARIABLES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AutomatedReasoningPolicyDefinition.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String version;
    private final List<AutomatedReasoningPolicyDefinitionType> types;
    private final List<AutomatedReasoningPolicyDefinitionRule> rules;
    private final List<AutomatedReasoningPolicyDefinitionVariable> variables;

    private AutomatedReasoningPolicyDefinition(BuilderImpl builder) {
        this.version = builder.version;
        this.types = builder.types;
        this.rules = builder.rules;
        this.variables = builder.variables;
    }

    public final String version() {
        return this.version;
    }

    public final boolean hasTypes() {
        return this.types != null && !(this.types instanceof SdkAutoConstructList);
    }

    public final List<AutomatedReasoningPolicyDefinitionType> types() {
        return this.types;
    }

    public final boolean hasRules() {
        return this.rules != null && !(this.rules instanceof SdkAutoConstructList);
    }

    public final List<AutomatedReasoningPolicyDefinitionRule> rules() {
        return this.rules;
    }

    public final boolean hasVariables() {
        return this.variables != null && !(this.variables instanceof SdkAutoConstructList);
    }

    public final List<AutomatedReasoningPolicyDefinitionVariable> variables() {
        return this.variables;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTypes() ? this.types() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRules() ? this.rules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVariables() ? this.variables() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomatedReasoningPolicyDefinition)) {
            return false;
        }
        AutomatedReasoningPolicyDefinition other = (AutomatedReasoningPolicyDefinition)obj;
        return Objects.equals(this.version(), other.version()) && this.hasTypes() == other.hasTypes() && Objects.equals(this.types(), other.types()) && this.hasRules() == other.hasRules() && Objects.equals(this.rules(), other.rules()) && this.hasVariables() == other.hasVariables() && Objects.equals(this.variables(), other.variables());
    }

    public final String toString() {
        return ToString.builder((String)"AutomatedReasoningPolicyDefinition").add("Version", (Object)this.version()).add("Types", this.hasTypes() ? this.types() : null).add("Rules", this.hasRules() ? this.rules() : null).add("Variables", this.hasVariables() ? this.variables() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "types": {
                return Optional.ofNullable(clazz.cast(this.types()));
            }
            case "rules": {
                return Optional.ofNullable(clazz.cast(this.rules()));
            }
            case "variables": {
                return Optional.ofNullable(clazz.cast(this.variables()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("version", VERSION_FIELD);
        map.put("types", TYPES_FIELD);
        map.put("rules", RULES_FIELD);
        map.put("variables", VARIABLES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutomatedReasoningPolicyDefinition, T> g) {
        return obj -> g.apply((AutomatedReasoningPolicyDefinition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String version;
        private List<AutomatedReasoningPolicyDefinitionType> types = DefaultSdkAutoConstructList.getInstance();
        private List<AutomatedReasoningPolicyDefinitionRule> rules = DefaultSdkAutoConstructList.getInstance();
        private List<AutomatedReasoningPolicyDefinitionVariable> variables = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AutomatedReasoningPolicyDefinition model) {
            this.version(model.version);
            this.types(model.types);
            this.rules(model.rules);
            this.variables(model.variables);
        }

        public final String getVersion() {
            return this.version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final List<AutomatedReasoningPolicyDefinitionType.Builder> getTypes() {
            List<AutomatedReasoningPolicyDefinitionType.Builder> result = AutomatedReasoningPolicyDefinitionTypeListCopier.copyToBuilder(this.types);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTypes(Collection<AutomatedReasoningPolicyDefinitionType.BuilderImpl> types) {
            this.types = AutomatedReasoningPolicyDefinitionTypeListCopier.copyFromBuilder(types);
        }

        @Override
        public final Builder types(Collection<AutomatedReasoningPolicyDefinitionType> types) {
            this.types = AutomatedReasoningPolicyDefinitionTypeListCopier.copy(types);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder types(AutomatedReasoningPolicyDefinitionType ... types) {
            this.types(Arrays.asList(types));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder types(Consumer<AutomatedReasoningPolicyDefinitionType.Builder> ... types) {
            this.types(Stream.of(types).map(c -> (AutomatedReasoningPolicyDefinitionType)((AutomatedReasoningPolicyDefinitionType.Builder)AutomatedReasoningPolicyDefinitionType.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<AutomatedReasoningPolicyDefinitionRule.Builder> getRules() {
            List<AutomatedReasoningPolicyDefinitionRule.Builder> result = AutomatedReasoningPolicyDefinitionRuleListCopier.copyToBuilder(this.rules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRules(Collection<AutomatedReasoningPolicyDefinitionRule.BuilderImpl> rules) {
            this.rules = AutomatedReasoningPolicyDefinitionRuleListCopier.copyFromBuilder(rules);
        }

        @Override
        public final Builder rules(Collection<AutomatedReasoningPolicyDefinitionRule> rules) {
            this.rules = AutomatedReasoningPolicyDefinitionRuleListCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(AutomatedReasoningPolicyDefinitionRule ... rules) {
            this.rules(Arrays.asList(rules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Consumer<AutomatedReasoningPolicyDefinitionRule.Builder> ... rules) {
            this.rules(Stream.of(rules).map(c -> (AutomatedReasoningPolicyDefinitionRule)((AutomatedReasoningPolicyDefinitionRule.Builder)AutomatedReasoningPolicyDefinitionRule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<AutomatedReasoningPolicyDefinitionVariable.Builder> getVariables() {
            List<AutomatedReasoningPolicyDefinitionVariable.Builder> result = AutomatedReasoningPolicyDefinitionVariableListCopier.copyToBuilder(this.variables);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVariables(Collection<AutomatedReasoningPolicyDefinitionVariable.BuilderImpl> variables) {
            this.variables = AutomatedReasoningPolicyDefinitionVariableListCopier.copyFromBuilder(variables);
        }

        @Override
        public final Builder variables(Collection<AutomatedReasoningPolicyDefinitionVariable> variables) {
            this.variables = AutomatedReasoningPolicyDefinitionVariableListCopier.copy(variables);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder variables(AutomatedReasoningPolicyDefinitionVariable ... variables) {
            this.variables(Arrays.asList(variables));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder variables(Consumer<AutomatedReasoningPolicyDefinitionVariable.Builder> ... variables) {
            this.variables(Stream.of(variables).map(c -> (AutomatedReasoningPolicyDefinitionVariable)((AutomatedReasoningPolicyDefinitionVariable.Builder)AutomatedReasoningPolicyDefinitionVariable.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public AutomatedReasoningPolicyDefinition build() {
            return new AutomatedReasoningPolicyDefinition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AutomatedReasoningPolicyDefinition> {
        public Builder version(String var1);

        public Builder types(Collection<AutomatedReasoningPolicyDefinitionType> var1);

        public Builder types(AutomatedReasoningPolicyDefinitionType ... var1);

        public Builder types(Consumer<AutomatedReasoningPolicyDefinitionType.Builder> ... var1);

        public Builder rules(Collection<AutomatedReasoningPolicyDefinitionRule> var1);

        public Builder rules(AutomatedReasoningPolicyDefinitionRule ... var1);

        public Builder rules(Consumer<AutomatedReasoningPolicyDefinitionRule.Builder> ... var1);

        public Builder variables(Collection<AutomatedReasoningPolicyDefinitionVariable> var1);

        public Builder variables(AutomatedReasoningPolicyDefinitionVariable ... var1);

        public Builder variables(Consumer<AutomatedReasoningPolicyDefinitionVariable.Builder> ... var1);
    }
}

