/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrock.model.ConfigurationOwner;
import software.amazon.awssdk.services.bedrock.model.InputTags;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AccountEnforcedGuardrailOutputConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AccountEnforcedGuardrailOutputConfiguration> {
    private static final SdkField<String> CONFIG_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("configId").getter(AccountEnforcedGuardrailOutputConfiguration.getter(AccountEnforcedGuardrailOutputConfiguration::configId)).setter(AccountEnforcedGuardrailOutputConfiguration.setter(Builder::configId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configId").build()}).build();
    private static final SdkField<String> GUARDRAIL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("guardrailArn").getter(AccountEnforcedGuardrailOutputConfiguration.getter(AccountEnforcedGuardrailOutputConfiguration::guardrailArn)).setter(AccountEnforcedGuardrailOutputConfiguration.setter(Builder::guardrailArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("guardrailArn").build()}).build();
    private static final SdkField<String> GUARDRAIL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("guardrailId").getter(AccountEnforcedGuardrailOutputConfiguration.getter(AccountEnforcedGuardrailOutputConfiguration::guardrailId)).setter(AccountEnforcedGuardrailOutputConfiguration.setter(Builder::guardrailId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("guardrailId").build()}).build();
    private static final SdkField<String> INPUT_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("inputTags").getter(AccountEnforcedGuardrailOutputConfiguration.getter(AccountEnforcedGuardrailOutputConfiguration::inputTagsAsString)).setter(AccountEnforcedGuardrailOutputConfiguration.setter(Builder::inputTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputTags").build()}).build();
    private static final SdkField<String> GUARDRAIL_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("guardrailVersion").getter(AccountEnforcedGuardrailOutputConfiguration.getter(AccountEnforcedGuardrailOutputConfiguration::guardrailVersion)).setter(AccountEnforcedGuardrailOutputConfiguration.setter(Builder::guardrailVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("guardrailVersion").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(AccountEnforcedGuardrailOutputConfiguration.getter(AccountEnforcedGuardrailOutputConfiguration::createdAt)).setter(AccountEnforcedGuardrailOutputConfiguration.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("createdBy").getter(AccountEnforcedGuardrailOutputConfiguration.getter(AccountEnforcedGuardrailOutputConfiguration::createdBy)).setter(AccountEnforcedGuardrailOutputConfiguration.setter(Builder::createdBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(AccountEnforcedGuardrailOutputConfiguration.getter(AccountEnforcedGuardrailOutputConfiguration::updatedAt)).setter(AccountEnforcedGuardrailOutputConfiguration.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> UPDATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("updatedBy").getter(AccountEnforcedGuardrailOutputConfiguration.getter(AccountEnforcedGuardrailOutputConfiguration::updatedBy)).setter(AccountEnforcedGuardrailOutputConfiguration.setter(Builder::updatedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedBy").build()}).build();
    private static final SdkField<String> OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("owner").getter(AccountEnforcedGuardrailOutputConfiguration.getter(AccountEnforcedGuardrailOutputConfiguration::ownerAsString)).setter(AccountEnforcedGuardrailOutputConfiguration.setter(Builder::owner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("owner").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIG_ID_FIELD, GUARDRAIL_ARN_FIELD, GUARDRAIL_ID_FIELD, INPUT_TAGS_FIELD, GUARDRAIL_VERSION_FIELD, CREATED_AT_FIELD, CREATED_BY_FIELD, UPDATED_AT_FIELD, UPDATED_BY_FIELD, OWNER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AccountEnforcedGuardrailOutputConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String configId;
    private final String guardrailArn;
    private final String guardrailId;
    private final String inputTags;
    private final String guardrailVersion;
    private final Instant createdAt;
    private final String createdBy;
    private final Instant updatedAt;
    private final String updatedBy;
    private final String owner;

    private AccountEnforcedGuardrailOutputConfiguration(BuilderImpl builder) {
        this.configId = builder.configId;
        this.guardrailArn = builder.guardrailArn;
        this.guardrailId = builder.guardrailId;
        this.inputTags = builder.inputTags;
        this.guardrailVersion = builder.guardrailVersion;
        this.createdAt = builder.createdAt;
        this.createdBy = builder.createdBy;
        this.updatedAt = builder.updatedAt;
        this.updatedBy = builder.updatedBy;
        this.owner = builder.owner;
    }

    public final String configId() {
        return this.configId;
    }

    public final String guardrailArn() {
        return this.guardrailArn;
    }

    public final String guardrailId() {
        return this.guardrailId;
    }

    public final InputTags inputTags() {
        return InputTags.fromValue(this.inputTags);
    }

    public final String inputTagsAsString() {
        return this.inputTags;
    }

    public final String guardrailVersion() {
        return this.guardrailVersion;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String createdBy() {
        return this.createdBy;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final String updatedBy() {
        return this.updatedBy;
    }

    public final ConfigurationOwner owner() {
        return ConfigurationOwner.fromValue(this.owner);
    }

    public final String ownerAsString() {
        return this.owner;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.configId());
        hashCode = 31 * hashCode + Objects.hashCode(this.guardrailArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.guardrailId());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputTagsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.guardrailVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountEnforcedGuardrailOutputConfiguration)) {
            return false;
        }
        AccountEnforcedGuardrailOutputConfiguration other = (AccountEnforcedGuardrailOutputConfiguration)obj;
        return Objects.equals(this.configId(), other.configId()) && Objects.equals(this.guardrailArn(), other.guardrailArn()) && Objects.equals(this.guardrailId(), other.guardrailId()) && Objects.equals(this.inputTagsAsString(), other.inputTagsAsString()) && Objects.equals(this.guardrailVersion(), other.guardrailVersion()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.updatedBy(), other.updatedBy()) && Objects.equals(this.ownerAsString(), other.ownerAsString());
    }

    public final String toString() {
        return ToString.builder((String)"AccountEnforcedGuardrailOutputConfiguration").add("ConfigId", (Object)this.configId()).add("GuardrailArn", (Object)this.guardrailArn()).add("GuardrailId", (Object)this.guardrailId()).add("InputTags", (Object)this.inputTagsAsString()).add("GuardrailVersion", (Object)this.guardrailVersion()).add("CreatedAt", (Object)this.createdAt()).add("CreatedBy", (Object)this.createdBy()).add("UpdatedAt", (Object)this.updatedAt()).add("UpdatedBy", (Object)this.updatedBy()).add("Owner", (Object)this.ownerAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "configId": {
                return Optional.ofNullable(clazz.cast(this.configId()));
            }
            case "guardrailArn": {
                return Optional.ofNullable(clazz.cast(this.guardrailArn()));
            }
            case "guardrailId": {
                return Optional.ofNullable(clazz.cast(this.guardrailId()));
            }
            case "inputTags": {
                return Optional.ofNullable(clazz.cast(this.inputTagsAsString()));
            }
            case "guardrailVersion": {
                return Optional.ofNullable(clazz.cast(this.guardrailVersion()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "createdBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "updatedBy": {
                return Optional.ofNullable(clazz.cast(this.updatedBy()));
            }
            case "owner": {
                return Optional.ofNullable(clazz.cast(this.ownerAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("configId", CONFIG_ID_FIELD);
        map.put("guardrailArn", GUARDRAIL_ARN_FIELD);
        map.put("guardrailId", GUARDRAIL_ID_FIELD);
        map.put("inputTags", INPUT_TAGS_FIELD);
        map.put("guardrailVersion", GUARDRAIL_VERSION_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("createdBy", CREATED_BY_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("updatedBy", UPDATED_BY_FIELD);
        map.put("owner", OWNER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AccountEnforcedGuardrailOutputConfiguration, T> g) {
        return obj -> g.apply((AccountEnforcedGuardrailOutputConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String configId;
        private String guardrailArn;
        private String guardrailId;
        private String inputTags;
        private String guardrailVersion;
        private Instant createdAt;
        private String createdBy;
        private Instant updatedAt;
        private String updatedBy;
        private String owner;

        private BuilderImpl() {
        }

        private BuilderImpl(AccountEnforcedGuardrailOutputConfiguration model) {
            this.configId(model.configId);
            this.guardrailArn(model.guardrailArn);
            this.guardrailId(model.guardrailId);
            this.inputTags(model.inputTags);
            this.guardrailVersion(model.guardrailVersion);
            this.createdAt(model.createdAt);
            this.createdBy(model.createdBy);
            this.updatedAt(model.updatedAt);
            this.updatedBy(model.updatedBy);
            this.owner(model.owner);
        }

        public final String getConfigId() {
            return this.configId;
        }

        public final void setConfigId(String configId) {
            this.configId = configId;
        }

        @Override
        public final Builder configId(String configId) {
            this.configId = configId;
            return this;
        }

        public final String getGuardrailArn() {
            return this.guardrailArn;
        }

        public final void setGuardrailArn(String guardrailArn) {
            this.guardrailArn = guardrailArn;
        }

        @Override
        public final Builder guardrailArn(String guardrailArn) {
            this.guardrailArn = guardrailArn;
            return this;
        }

        public final String getGuardrailId() {
            return this.guardrailId;
        }

        public final void setGuardrailId(String guardrailId) {
            this.guardrailId = guardrailId;
        }

        @Override
        public final Builder guardrailId(String guardrailId) {
            this.guardrailId = guardrailId;
            return this;
        }

        public final String getInputTags() {
            return this.inputTags;
        }

        public final void setInputTags(String inputTags) {
            this.inputTags = inputTags;
        }

        @Override
        public final Builder inputTags(String inputTags) {
            this.inputTags = inputTags;
            return this;
        }

        @Override
        public final Builder inputTags(InputTags inputTags) {
            this.inputTags(inputTags == null ? null : inputTags.toString());
            return this;
        }

        public final String getGuardrailVersion() {
            return this.guardrailVersion;
        }

        public final void setGuardrailVersion(String guardrailVersion) {
            this.guardrailVersion = guardrailVersion;
        }

        @Override
        public final Builder guardrailVersion(String guardrailVersion) {
            this.guardrailVersion = guardrailVersion;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCreatedBy() {
            return this.createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getUpdatedBy() {
            return this.updatedBy;
        }

        public final void setUpdatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
        }

        @Override
        public final Builder updatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
            return this;
        }

        public final String getOwner() {
            return this.owner;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        @Override
        public final Builder owner(ConfigurationOwner owner) {
            this.owner(owner == null ? null : owner.toString());
            return this;
        }

        public AccountEnforcedGuardrailOutputConfiguration build() {
            return new AccountEnforcedGuardrailOutputConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AccountEnforcedGuardrailOutputConfiguration> {
        public Builder configId(String var1);

        public Builder guardrailArn(String var1);

        public Builder guardrailId(String var1);

        public Builder inputTags(String var1);

        public Builder inputTags(InputTags var1);

        public Builder guardrailVersion(String var1);

        public Builder createdAt(Instant var1);

        public Builder createdBy(String var1);

        public Builder updatedAt(Instant var1);

        public Builder updatedBy(String var1);

        public Builder owner(String var1);

        public Builder owner(ConfigurationOwner var1);
    }
}

