/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateCustomModelDeploymentRequest extends BedrockRequest implements
        ToCopyableBuilder<UpdateCustomModelDeploymentRequest.Builder, UpdateCustomModelDeploymentRequest> {
    private static final SdkField<String> MODEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("modelArn").getter(getter(UpdateCustomModelDeploymentRequest::modelArn))
            .setter(setter(Builder::modelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelArn").build()).build();

    private static final SdkField<String> CUSTOM_MODEL_DEPLOYMENT_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("customModelDeploymentIdentifier")
            .getter(getter(UpdateCustomModelDeploymentRequest::customModelDeploymentIdentifier))
            .setter(setter(Builder::customModelDeploymentIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("customModelDeploymentIdentifier")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_ARN_FIELD,
            CUSTOM_MODEL_DEPLOYMENT_IDENTIFIER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String modelArn;

    private final String customModelDeploymentIdentifier;

    private UpdateCustomModelDeploymentRequest(BuilderImpl builder) {
        super(builder);
        this.modelArn = builder.modelArn;
        this.customModelDeploymentIdentifier = builder.customModelDeploymentIdentifier;
    }

    /**
     * <p>
     * ARN of the new custom model to deploy. This replaces the currently deployed model.
     * </p>
     * 
     * @return ARN of the new custom model to deploy. This replaces the currently deployed model.
     */
    public final String modelArn() {
        return modelArn;
    }

    /**
     * <p>
     * Identifier of the custom model deployment to update with the new custom model.
     * </p>
     * 
     * @return Identifier of the custom model deployment to update with the new custom model.
     */
    public final String customModelDeploymentIdentifier() {
        return customModelDeploymentIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(modelArn());
        hashCode = 31 * hashCode + Objects.hashCode(customModelDeploymentIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateCustomModelDeploymentRequest)) {
            return false;
        }
        UpdateCustomModelDeploymentRequest other = (UpdateCustomModelDeploymentRequest) obj;
        return Objects.equals(modelArn(), other.modelArn())
                && Objects.equals(customModelDeploymentIdentifier(), other.customModelDeploymentIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateCustomModelDeploymentRequest").add("ModelArn", modelArn())
                .add("CustomModelDeploymentIdentifier", customModelDeploymentIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "modelArn":
            return Optional.ofNullable(clazz.cast(modelArn()));
        case "customModelDeploymentIdentifier":
            return Optional.ofNullable(clazz.cast(customModelDeploymentIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("modelArn", MODEL_ARN_FIELD);
        map.put("customModelDeploymentIdentifier", CUSTOM_MODEL_DEPLOYMENT_IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateCustomModelDeploymentRequest, T> g) {
        return obj -> g.apply((UpdateCustomModelDeploymentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateCustomModelDeploymentRequest> {
        /**
         * <p>
         * ARN of the new custom model to deploy. This replaces the currently deployed model.
         * </p>
         * 
         * @param modelArn
         *        ARN of the new custom model to deploy. This replaces the currently deployed model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelArn(String modelArn);

        /**
         * <p>
         * Identifier of the custom model deployment to update with the new custom model.
         * </p>
         * 
         * @param customModelDeploymentIdentifier
         *        Identifier of the custom model deployment to update with the new custom model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customModelDeploymentIdentifier(String customModelDeploymentIdentifier);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BedrockRequest.BuilderImpl implements Builder {
        private String modelArn;

        private String customModelDeploymentIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateCustomModelDeploymentRequest model) {
            super(model);
            modelArn(model.modelArn);
            customModelDeploymentIdentifier(model.customModelDeploymentIdentifier);
        }

        public final String getModelArn() {
            return modelArn;
        }

        public final void setModelArn(String modelArn) {
            this.modelArn = modelArn;
        }

        @Override
        public final Builder modelArn(String modelArn) {
            this.modelArn = modelArn;
            return this;
        }

        public final String getCustomModelDeploymentIdentifier() {
            return customModelDeploymentIdentifier;
        }

        public final void setCustomModelDeploymentIdentifier(String customModelDeploymentIdentifier) {
            this.customModelDeploymentIdentifier = customModelDeploymentIdentifier;
        }

        @Override
        public final Builder customModelDeploymentIdentifier(String customModelDeploymentIdentifier) {
            this.customModelDeploymentIdentifier = customModelDeploymentIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateCustomModelDeploymentRequest build() {
            return new UpdateCustomModelDeploymentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
