/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateAutomatedReasoningPolicyResponse extends BedrockResponse implements
        ToCopyableBuilder<UpdateAutomatedReasoningPolicyResponse.Builder, UpdateAutomatedReasoningPolicyResponse> {
    private static final SdkField<String> POLICY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("policyArn").getter(getter(UpdateAutomatedReasoningPolicyResponse::policyArn))
            .setter(setter(Builder::policyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(UpdateAutomatedReasoningPolicyResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DEFINITION_HASH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("definitionHash").getter(getter(UpdateAutomatedReasoningPolicyResponse::definitionHash))
            .setter(setter(Builder::definitionHash))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("definitionHash").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt")
            .getter(getter(UpdateAutomatedReasoningPolicyResponse::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_ARN_FIELD, NAME_FIELD,
            DEFINITION_HASH_FIELD, UPDATED_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String policyArn;

    private final String name;

    private final String definitionHash;

    private final Instant updatedAt;

    private UpdateAutomatedReasoningPolicyResponse(BuilderImpl builder) {
        super(builder);
        this.policyArn = builder.policyArn;
        this.name = builder.name;
        this.definitionHash = builder.definitionHash;
        this.updatedAt = builder.updatedAt;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the updated policy.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the updated policy.
     */
    public final String policyArn() {
        return policyArn;
    }

    /**
     * <p>
     * The updated name of the policy.
     * </p>
     * 
     * @return The updated name of the policy.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The hash of the updated policy definition.
     * </p>
     * 
     * @return The hash of the updated policy definition.
     */
    public final String definitionHash() {
        return definitionHash;
    }

    /**
     * <p>
     * The timestamp when the policy was last updated.
     * </p>
     * 
     * @return The timestamp when the policy was last updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(policyArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(definitionHash());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAutomatedReasoningPolicyResponse)) {
            return false;
        }
        UpdateAutomatedReasoningPolicyResponse other = (UpdateAutomatedReasoningPolicyResponse) obj;
        return Objects.equals(policyArn(), other.policyArn()) && Objects.equals(name(), other.name())
                && Objects.equals(definitionHash(), other.definitionHash()) && Objects.equals(updatedAt(), other.updatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateAutomatedReasoningPolicyResponse").add("PolicyArn", policyArn())
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***").add("DefinitionHash", definitionHash())
                .add("UpdatedAt", updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "policyArn":
            return Optional.ofNullable(clazz.cast(policyArn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "definitionHash":
            return Optional.ofNullable(clazz.cast(definitionHash()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("policyArn", POLICY_ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("definitionHash", DEFINITION_HASH_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateAutomatedReasoningPolicyResponse, T> g) {
        return obj -> g.apply((UpdateAutomatedReasoningPolicyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateAutomatedReasoningPolicyResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the updated policy.
         * </p>
         * 
         * @param policyArn
         *        The Amazon Resource Name (ARN) of the updated policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyArn(String policyArn);

        /**
         * <p>
         * The updated name of the policy.
         * </p>
         * 
         * @param name
         *        The updated name of the policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The hash of the updated policy definition.
         * </p>
         * 
         * @param definitionHash
         *        The hash of the updated policy definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder definitionHash(String definitionHash);

        /**
         * <p>
         * The timestamp when the policy was last updated.
         * </p>
         * 
         * @param updatedAt
         *        The timestamp when the policy was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);
    }

    static final class BuilderImpl extends BedrockResponse.BuilderImpl implements Builder {
        private String policyArn;

        private String name;

        private String definitionHash;

        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAutomatedReasoningPolicyResponse model) {
            super(model);
            policyArn(model.policyArn);
            name(model.name);
            definitionHash(model.definitionHash);
            updatedAt(model.updatedAt);
        }

        public final String getPolicyArn() {
            return policyArn;
        }

        public final void setPolicyArn(String policyArn) {
            this.policyArn = policyArn;
        }

        @Override
        public final Builder policyArn(String policyArn) {
            this.policyArn = policyArn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDefinitionHash() {
            return definitionHash;
        }

        public final void setDefinitionHash(String definitionHash) {
            this.definitionHash = definitionHash;
        }

        @Override
        public final Builder definitionHash(String definitionHash) {
            this.definitionHash = definitionHash;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public UpdateAutomatedReasoningPolicyResponse build() {
            return new UpdateAutomatedReasoningPolicyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
