/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * S3 Location of the training data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TrainingDataConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<TrainingDataConfig.Builder, TrainingDataConfig> {
    private static final SdkField<String> S3_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("s3Uri")
            .getter(getter(TrainingDataConfig::s3Uri)).setter(setter(Builder::s3Uri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Uri").build()).build();

    private static final SdkField<InvocationLogsConfig> INVOCATION_LOGS_CONFIG_FIELD = SdkField
            .<InvocationLogsConfig> builder(MarshallingType.SDK_POJO).memberName("invocationLogsConfig")
            .getter(getter(TrainingDataConfig::invocationLogsConfig)).setter(setter(Builder::invocationLogsConfig))
            .constructor(InvocationLogsConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("invocationLogsConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_URI_FIELD,
            INVOCATION_LOGS_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String s3Uri;

    private final InvocationLogsConfig invocationLogsConfig;

    private TrainingDataConfig(BuilderImpl builder) {
        this.s3Uri = builder.s3Uri;
        this.invocationLogsConfig = builder.invocationLogsConfig;
    }

    /**
     * <p>
     * The S3 URI where the training data is stored.
     * </p>
     * 
     * @return The S3 URI where the training data is stored.
     */
    public final String s3Uri() {
        return s3Uri;
    }

    /**
     * <p>
     * Settings for using invocation logs to customize a model.
     * </p>
     * 
     * @return Settings for using invocation logs to customize a model.
     */
    public final InvocationLogsConfig invocationLogsConfig() {
        return invocationLogsConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3Uri());
        hashCode = 31 * hashCode + Objects.hashCode(invocationLogsConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrainingDataConfig)) {
            return false;
        }
        TrainingDataConfig other = (TrainingDataConfig) obj;
        return Objects.equals(s3Uri(), other.s3Uri()) && Objects.equals(invocationLogsConfig(), other.invocationLogsConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TrainingDataConfig").add("S3Uri", s3Uri()).add("InvocationLogsConfig", invocationLogsConfig())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "s3Uri":
            return Optional.ofNullable(clazz.cast(s3Uri()));
        case "invocationLogsConfig":
            return Optional.ofNullable(clazz.cast(invocationLogsConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("s3Uri", S3_URI_FIELD);
        map.put("invocationLogsConfig", INVOCATION_LOGS_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TrainingDataConfig, T> g) {
        return obj -> g.apply((TrainingDataConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TrainingDataConfig> {
        /**
         * <p>
         * The S3 URI where the training data is stored.
         * </p>
         * 
         * @param s3Uri
         *        The S3 URI where the training data is stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Uri(String s3Uri);

        /**
         * <p>
         * Settings for using invocation logs to customize a model.
         * </p>
         * 
         * @param invocationLogsConfig
         *        Settings for using invocation logs to customize a model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invocationLogsConfig(InvocationLogsConfig invocationLogsConfig);

        /**
         * <p>
         * Settings for using invocation logs to customize a model.
         * </p>
         * This is a convenience method that creates an instance of the {@link InvocationLogsConfig.Builder} avoiding
         * the need to create one manually via {@link InvocationLogsConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InvocationLogsConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #invocationLogsConfig(InvocationLogsConfig)}.
         * 
         * @param invocationLogsConfig
         *        a consumer that will call methods on {@link InvocationLogsConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #invocationLogsConfig(InvocationLogsConfig)
         */
        default Builder invocationLogsConfig(Consumer<InvocationLogsConfig.Builder> invocationLogsConfig) {
            return invocationLogsConfig(InvocationLogsConfig.builder().applyMutation(invocationLogsConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String s3Uri;

        private InvocationLogsConfig invocationLogsConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(TrainingDataConfig model) {
            s3Uri(model.s3Uri);
            invocationLogsConfig(model.invocationLogsConfig);
        }

        public final String getS3Uri() {
            return s3Uri;
        }

        public final void setS3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
        }

        @Override
        public final Builder s3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
            return this;
        }

        public final InvocationLogsConfig.Builder getInvocationLogsConfig() {
            return invocationLogsConfig != null ? invocationLogsConfig.toBuilder() : null;
        }

        public final void setInvocationLogsConfig(InvocationLogsConfig.BuilderImpl invocationLogsConfig) {
            this.invocationLogsConfig = invocationLogsConfig != null ? invocationLogsConfig.build() : null;
        }

        @Override
        public final Builder invocationLogsConfig(InvocationLogsConfig invocationLogsConfig) {
            this.invocationLogsConfig = invocationLogsConfig;
            return this;
        }

        @Override
        public TrainingDataConfig build() {
            return new TrainingDataConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
