/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartAutomatedReasoningPolicyTestWorkflowRequest extends BedrockRequest
        implements
        ToCopyableBuilder<StartAutomatedReasoningPolicyTestWorkflowRequest.Builder, StartAutomatedReasoningPolicyTestWorkflowRequest> {
    private static final SdkField<String> POLICY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("policyArn").getter(getter(StartAutomatedReasoningPolicyTestWorkflowRequest::policyArn))
            .setter(setter(Builder::policyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("policyArn").build()).build();

    private static final SdkField<String> BUILD_WORKFLOW_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("buildWorkflowId").getter(getter(StartAutomatedReasoningPolicyTestWorkflowRequest::buildWorkflowId))
            .setter(setter(Builder::buildWorkflowId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("buildWorkflowId").build()).build();

    private static final SdkField<List<String>> TEST_CASE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("testCaseIds")
            .getter(getter(StartAutomatedReasoningPolicyTestWorkflowRequest::testCaseIds))
            .setter(setter(Builder::testCaseIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testCaseIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientRequestToken")
            .getter(getter(StartAutomatedReasoningPolicyTestWorkflowRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_ARN_FIELD,
            BUILD_WORKFLOW_ID_FIELD, TEST_CASE_IDS_FIELD, CLIENT_REQUEST_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String policyArn;

    private final String buildWorkflowId;

    private final List<String> testCaseIds;

    private final String clientRequestToken;

    private StartAutomatedReasoningPolicyTestWorkflowRequest(BuilderImpl builder) {
        super(builder);
        this.policyArn = builder.policyArn;
        this.buildWorkflowId = builder.buildWorkflowId;
        this.testCaseIds = builder.testCaseIds;
        this.clientRequestToken = builder.clientRequestToken;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Automated Reasoning policy to test.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Automated Reasoning policy to test.
     */
    public final String policyArn() {
        return policyArn;
    }

    /**
     * <p>
     * The build workflow identifier. The build workflow must show a <code>COMPLETED</code> status before running tests.
     * </p>
     * 
     * @return The build workflow identifier. The build workflow must show a <code>COMPLETED</code> status before
     *         running tests.
     */
    public final String buildWorkflowId() {
        return buildWorkflowId;
    }

    /**
     * For responses, this returns true if the service returned a value for the TestCaseIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTestCaseIds() {
        return testCaseIds != null && !(testCaseIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of test identifiers to run. If not provided, all tests for the policy are run.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTestCaseIds} method.
     * </p>
     * 
     * @return The list of test identifiers to run. If not provided, all tests for the policy are run.
     */
    public final List<String> testCaseIds() {
        return testCaseIds;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier to ensure that the operation completes no more than one time. If this token
     * matches a previous request, Amazon Bedrock ignores the request but doesn't return an error.
     * </p>
     * 
     * @return A unique, case-sensitive identifier to ensure that the operation completes no more than one time. If this
     *         token matches a previous request, Amazon Bedrock ignores the request but doesn't return an error.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(policyArn());
        hashCode = 31 * hashCode + Objects.hashCode(buildWorkflowId());
        hashCode = 31 * hashCode + Objects.hashCode(hasTestCaseIds() ? testCaseIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartAutomatedReasoningPolicyTestWorkflowRequest)) {
            return false;
        }
        StartAutomatedReasoningPolicyTestWorkflowRequest other = (StartAutomatedReasoningPolicyTestWorkflowRequest) obj;
        return Objects.equals(policyArn(), other.policyArn()) && Objects.equals(buildWorkflowId(), other.buildWorkflowId())
                && hasTestCaseIds() == other.hasTestCaseIds() && Objects.equals(testCaseIds(), other.testCaseIds())
                && Objects.equals(clientRequestToken(), other.clientRequestToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartAutomatedReasoningPolicyTestWorkflowRequest").add("PolicyArn", policyArn())
                .add("BuildWorkflowId", buildWorkflowId()).add("TestCaseIds", hasTestCaseIds() ? testCaseIds() : null)
                .add("ClientRequestToken", clientRequestToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "policyArn":
            return Optional.ofNullable(clazz.cast(policyArn()));
        case "buildWorkflowId":
            return Optional.ofNullable(clazz.cast(buildWorkflowId()));
        case "testCaseIds":
            return Optional.ofNullable(clazz.cast(testCaseIds()));
        case "clientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("policyArn", POLICY_ARN_FIELD);
        map.put("buildWorkflowId", BUILD_WORKFLOW_ID_FIELD);
        map.put("testCaseIds", TEST_CASE_IDS_FIELD);
        map.put("clientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartAutomatedReasoningPolicyTestWorkflowRequest, T> g) {
        return obj -> g.apply((StartAutomatedReasoningPolicyTestWorkflowRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, StartAutomatedReasoningPolicyTestWorkflowRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Automated Reasoning policy to test.
         * </p>
         * 
         * @param policyArn
         *        The Amazon Resource Name (ARN) of the Automated Reasoning policy to test.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyArn(String policyArn);

        /**
         * <p>
         * The build workflow identifier. The build workflow must show a <code>COMPLETED</code> status before running
         * tests.
         * </p>
         * 
         * @param buildWorkflowId
         *        The build workflow identifier. The build workflow must show a <code>COMPLETED</code> status before
         *        running tests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder buildWorkflowId(String buildWorkflowId);

        /**
         * <p>
         * The list of test identifiers to run. If not provided, all tests for the policy are run.
         * </p>
         * 
         * @param testCaseIds
         *        The list of test identifiers to run. If not provided, all tests for the policy are run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testCaseIds(Collection<String> testCaseIds);

        /**
         * <p>
         * The list of test identifiers to run. If not provided, all tests for the policy are run.
         * </p>
         * 
         * @param testCaseIds
         *        The list of test identifiers to run. If not provided, all tests for the policy are run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testCaseIds(String... testCaseIds);

        /**
         * <p>
         * A unique, case-sensitive identifier to ensure that the operation completes no more than one time. If this
         * token matches a previous request, Amazon Bedrock ignores the request but doesn't return an error.
         * </p>
         * 
         * @param clientRequestToken
         *        A unique, case-sensitive identifier to ensure that the operation completes no more than one time. If
         *        this token matches a previous request, Amazon Bedrock ignores the request but doesn't return an error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BedrockRequest.BuilderImpl implements Builder {
        private String policyArn;

        private String buildWorkflowId;

        private List<String> testCaseIds = DefaultSdkAutoConstructList.getInstance();

        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(StartAutomatedReasoningPolicyTestWorkflowRequest model) {
            super(model);
            policyArn(model.policyArn);
            buildWorkflowId(model.buildWorkflowId);
            testCaseIds(model.testCaseIds);
            clientRequestToken(model.clientRequestToken);
        }

        public final String getPolicyArn() {
            return policyArn;
        }

        public final void setPolicyArn(String policyArn) {
            this.policyArn = policyArn;
        }

        @Override
        public final Builder policyArn(String policyArn) {
            this.policyArn = policyArn;
            return this;
        }

        public final String getBuildWorkflowId() {
            return buildWorkflowId;
        }

        public final void setBuildWorkflowId(String buildWorkflowId) {
            this.buildWorkflowId = buildWorkflowId;
        }

        @Override
        public final Builder buildWorkflowId(String buildWorkflowId) {
            this.buildWorkflowId = buildWorkflowId;
            return this;
        }

        public final Collection<String> getTestCaseIds() {
            if (testCaseIds instanceof SdkAutoConstructList) {
                return null;
            }
            return testCaseIds;
        }

        public final void setTestCaseIds(Collection<String> testCaseIds) {
            this.testCaseIds = AutomatedReasoningPolicyTestCaseIdListCopier.copy(testCaseIds);
        }

        @Override
        public final Builder testCaseIds(Collection<String> testCaseIds) {
            this.testCaseIds = AutomatedReasoningPolicyTestCaseIdListCopier.copy(testCaseIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder testCaseIds(String... testCaseIds) {
            testCaseIds(Arrays.asList(testCaseIds));
            return this;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartAutomatedReasoningPolicyTestWorkflowRequest build() {
            return new StartAutomatedReasoningPolicyTestWorkflowRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
