/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration settings for reinforcement fine-tuning (RFT), including grader configuration and training
 * hyperparameters.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RFTConfig implements SdkPojo, Serializable, ToCopyableBuilder<RFTConfig.Builder, RFTConfig> {
    private static final SdkField<GraderConfig> GRADER_CONFIG_FIELD = SdkField.<GraderConfig> builder(MarshallingType.SDK_POJO)
            .memberName("graderConfig").getter(getter(RFTConfig::graderConfig)).setter(setter(Builder::graderConfig))
            .constructor(GraderConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("graderConfig").build()).build();

    private static final SdkField<RFTHyperParameters> HYPER_PARAMETERS_FIELD = SdkField
            .<RFTHyperParameters> builder(MarshallingType.SDK_POJO).memberName("hyperParameters")
            .getter(getter(RFTConfig::hyperParameters)).setter(setter(Builder::hyperParameters))
            .constructor(RFTHyperParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hyperParameters").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GRADER_CONFIG_FIELD,
            HYPER_PARAMETERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final GraderConfig graderConfig;

    private final RFTHyperParameters hyperParameters;

    private RFTConfig(BuilderImpl builder) {
        this.graderConfig = builder.graderConfig;
        this.hyperParameters = builder.hyperParameters;
    }

    /**
     * <p>
     * Configuration for the grader that evaluates model responses and provides reward signals during RFT training.
     * </p>
     * 
     * @return Configuration for the grader that evaluates model responses and provides reward signals during RFT
     *         training.
     */
    public final GraderConfig graderConfig() {
        return graderConfig;
    }

    /**
     * <p>
     * Hyperparameters that control the reinforcement fine-tuning training process, including learning rate, batch size,
     * and epoch count.
     * </p>
     * 
     * @return Hyperparameters that control the reinforcement fine-tuning training process, including learning rate,
     *         batch size, and epoch count.
     */
    public final RFTHyperParameters hyperParameters() {
        return hyperParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(graderConfig());
        hashCode = 31 * hashCode + Objects.hashCode(hyperParameters());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RFTConfig)) {
            return false;
        }
        RFTConfig other = (RFTConfig) obj;
        return Objects.equals(graderConfig(), other.graderConfig()) && Objects.equals(hyperParameters(), other.hyperParameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RFTConfig").add("GraderConfig", graderConfig()).add("HyperParameters", hyperParameters())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "graderConfig":
            return Optional.ofNullable(clazz.cast(graderConfig()));
        case "hyperParameters":
            return Optional.ofNullable(clazz.cast(hyperParameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("graderConfig", GRADER_CONFIG_FIELD);
        map.put("hyperParameters", HYPER_PARAMETERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RFTConfig, T> g) {
        return obj -> g.apply((RFTConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RFTConfig> {
        /**
         * <p>
         * Configuration for the grader that evaluates model responses and provides reward signals during RFT training.
         * </p>
         * 
         * @param graderConfig
         *        Configuration for the grader that evaluates model responses and provides reward signals during RFT
         *        training.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder graderConfig(GraderConfig graderConfig);

        /**
         * <p>
         * Configuration for the grader that evaluates model responses and provides reward signals during RFT training.
         * </p>
         * This is a convenience method that creates an instance of the {@link GraderConfig.Builder} avoiding the need
         * to create one manually via {@link GraderConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GraderConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #graderConfig(GraderConfig)}.
         * 
         * @param graderConfig
         *        a consumer that will call methods on {@link GraderConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #graderConfig(GraderConfig)
         */
        default Builder graderConfig(Consumer<GraderConfig.Builder> graderConfig) {
            return graderConfig(GraderConfig.builder().applyMutation(graderConfig).build());
        }

        /**
         * <p>
         * Hyperparameters that control the reinforcement fine-tuning training process, including learning rate, batch
         * size, and epoch count.
         * </p>
         * 
         * @param hyperParameters
         *        Hyperparameters that control the reinforcement fine-tuning training process, including learning rate,
         *        batch size, and epoch count.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hyperParameters(RFTHyperParameters hyperParameters);

        /**
         * <p>
         * Hyperparameters that control the reinforcement fine-tuning training process, including learning rate, batch
         * size, and epoch count.
         * </p>
         * This is a convenience method that creates an instance of the {@link RFTHyperParameters.Builder} avoiding the
         * need to create one manually via {@link RFTHyperParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RFTHyperParameters.Builder#build()} is called immediately and its
         * result is passed to {@link #hyperParameters(RFTHyperParameters)}.
         * 
         * @param hyperParameters
         *        a consumer that will call methods on {@link RFTHyperParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hyperParameters(RFTHyperParameters)
         */
        default Builder hyperParameters(Consumer<RFTHyperParameters.Builder> hyperParameters) {
            return hyperParameters(RFTHyperParameters.builder().applyMutation(hyperParameters).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private GraderConfig graderConfig;

        private RFTHyperParameters hyperParameters;

        private BuilderImpl() {
        }

        private BuilderImpl(RFTConfig model) {
            graderConfig(model.graderConfig);
            hyperParameters(model.hyperParameters);
        }

        public final GraderConfig.Builder getGraderConfig() {
            return graderConfig != null ? graderConfig.toBuilder() : null;
        }

        public final void setGraderConfig(GraderConfig.BuilderImpl graderConfig) {
            this.graderConfig = graderConfig != null ? graderConfig.build() : null;
        }

        @Override
        public final Builder graderConfig(GraderConfig graderConfig) {
            this.graderConfig = graderConfig;
            return this;
        }

        public final RFTHyperParameters.Builder getHyperParameters() {
            return hyperParameters != null ? hyperParameters.toBuilder() : null;
        }

        public final void setHyperParameters(RFTHyperParameters.BuilderImpl hyperParameters) {
            this.hyperParameters = hyperParameters != null ? hyperParameters.build() : null;
        }

        @Override
        public final Builder hyperParameters(RFTHyperParameters hyperParameters) {
            this.hyperParameters = hyperParameters;
            return this;
        }

        @Override
        public RFTConfig build() {
            return new RFTConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
