/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutEnforcedGuardrailConfigurationRequest extends BedrockRequest implements
        ToCopyableBuilder<PutEnforcedGuardrailConfigurationRequest.Builder, PutEnforcedGuardrailConfigurationRequest> {
    private static final SdkField<String> CONFIG_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("configId").getter(getter(PutEnforcedGuardrailConfigurationRequest::configId))
            .setter(setter(Builder::configId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configId").build()).build();

    private static final SdkField<AccountEnforcedGuardrailInferenceInputConfiguration> GUARDRAIL_INFERENCE_CONFIG_FIELD = SdkField
            .<AccountEnforcedGuardrailInferenceInputConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("guardrailInferenceConfig")
            .getter(getter(PutEnforcedGuardrailConfigurationRequest::guardrailInferenceConfig))
            .setter(setter(Builder::guardrailInferenceConfig))
            .constructor(AccountEnforcedGuardrailInferenceInputConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("guardrailInferenceConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIG_ID_FIELD,
            GUARDRAIL_INFERENCE_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String configId;

    private final AccountEnforcedGuardrailInferenceInputConfiguration guardrailInferenceConfig;

    private PutEnforcedGuardrailConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.configId = builder.configId;
        this.guardrailInferenceConfig = builder.guardrailInferenceConfig;
    }

    /**
     * <p>
     * Unique ID for the account enforced configuration.
     * </p>
     * 
     * @return Unique ID for the account enforced configuration.
     */
    public final String configId() {
        return configId;
    }

    /**
     * <p>
     * Account-level enforced guardrail input configuration.
     * </p>
     * 
     * @return Account-level enforced guardrail input configuration.
     */
    public final AccountEnforcedGuardrailInferenceInputConfiguration guardrailInferenceConfig() {
        return guardrailInferenceConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(configId());
        hashCode = 31 * hashCode + Objects.hashCode(guardrailInferenceConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutEnforcedGuardrailConfigurationRequest)) {
            return false;
        }
        PutEnforcedGuardrailConfigurationRequest other = (PutEnforcedGuardrailConfigurationRequest) obj;
        return Objects.equals(configId(), other.configId())
                && Objects.equals(guardrailInferenceConfig(), other.guardrailInferenceConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutEnforcedGuardrailConfigurationRequest").add("ConfigId", configId())
                .add("GuardrailInferenceConfig", guardrailInferenceConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "configId":
            return Optional.ofNullable(clazz.cast(configId()));
        case "guardrailInferenceConfig":
            return Optional.ofNullable(clazz.cast(guardrailInferenceConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("configId", CONFIG_ID_FIELD);
        map.put("guardrailInferenceConfig", GUARDRAIL_INFERENCE_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutEnforcedGuardrailConfigurationRequest, T> g) {
        return obj -> g.apply((PutEnforcedGuardrailConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, PutEnforcedGuardrailConfigurationRequest> {
        /**
         * <p>
         * Unique ID for the account enforced configuration.
         * </p>
         * 
         * @param configId
         *        Unique ID for the account enforced configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configId(String configId);

        /**
         * <p>
         * Account-level enforced guardrail input configuration.
         * </p>
         * 
         * @param guardrailInferenceConfig
         *        Account-level enforced guardrail input configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder guardrailInferenceConfig(AccountEnforcedGuardrailInferenceInputConfiguration guardrailInferenceConfig);

        /**
         * <p>
         * Account-level enforced guardrail input configuration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AccountEnforcedGuardrailInferenceInputConfiguration.Builder} avoiding the need to create one manually
         * via {@link AccountEnforcedGuardrailInferenceInputConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link AccountEnforcedGuardrailInferenceInputConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #guardrailInferenceConfig(AccountEnforcedGuardrailInferenceInputConfiguration)}.
         * 
         * @param guardrailInferenceConfig
         *        a consumer that will call methods on
         *        {@link AccountEnforcedGuardrailInferenceInputConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #guardrailInferenceConfig(AccountEnforcedGuardrailInferenceInputConfiguration)
         */
        default Builder guardrailInferenceConfig(
                Consumer<AccountEnforcedGuardrailInferenceInputConfiguration.Builder> guardrailInferenceConfig) {
            return guardrailInferenceConfig(AccountEnforcedGuardrailInferenceInputConfiguration.builder()
                    .applyMutation(guardrailInferenceConfig).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BedrockRequest.BuilderImpl implements Builder {
        private String configId;

        private AccountEnforcedGuardrailInferenceInputConfiguration guardrailInferenceConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(PutEnforcedGuardrailConfigurationRequest model) {
            super(model);
            configId(model.configId);
            guardrailInferenceConfig(model.guardrailInferenceConfig);
        }

        public final String getConfigId() {
            return configId;
        }

        public final void setConfigId(String configId) {
            this.configId = configId;
        }

        @Override
        public final Builder configId(String configId) {
            this.configId = configId;
            return this;
        }

        public final AccountEnforcedGuardrailInferenceInputConfiguration.Builder getGuardrailInferenceConfig() {
            return guardrailInferenceConfig != null ? guardrailInferenceConfig.toBuilder() : null;
        }

        public final void setGuardrailInferenceConfig(
                AccountEnforcedGuardrailInferenceInputConfiguration.BuilderImpl guardrailInferenceConfig) {
            this.guardrailInferenceConfig = guardrailInferenceConfig != null ? guardrailInferenceConfig.build() : null;
        }

        @Override
        public final Builder guardrailInferenceConfig(AccountEnforcedGuardrailInferenceInputConfiguration guardrailInferenceConfig) {
            this.guardrailInferenceConfig = guardrailInferenceConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutEnforcedGuardrailConfigurationRequest build() {
            return new PutEnforcedGuardrailConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
