/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListEnforcedGuardrailsConfigurationResponse extends BedrockResponse implements
        ToCopyableBuilder<ListEnforcedGuardrailsConfigurationResponse.Builder, ListEnforcedGuardrailsConfigurationResponse> {
    private static final SdkField<List<AccountEnforcedGuardrailOutputConfiguration>> GUARDRAILS_CONFIG_FIELD = SdkField
            .<List<AccountEnforcedGuardrailOutputConfiguration>> builder(MarshallingType.LIST)
            .memberName("guardrailsConfig")
            .getter(getter(ListEnforcedGuardrailsConfigurationResponse::guardrailsConfig))
            .setter(setter(Builder::guardrailsConfig))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("guardrailsConfig").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AccountEnforcedGuardrailOutputConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(AccountEnforcedGuardrailOutputConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListEnforcedGuardrailsConfigurationResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GUARDRAILS_CONFIG_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<AccountEnforcedGuardrailOutputConfiguration> guardrailsConfig;

    private final String nextToken;

    private ListEnforcedGuardrailsConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.guardrailsConfig = builder.guardrailsConfig;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the GuardrailsConfig property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasGuardrailsConfig() {
        return guardrailsConfig != null && !(guardrailsConfig instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Array of AccountEnforcedGuardrailOutputConfiguration objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGuardrailsConfig} method.
     * </p>
     * 
     * @return Array of AccountEnforcedGuardrailOutputConfiguration objects.
     */
    public final List<AccountEnforcedGuardrailOutputConfiguration> guardrailsConfig() {
        return guardrailsConfig;
    }

    /**
     * <p>
     * Opaque continuation token of previous paginated response.
     * </p>
     * 
     * @return Opaque continuation token of previous paginated response.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasGuardrailsConfig() ? guardrailsConfig() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEnforcedGuardrailsConfigurationResponse)) {
            return false;
        }
        ListEnforcedGuardrailsConfigurationResponse other = (ListEnforcedGuardrailsConfigurationResponse) obj;
        return hasGuardrailsConfig() == other.hasGuardrailsConfig()
                && Objects.equals(guardrailsConfig(), other.guardrailsConfig()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListEnforcedGuardrailsConfigurationResponse")
                .add("GuardrailsConfig", hasGuardrailsConfig() ? guardrailsConfig() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "guardrailsConfig":
            return Optional.ofNullable(clazz.cast(guardrailsConfig()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("guardrailsConfig", GUARDRAILS_CONFIG_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListEnforcedGuardrailsConfigurationResponse, T> g) {
        return obj -> g.apply((ListEnforcedGuardrailsConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListEnforcedGuardrailsConfigurationResponse> {
        /**
         * <p>
         * Array of AccountEnforcedGuardrailOutputConfiguration objects.
         * </p>
         * 
         * @param guardrailsConfig
         *        Array of AccountEnforcedGuardrailOutputConfiguration objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder guardrailsConfig(Collection<AccountEnforcedGuardrailOutputConfiguration> guardrailsConfig);

        /**
         * <p>
         * Array of AccountEnforcedGuardrailOutputConfiguration objects.
         * </p>
         * 
         * @param guardrailsConfig
         *        Array of AccountEnforcedGuardrailOutputConfiguration objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder guardrailsConfig(AccountEnforcedGuardrailOutputConfiguration... guardrailsConfig);

        /**
         * <p>
         * Array of AccountEnforcedGuardrailOutputConfiguration objects.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrock.model.AccountEnforcedGuardrailOutputConfiguration.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.bedrock.model.AccountEnforcedGuardrailOutputConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrock.model.AccountEnforcedGuardrailOutputConfiguration.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #guardrailsConfig(List<AccountEnforcedGuardrailOutputConfiguration>)}.
         * 
         * @param guardrailsConfig
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrock.model.AccountEnforcedGuardrailOutputConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #guardrailsConfig(java.util.Collection<AccountEnforcedGuardrailOutputConfiguration>)
         */
        Builder guardrailsConfig(Consumer<AccountEnforcedGuardrailOutputConfiguration.Builder>... guardrailsConfig);

        /**
         * <p>
         * Opaque continuation token of previous paginated response.
         * </p>
         * 
         * @param nextToken
         *        Opaque continuation token of previous paginated response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends BedrockResponse.BuilderImpl implements Builder {
        private List<AccountEnforcedGuardrailOutputConfiguration> guardrailsConfig = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEnforcedGuardrailsConfigurationResponse model) {
            super(model);
            guardrailsConfig(model.guardrailsConfig);
            nextToken(model.nextToken);
        }

        public final List<AccountEnforcedGuardrailOutputConfiguration.Builder> getGuardrailsConfig() {
            List<AccountEnforcedGuardrailOutputConfiguration.Builder> result = AccountEnforcedGuardrailsOutputConfigurationCopier
                    .copyToBuilder(this.guardrailsConfig);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGuardrailsConfig(Collection<AccountEnforcedGuardrailOutputConfiguration.BuilderImpl> guardrailsConfig) {
            this.guardrailsConfig = AccountEnforcedGuardrailsOutputConfigurationCopier.copyFromBuilder(guardrailsConfig);
        }

        @Override
        public final Builder guardrailsConfig(Collection<AccountEnforcedGuardrailOutputConfiguration> guardrailsConfig) {
            this.guardrailsConfig = AccountEnforcedGuardrailsOutputConfigurationCopier.copy(guardrailsConfig);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder guardrailsConfig(AccountEnforcedGuardrailOutputConfiguration... guardrailsConfig) {
            guardrailsConfig(Arrays.asList(guardrailsConfig));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder guardrailsConfig(Consumer<AccountEnforcedGuardrailOutputConfiguration.Builder>... guardrailsConfig) {
            guardrailsConfig(Stream.of(guardrailsConfig)
                    .map(c -> AccountEnforcedGuardrailOutputConfiguration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListEnforcedGuardrailsConfigurationResponse build() {
            return new ListEnforcedGuardrailsConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
