/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAutomatedReasoningPolicyBuildWorkflowsResponse extends BedrockResponse
        implements
        ToCopyableBuilder<ListAutomatedReasoningPolicyBuildWorkflowsResponse.Builder, ListAutomatedReasoningPolicyBuildWorkflowsResponse> {
    private static final SdkField<List<AutomatedReasoningPolicyBuildWorkflowSummary>> AUTOMATED_REASONING_POLICY_BUILD_WORKFLOW_SUMMARIES_FIELD = SdkField
            .<List<AutomatedReasoningPolicyBuildWorkflowSummary>> builder(MarshallingType.LIST)
            .memberName("automatedReasoningPolicyBuildWorkflowSummaries")
            .getter(getter(ListAutomatedReasoningPolicyBuildWorkflowsResponse::automatedReasoningPolicyBuildWorkflowSummaries))
            .setter(setter(Builder::automatedReasoningPolicyBuildWorkflowSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("automatedReasoningPolicyBuildWorkflowSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AutomatedReasoningPolicyBuildWorkflowSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(AutomatedReasoningPolicyBuildWorkflowSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListAutomatedReasoningPolicyBuildWorkflowsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            AUTOMATED_REASONING_POLICY_BUILD_WORKFLOW_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<AutomatedReasoningPolicyBuildWorkflowSummary> automatedReasoningPolicyBuildWorkflowSummaries;

    private final String nextToken;

    private ListAutomatedReasoningPolicyBuildWorkflowsResponse(BuilderImpl builder) {
        super(builder);
        this.automatedReasoningPolicyBuildWorkflowSummaries = builder.automatedReasoningPolicyBuildWorkflowSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the
     * AutomatedReasoningPolicyBuildWorkflowSummaries property. This DOES NOT check that the value is non-empty (for
     * which, you should check the {@code isEmpty()} method on the property). This is useful because the SDK will never
     * return a null collection or map, but you may need to differentiate between the service returning nothing (or
     * null) and the service returning an empty collection or map. For requests, this returns true if a value for the
     * property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasAutomatedReasoningPolicyBuildWorkflowSummaries() {
        return automatedReasoningPolicyBuildWorkflowSummaries != null
                && !(automatedReasoningPolicyBuildWorkflowSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of build workflow summaries, each containing key information about a build workflow including its status
     * and timestamps.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the
     * {@link #hasAutomatedReasoningPolicyBuildWorkflowSummaries} method.
     * </p>
     * 
     * @return A list of build workflow summaries, each containing key information about a build workflow including its
     *         status and timestamps.
     */
    public final List<AutomatedReasoningPolicyBuildWorkflowSummary> automatedReasoningPolicyBuildWorkflowSummaries() {
        return automatedReasoningPolicyBuildWorkflowSummaries;
    }

    /**
     * <p>
     * A pagination token to use in subsequent requests to retrieve additional build workflows.
     * </p>
     * 
     * @return A pagination token to use in subsequent requests to retrieve additional build workflows.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31
                * hashCode
                + Objects
                        .hashCode(hasAutomatedReasoningPolicyBuildWorkflowSummaries() ? automatedReasoningPolicyBuildWorkflowSummaries()
                                : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAutomatedReasoningPolicyBuildWorkflowsResponse)) {
            return false;
        }
        ListAutomatedReasoningPolicyBuildWorkflowsResponse other = (ListAutomatedReasoningPolicyBuildWorkflowsResponse) obj;
        return hasAutomatedReasoningPolicyBuildWorkflowSummaries() == other.hasAutomatedReasoningPolicyBuildWorkflowSummaries()
                && Objects.equals(automatedReasoningPolicyBuildWorkflowSummaries(),
                        other.automatedReasoningPolicyBuildWorkflowSummaries()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ListAutomatedReasoningPolicyBuildWorkflowsResponse")
                .add("AutomatedReasoningPolicyBuildWorkflowSummaries",
                        hasAutomatedReasoningPolicyBuildWorkflowSummaries() ? automatedReasoningPolicyBuildWorkflowSummaries()
                                : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "automatedReasoningPolicyBuildWorkflowSummaries":
            return Optional.ofNullable(clazz.cast(automatedReasoningPolicyBuildWorkflowSummaries()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("automatedReasoningPolicyBuildWorkflowSummaries", AUTOMATED_REASONING_POLICY_BUILD_WORKFLOW_SUMMARIES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAutomatedReasoningPolicyBuildWorkflowsResponse, T> g) {
        return obj -> g.apply((ListAutomatedReasoningPolicyBuildWorkflowsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListAutomatedReasoningPolicyBuildWorkflowsResponse> {
        /**
         * <p>
         * A list of build workflow summaries, each containing key information about a build workflow including its
         * status and timestamps.
         * </p>
         * 
         * @param automatedReasoningPolicyBuildWorkflowSummaries
         *        A list of build workflow summaries, each containing key information about a build workflow including
         *        its status and timestamps.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder automatedReasoningPolicyBuildWorkflowSummaries(
                Collection<AutomatedReasoningPolicyBuildWorkflowSummary> automatedReasoningPolicyBuildWorkflowSummaries);

        /**
         * <p>
         * A list of build workflow summaries, each containing key information about a build workflow including its
         * status and timestamps.
         * </p>
         * 
         * @param automatedReasoningPolicyBuildWorkflowSummaries
         *        A list of build workflow summaries, each containing key information about a build workflow including
         *        its status and timestamps.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder automatedReasoningPolicyBuildWorkflowSummaries(
                AutomatedReasoningPolicyBuildWorkflowSummary... automatedReasoningPolicyBuildWorkflowSummaries);

        /**
         * <p>
         * A list of build workflow summaries, each containing key information about a build workflow including its
         * status and timestamps.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyBuildWorkflowSummary.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyBuildWorkflowSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyBuildWorkflowSummary.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #automatedReasoningPolicyBuildWorkflowSummaries(List<AutomatedReasoningPolicyBuildWorkflowSummary>)}.
         * 
         * @param automatedReasoningPolicyBuildWorkflowSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyBuildWorkflowSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #automatedReasoningPolicyBuildWorkflowSummaries(java.util.Collection<
         *      AutomatedReasoningPolicyBuildWorkflowSummary>)
         */
        Builder automatedReasoningPolicyBuildWorkflowSummaries(
                Consumer<AutomatedReasoningPolicyBuildWorkflowSummary.Builder>... automatedReasoningPolicyBuildWorkflowSummaries);

        /**
         * <p>
         * A pagination token to use in subsequent requests to retrieve additional build workflows.
         * </p>
         * 
         * @param nextToken
         *        A pagination token to use in subsequent requests to retrieve additional build workflows.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends BedrockResponse.BuilderImpl implements Builder {
        private List<AutomatedReasoningPolicyBuildWorkflowSummary> automatedReasoningPolicyBuildWorkflowSummaries = DefaultSdkAutoConstructList
                .getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAutomatedReasoningPolicyBuildWorkflowsResponse model) {
            super(model);
            automatedReasoningPolicyBuildWorkflowSummaries(model.automatedReasoningPolicyBuildWorkflowSummaries);
            nextToken(model.nextToken);
        }

        public final List<AutomatedReasoningPolicyBuildWorkflowSummary.Builder> getAutomatedReasoningPolicyBuildWorkflowSummaries() {
            List<AutomatedReasoningPolicyBuildWorkflowSummary.Builder> result = AutomatedReasoningPolicyBuildWorkflowSummariesCopier
                    .copyToBuilder(this.automatedReasoningPolicyBuildWorkflowSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAutomatedReasoningPolicyBuildWorkflowSummaries(
                Collection<AutomatedReasoningPolicyBuildWorkflowSummary.BuilderImpl> automatedReasoningPolicyBuildWorkflowSummaries) {
            this.automatedReasoningPolicyBuildWorkflowSummaries = AutomatedReasoningPolicyBuildWorkflowSummariesCopier
                    .copyFromBuilder(automatedReasoningPolicyBuildWorkflowSummaries);
        }

        @Override
        public final Builder automatedReasoningPolicyBuildWorkflowSummaries(
                Collection<AutomatedReasoningPolicyBuildWorkflowSummary> automatedReasoningPolicyBuildWorkflowSummaries) {
            this.automatedReasoningPolicyBuildWorkflowSummaries = AutomatedReasoningPolicyBuildWorkflowSummariesCopier
                    .copy(automatedReasoningPolicyBuildWorkflowSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder automatedReasoningPolicyBuildWorkflowSummaries(
                AutomatedReasoningPolicyBuildWorkflowSummary... automatedReasoningPolicyBuildWorkflowSummaries) {
            automatedReasoningPolicyBuildWorkflowSummaries(Arrays.asList(automatedReasoningPolicyBuildWorkflowSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder automatedReasoningPolicyBuildWorkflowSummaries(
                Consumer<AutomatedReasoningPolicyBuildWorkflowSummary.Builder>... automatedReasoningPolicyBuildWorkflowSummaries) {
            automatedReasoningPolicyBuildWorkflowSummaries(Stream.of(automatedReasoningPolicyBuildWorkflowSummaries)
                    .map(c -> AutomatedReasoningPolicyBuildWorkflowSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAutomatedReasoningPolicyBuildWorkflowsResponse build() {
            return new ListAutomatedReasoningPolicyBuildWorkflowsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
