/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains configuration details for retrieving information from a knowledge base and generating responses.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KnowledgeBaseRetrieveAndGenerateConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<KnowledgeBaseRetrieveAndGenerateConfiguration.Builder, KnowledgeBaseRetrieveAndGenerateConfiguration> {
    private static final SdkField<String> KNOWLEDGE_BASE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("knowledgeBaseId").getter(getter(KnowledgeBaseRetrieveAndGenerateConfiguration::knowledgeBaseId))
            .setter(setter(Builder::knowledgeBaseId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeBaseId").build()).build();

    private static final SdkField<String> MODEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("modelArn").getter(getter(KnowledgeBaseRetrieveAndGenerateConfiguration::modelArn))
            .setter(setter(Builder::modelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelArn").build()).build();

    private static final SdkField<KnowledgeBaseRetrievalConfiguration> RETRIEVAL_CONFIGURATION_FIELD = SdkField
            .<KnowledgeBaseRetrievalConfiguration> builder(MarshallingType.SDK_POJO).memberName("retrievalConfiguration")
            .getter(getter(KnowledgeBaseRetrieveAndGenerateConfiguration::retrievalConfiguration))
            .setter(setter(Builder::retrievalConfiguration)).constructor(KnowledgeBaseRetrievalConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retrievalConfiguration").build())
            .build();

    private static final SdkField<GenerationConfiguration> GENERATION_CONFIGURATION_FIELD = SdkField
            .<GenerationConfiguration> builder(MarshallingType.SDK_POJO).memberName("generationConfiguration")
            .getter(getter(KnowledgeBaseRetrieveAndGenerateConfiguration::generationConfiguration))
            .setter(setter(Builder::generationConfiguration)).constructor(GenerationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("generationConfiguration").build())
            .build();

    private static final SdkField<OrchestrationConfiguration> ORCHESTRATION_CONFIGURATION_FIELD = SdkField
            .<OrchestrationConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("orchestrationConfiguration")
            .getter(getter(KnowledgeBaseRetrieveAndGenerateConfiguration::orchestrationConfiguration))
            .setter(setter(Builder::orchestrationConfiguration))
            .constructor(OrchestrationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("orchestrationConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KNOWLEDGE_BASE_ID_FIELD,
            MODEL_ARN_FIELD, RETRIEVAL_CONFIGURATION_FIELD, GENERATION_CONFIGURATION_FIELD, ORCHESTRATION_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String knowledgeBaseId;

    private final String modelArn;

    private final KnowledgeBaseRetrievalConfiguration retrievalConfiguration;

    private final GenerationConfiguration generationConfiguration;

    private final OrchestrationConfiguration orchestrationConfiguration;

    private KnowledgeBaseRetrieveAndGenerateConfiguration(BuilderImpl builder) {
        this.knowledgeBaseId = builder.knowledgeBaseId;
        this.modelArn = builder.modelArn;
        this.retrievalConfiguration = builder.retrievalConfiguration;
        this.generationConfiguration = builder.generationConfiguration;
        this.orchestrationConfiguration = builder.orchestrationConfiguration;
    }

    /**
     * <p>
     * The unique identifier of the knowledge base.
     * </p>
     * 
     * @return The unique identifier of the knowledge base.
     */
    public final String knowledgeBaseId() {
        return knowledgeBaseId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the foundation model or <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/cross-region-inference.html">inference profile</a>
     * used to generate responses.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the foundation model or <a
     *         href="https://docs.aws.amazon.com/bedrock/latest/userguide/cross-region-inference.html">inference
     *         profile</a> used to generate responses.
     */
    public final String modelArn() {
        return modelArn;
    }

    /**
     * <p>
     * Contains configuration details for retrieving text chunks.
     * </p>
     * 
     * @return Contains configuration details for retrieving text chunks.
     */
    public final KnowledgeBaseRetrievalConfiguration retrievalConfiguration() {
        return retrievalConfiguration;
    }

    /**
     * <p>
     * Contains configurations details for response generation based on retrieved text chunks.
     * </p>
     * 
     * @return Contains configurations details for response generation based on retrieved text chunks.
     */
    public final GenerationConfiguration generationConfiguration() {
        return generationConfiguration;
    }

    /**
     * <p>
     * Contains configuration details for the model to process the prompt prior to retrieval and response generation.
     * </p>
     * 
     * @return Contains configuration details for the model to process the prompt prior to retrieval and response
     *         generation.
     */
    public final OrchestrationConfiguration orchestrationConfiguration() {
        return orchestrationConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(knowledgeBaseId());
        hashCode = 31 * hashCode + Objects.hashCode(modelArn());
        hashCode = 31 * hashCode + Objects.hashCode(retrievalConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(generationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(orchestrationConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KnowledgeBaseRetrieveAndGenerateConfiguration)) {
            return false;
        }
        KnowledgeBaseRetrieveAndGenerateConfiguration other = (KnowledgeBaseRetrieveAndGenerateConfiguration) obj;
        return Objects.equals(knowledgeBaseId(), other.knowledgeBaseId()) && Objects.equals(modelArn(), other.modelArn())
                && Objects.equals(retrievalConfiguration(), other.retrievalConfiguration())
                && Objects.equals(generationConfiguration(), other.generationConfiguration())
                && Objects.equals(orchestrationConfiguration(), other.orchestrationConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KnowledgeBaseRetrieveAndGenerateConfiguration").add("KnowledgeBaseId", knowledgeBaseId())
                .add("ModelArn", modelArn()).add("RetrievalConfiguration", retrievalConfiguration())
                .add("GenerationConfiguration", generationConfiguration())
                .add("OrchestrationConfiguration", orchestrationConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "knowledgeBaseId":
            return Optional.ofNullable(clazz.cast(knowledgeBaseId()));
        case "modelArn":
            return Optional.ofNullable(clazz.cast(modelArn()));
        case "retrievalConfiguration":
            return Optional.ofNullable(clazz.cast(retrievalConfiguration()));
        case "generationConfiguration":
            return Optional.ofNullable(clazz.cast(generationConfiguration()));
        case "orchestrationConfiguration":
            return Optional.ofNullable(clazz.cast(orchestrationConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("knowledgeBaseId", KNOWLEDGE_BASE_ID_FIELD);
        map.put("modelArn", MODEL_ARN_FIELD);
        map.put("retrievalConfiguration", RETRIEVAL_CONFIGURATION_FIELD);
        map.put("generationConfiguration", GENERATION_CONFIGURATION_FIELD);
        map.put("orchestrationConfiguration", ORCHESTRATION_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KnowledgeBaseRetrieveAndGenerateConfiguration, T> g) {
        return obj -> g.apply((KnowledgeBaseRetrieveAndGenerateConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KnowledgeBaseRetrieveAndGenerateConfiguration> {
        /**
         * <p>
         * The unique identifier of the knowledge base.
         * </p>
         * 
         * @param knowledgeBaseId
         *        The unique identifier of the knowledge base.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder knowledgeBaseId(String knowledgeBaseId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the foundation model or <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/cross-region-inference.html">inference profile</a>
         * used to generate responses.
         * </p>
         * 
         * @param modelArn
         *        The Amazon Resource Name (ARN) of the foundation model or <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/userguide/cross-region-inference.html">inference
         *        profile</a> used to generate responses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelArn(String modelArn);

        /**
         * <p>
         * Contains configuration details for retrieving text chunks.
         * </p>
         * 
         * @param retrievalConfiguration
         *        Contains configuration details for retrieving text chunks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retrievalConfiguration(KnowledgeBaseRetrievalConfiguration retrievalConfiguration);

        /**
         * <p>
         * Contains configuration details for retrieving text chunks.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link KnowledgeBaseRetrievalConfiguration.Builder} avoiding the need to create one manually via
         * {@link KnowledgeBaseRetrievalConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KnowledgeBaseRetrievalConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #retrievalConfiguration(KnowledgeBaseRetrievalConfiguration)}.
         * 
         * @param retrievalConfiguration
         *        a consumer that will call methods on {@link KnowledgeBaseRetrievalConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #retrievalConfiguration(KnowledgeBaseRetrievalConfiguration)
         */
        default Builder retrievalConfiguration(Consumer<KnowledgeBaseRetrievalConfiguration.Builder> retrievalConfiguration) {
            return retrievalConfiguration(KnowledgeBaseRetrievalConfiguration.builder().applyMutation(retrievalConfiguration)
                    .build());
        }

        /**
         * <p>
         * Contains configurations details for response generation based on retrieved text chunks.
         * </p>
         * 
         * @param generationConfiguration
         *        Contains configurations details for response generation based on retrieved text chunks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder generationConfiguration(GenerationConfiguration generationConfiguration);

        /**
         * <p>
         * Contains configurations details for response generation based on retrieved text chunks.
         * </p>
         * This is a convenience method that creates an instance of the {@link GenerationConfiguration.Builder} avoiding
         * the need to create one manually via {@link GenerationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GenerationConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #generationConfiguration(GenerationConfiguration)}.
         * 
         * @param generationConfiguration
         *        a consumer that will call methods on {@link GenerationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #generationConfiguration(GenerationConfiguration)
         */
        default Builder generationConfiguration(Consumer<GenerationConfiguration.Builder> generationConfiguration) {
            return generationConfiguration(GenerationConfiguration.builder().applyMutation(generationConfiguration).build());
        }

        /**
         * <p>
         * Contains configuration details for the model to process the prompt prior to retrieval and response
         * generation.
         * </p>
         * 
         * @param orchestrationConfiguration
         *        Contains configuration details for the model to process the prompt prior to retrieval and response
         *        generation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orchestrationConfiguration(OrchestrationConfiguration orchestrationConfiguration);

        /**
         * <p>
         * Contains configuration details for the model to process the prompt prior to retrieval and response
         * generation.
         * </p>
         * This is a convenience method that creates an instance of the {@link OrchestrationConfiguration.Builder}
         * avoiding the need to create one manually via {@link OrchestrationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OrchestrationConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #orchestrationConfiguration(OrchestrationConfiguration)}.
         * 
         * @param orchestrationConfiguration
         *        a consumer that will call methods on {@link OrchestrationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #orchestrationConfiguration(OrchestrationConfiguration)
         */
        default Builder orchestrationConfiguration(Consumer<OrchestrationConfiguration.Builder> orchestrationConfiguration) {
            return orchestrationConfiguration(OrchestrationConfiguration.builder().applyMutation(orchestrationConfiguration)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String knowledgeBaseId;

        private String modelArn;

        private KnowledgeBaseRetrievalConfiguration retrievalConfiguration;

        private GenerationConfiguration generationConfiguration;

        private OrchestrationConfiguration orchestrationConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(KnowledgeBaseRetrieveAndGenerateConfiguration model) {
            knowledgeBaseId(model.knowledgeBaseId);
            modelArn(model.modelArn);
            retrievalConfiguration(model.retrievalConfiguration);
            generationConfiguration(model.generationConfiguration);
            orchestrationConfiguration(model.orchestrationConfiguration);
        }

        public final String getKnowledgeBaseId() {
            return knowledgeBaseId;
        }

        public final void setKnowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
        }

        @Override
        public final Builder knowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
            return this;
        }

        public final String getModelArn() {
            return modelArn;
        }

        public final void setModelArn(String modelArn) {
            this.modelArn = modelArn;
        }

        @Override
        public final Builder modelArn(String modelArn) {
            this.modelArn = modelArn;
            return this;
        }

        public final KnowledgeBaseRetrievalConfiguration.Builder getRetrievalConfiguration() {
            return retrievalConfiguration != null ? retrievalConfiguration.toBuilder() : null;
        }

        public final void setRetrievalConfiguration(KnowledgeBaseRetrievalConfiguration.BuilderImpl retrievalConfiguration) {
            this.retrievalConfiguration = retrievalConfiguration != null ? retrievalConfiguration.build() : null;
        }

        @Override
        public final Builder retrievalConfiguration(KnowledgeBaseRetrievalConfiguration retrievalConfiguration) {
            this.retrievalConfiguration = retrievalConfiguration;
            return this;
        }

        public final GenerationConfiguration.Builder getGenerationConfiguration() {
            return generationConfiguration != null ? generationConfiguration.toBuilder() : null;
        }

        public final void setGenerationConfiguration(GenerationConfiguration.BuilderImpl generationConfiguration) {
            this.generationConfiguration = generationConfiguration != null ? generationConfiguration.build() : null;
        }

        @Override
        public final Builder generationConfiguration(GenerationConfiguration generationConfiguration) {
            this.generationConfiguration = generationConfiguration;
            return this;
        }

        public final OrchestrationConfiguration.Builder getOrchestrationConfiguration() {
            return orchestrationConfiguration != null ? orchestrationConfiguration.toBuilder() : null;
        }

        public final void setOrchestrationConfiguration(OrchestrationConfiguration.BuilderImpl orchestrationConfiguration) {
            this.orchestrationConfiguration = orchestrationConfiguration != null ? orchestrationConfiguration.build() : null;
        }

        @Override
        public final Builder orchestrationConfiguration(OrchestrationConfiguration orchestrationConfiguration) {
            this.orchestrationConfiguration = orchestrationConfiguration;
            return this;
        }

        @Override
        public KnowledgeBaseRetrieveAndGenerateConfiguration build() {
            return new KnowledgeBaseRetrieveAndGenerateConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
