/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details about the system-defined guardrail profile that you're using with your guardrail for cross-Region
 * inference.
 * </p>
 * <p>
 * For more information, see the <a
 * href="https://docs.aws.amazon.com/bedrock/latest/userguide/guardrails-cross-region.html">Amazon Bedrock User
 * Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GuardrailCrossRegionDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<GuardrailCrossRegionDetails.Builder, GuardrailCrossRegionDetails> {
    private static final SdkField<String> GUARDRAIL_PROFILE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("guardrailProfileId").getter(getter(GuardrailCrossRegionDetails::guardrailProfileId))
            .setter(setter(Builder::guardrailProfileId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("guardrailProfileId").build())
            .build();

    private static final SdkField<String> GUARDRAIL_PROFILE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("guardrailProfileArn").getter(getter(GuardrailCrossRegionDetails::guardrailProfileArn))
            .setter(setter(Builder::guardrailProfileArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("guardrailProfileArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GUARDRAIL_PROFILE_ID_FIELD,
            GUARDRAIL_PROFILE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String guardrailProfileId;

    private final String guardrailProfileArn;

    private GuardrailCrossRegionDetails(BuilderImpl builder) {
        this.guardrailProfileId = builder.guardrailProfileId;
        this.guardrailProfileArn = builder.guardrailProfileArn;
    }

    /**
     * <p>
     * The ID of the guardrail profile that your guardrail is using. Profile availability depends on your current Amazon
     * Web Services Region. For more information, see the <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/guardrails-cross-region-support.html">Amazon Bedrock
     * User Guide</a>.
     * </p>
     * 
     * @return The ID of the guardrail profile that your guardrail is using. Profile availability depends on your
     *         current Amazon Web Services Region. For more information, see the <a
     *         href="https://docs.aws.amazon.com/bedrock/latest/userguide/guardrails-cross-region-support.html">Amazon
     *         Bedrock User Guide</a>.
     */
    public final String guardrailProfileId() {
        return guardrailProfileId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the guardrail profile that you're using with your guardrail.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the guardrail profile that you're using with your guardrail.
     */
    public final String guardrailProfileArn() {
        return guardrailProfileArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(guardrailProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(guardrailProfileArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GuardrailCrossRegionDetails)) {
            return false;
        }
        GuardrailCrossRegionDetails other = (GuardrailCrossRegionDetails) obj;
        return Objects.equals(guardrailProfileId(), other.guardrailProfileId())
                && Objects.equals(guardrailProfileArn(), other.guardrailProfileArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GuardrailCrossRegionDetails").add("GuardrailProfileId", guardrailProfileId())
                .add("GuardrailProfileArn", guardrailProfileArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "guardrailProfileId":
            return Optional.ofNullable(clazz.cast(guardrailProfileId()));
        case "guardrailProfileArn":
            return Optional.ofNullable(clazz.cast(guardrailProfileArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("guardrailProfileId", GUARDRAIL_PROFILE_ID_FIELD);
        map.put("guardrailProfileArn", GUARDRAIL_PROFILE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GuardrailCrossRegionDetails, T> g) {
        return obj -> g.apply((GuardrailCrossRegionDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GuardrailCrossRegionDetails> {
        /**
         * <p>
         * The ID of the guardrail profile that your guardrail is using. Profile availability depends on your current
         * Amazon Web Services Region. For more information, see the <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/guardrails-cross-region-support.html">Amazon
         * Bedrock User Guide</a>.
         * </p>
         * 
         * @param guardrailProfileId
         *        The ID of the guardrail profile that your guardrail is using. Profile availability depends on your
         *        current Amazon Web Services Region. For more information, see the <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/userguide/guardrails-cross-region-support.html"
         *        >Amazon Bedrock User Guide</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder guardrailProfileId(String guardrailProfileId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the guardrail profile that you're using with your guardrail.
         * </p>
         * 
         * @param guardrailProfileArn
         *        The Amazon Resource Name (ARN) of the guardrail profile that you're using with your guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder guardrailProfileArn(String guardrailProfileArn);
    }

    static final class BuilderImpl implements Builder {
        private String guardrailProfileId;

        private String guardrailProfileArn;

        private BuilderImpl() {
        }

        private BuilderImpl(GuardrailCrossRegionDetails model) {
            guardrailProfileId(model.guardrailProfileId);
            guardrailProfileArn(model.guardrailProfileArn);
        }

        public final String getGuardrailProfileId() {
            return guardrailProfileId;
        }

        public final void setGuardrailProfileId(String guardrailProfileId) {
            this.guardrailProfileId = guardrailProfileId;
        }

        @Override
        public final Builder guardrailProfileId(String guardrailProfileId) {
            this.guardrailProfileId = guardrailProfileId;
            return this;
        }

        public final String getGuardrailProfileArn() {
            return guardrailProfileArn;
        }

        public final void setGuardrailProfileArn(String guardrailProfileArn) {
            this.guardrailProfileArn = guardrailProfileArn;
        }

        @Override
        public final Builder guardrailProfileArn(String guardrailProfileArn) {
            this.guardrailProfileArn = guardrailProfileArn;
            return this;
        }

        @Override
        public GuardrailCrossRegionDetails build() {
            return new GuardrailCrossRegionDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
