/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCustomModelDeploymentResponse extends BedrockResponse implements
        ToCopyableBuilder<GetCustomModelDeploymentResponse.Builder, GetCustomModelDeploymentResponse> {
    private static final SdkField<String> CUSTOM_MODEL_DEPLOYMENT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("customModelDeploymentArn").getter(getter(GetCustomModelDeploymentResponse::customModelDeploymentArn))
            .setter(setter(Builder::customModelDeploymentArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customModelDeploymentArn").build())
            .build();

    private static final SdkField<String> MODEL_DEPLOYMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("modelDeploymentName").getter(getter(GetCustomModelDeploymentResponse::modelDeploymentName))
            .setter(setter(Builder::modelDeploymentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelDeploymentName").build())
            .build();

    private static final SdkField<String> MODEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("modelArn").getter(getter(GetCustomModelDeploymentResponse::modelArn)).setter(setter(Builder::modelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelArn").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(GetCustomModelDeploymentResponse::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetCustomModelDeploymentResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(GetCustomModelDeploymentResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<CustomModelDeploymentUpdateDetails> UPDATE_DETAILS_FIELD = SdkField
            .<CustomModelDeploymentUpdateDetails> builder(MarshallingType.SDK_POJO).memberName("updateDetails")
            .getter(getter(GetCustomModelDeploymentResponse::updateDetails)).setter(setter(Builder::updateDetails))
            .constructor(CustomModelDeploymentUpdateDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateDetails").build()).build();

    private static final SdkField<String> FAILURE_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("failureMessage").getter(getter(GetCustomModelDeploymentResponse::failureMessage))
            .setter(setter(Builder::failureMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureMessage").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedAt")
            .getter(getter(GetCustomModelDeploymentResponse::lastUpdatedAt))
            .setter(setter(Builder::lastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CUSTOM_MODEL_DEPLOYMENT_ARN_FIELD, MODEL_DEPLOYMENT_NAME_FIELD, MODEL_ARN_FIELD, CREATED_AT_FIELD, STATUS_FIELD,
            DESCRIPTION_FIELD, UPDATE_DETAILS_FIELD, FAILURE_MESSAGE_FIELD, LAST_UPDATED_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String customModelDeploymentArn;

    private final String modelDeploymentName;

    private final String modelArn;

    private final Instant createdAt;

    private final String status;

    private final String description;

    private final CustomModelDeploymentUpdateDetails updateDetails;

    private final String failureMessage;

    private final Instant lastUpdatedAt;

    private GetCustomModelDeploymentResponse(BuilderImpl builder) {
        super(builder);
        this.customModelDeploymentArn = builder.customModelDeploymentArn;
        this.modelDeploymentName = builder.modelDeploymentName;
        this.modelArn = builder.modelArn;
        this.createdAt = builder.createdAt;
        this.status = builder.status;
        this.description = builder.description;
        this.updateDetails = builder.updateDetails;
        this.failureMessage = builder.failureMessage;
        this.lastUpdatedAt = builder.lastUpdatedAt;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the custom model deployment.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the custom model deployment.
     */
    public final String customModelDeploymentArn() {
        return customModelDeploymentArn;
    }

    /**
     * <p>
     * The name of the custom model deployment.
     * </p>
     * 
     * @return The name of the custom model deployment.
     */
    public final String modelDeploymentName() {
        return modelDeploymentName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the custom model associated with this deployment.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the custom model associated with this deployment.
     */
    public final String modelArn() {
        return modelArn;
    }

    /**
     * <p>
     * The date and time when the custom model deployment was created.
     * </p>
     * 
     * @return The date and time when the custom model deployment was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The status of the custom model deployment. Possible values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATING</code> - The deployment is being set up and prepared for inference.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACTIVE</code> - The deployment is ready and available for inference requests.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code> - The deployment failed to be created or became unavailable.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CustomModelDeploymentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the custom model deployment. Possible values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATING</code> - The deployment is being set up and prepared for inference.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code> - The deployment is ready and available for inference requests.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code> - The deployment failed to be created or became unavailable.
     *         </p>
     *         </li>
     * @see CustomModelDeploymentStatus
     */
    public final CustomModelDeploymentStatus status() {
        return CustomModelDeploymentStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the custom model deployment. Possible values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATING</code> - The deployment is being set up and prepared for inference.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACTIVE</code> - The deployment is ready and available for inference requests.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code> - The deployment failed to be created or became unavailable.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CustomModelDeploymentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the custom model deployment. Possible values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATING</code> - The deployment is being set up and prepared for inference.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code> - The deployment is ready and available for inference requests.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code> - The deployment failed to be created or became unavailable.
     *         </p>
     *         </li>
     * @see CustomModelDeploymentStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The description of the custom model deployment.
     * </p>
     * 
     * @return The description of the custom model deployment.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Details about any pending or completed updates to the custom model deployment, including the new model ARN and
     * update status.
     * </p>
     * 
     * @return Details about any pending or completed updates to the custom model deployment, including the new model
     *         ARN and update status.
     */
    public final CustomModelDeploymentUpdateDetails updateDetails() {
        return updateDetails;
    }

    /**
     * <p>
     * If the deployment status is <code>FAILED</code>, this field contains a message describing the failure reason.
     * </p>
     * 
     * @return If the deployment status is <code>FAILED</code>, this field contains a message describing the failure
     *         reason.
     */
    public final String failureMessage() {
        return failureMessage;
    }

    /**
     * <p>
     * The date and time when the custom model deployment was last updated.
     * </p>
     * 
     * @return The date and time when the custom model deployment was last updated.
     */
    public final Instant lastUpdatedAt() {
        return lastUpdatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(customModelDeploymentArn());
        hashCode = 31 * hashCode + Objects.hashCode(modelDeploymentName());
        hashCode = 31 * hashCode + Objects.hashCode(modelArn());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(updateDetails());
        hashCode = 31 * hashCode + Objects.hashCode(failureMessage());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCustomModelDeploymentResponse)) {
            return false;
        }
        GetCustomModelDeploymentResponse other = (GetCustomModelDeploymentResponse) obj;
        return Objects.equals(customModelDeploymentArn(), other.customModelDeploymentArn())
                && Objects.equals(modelDeploymentName(), other.modelDeploymentName())
                && Objects.equals(modelArn(), other.modelArn()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(description(), other.description())
                && Objects.equals(updateDetails(), other.updateDetails())
                && Objects.equals(failureMessage(), other.failureMessage())
                && Objects.equals(lastUpdatedAt(), other.lastUpdatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetCustomModelDeploymentResponse").add("CustomModelDeploymentArn", customModelDeploymentArn())
                .add("ModelDeploymentName", modelDeploymentName()).add("ModelArn", modelArn()).add("CreatedAt", createdAt())
                .add("Status", statusAsString()).add("Description", description()).add("UpdateDetails", updateDetails())
                .add("FailureMessage", failureMessage()).add("LastUpdatedAt", lastUpdatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "customModelDeploymentArn":
            return Optional.ofNullable(clazz.cast(customModelDeploymentArn()));
        case "modelDeploymentName":
            return Optional.ofNullable(clazz.cast(modelDeploymentName()));
        case "modelArn":
            return Optional.ofNullable(clazz.cast(modelArn()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "updateDetails":
            return Optional.ofNullable(clazz.cast(updateDetails()));
        case "failureMessage":
            return Optional.ofNullable(clazz.cast(failureMessage()));
        case "lastUpdatedAt":
            return Optional.ofNullable(clazz.cast(lastUpdatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("customModelDeploymentArn", CUSTOM_MODEL_DEPLOYMENT_ARN_FIELD);
        map.put("modelDeploymentName", MODEL_DEPLOYMENT_NAME_FIELD);
        map.put("modelArn", MODEL_ARN_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("updateDetails", UPDATE_DETAILS_FIELD);
        map.put("failureMessage", FAILURE_MESSAGE_FIELD);
        map.put("lastUpdatedAt", LAST_UPDATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetCustomModelDeploymentResponse, T> g) {
        return obj -> g.apply((GetCustomModelDeploymentResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetCustomModelDeploymentResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the custom model deployment.
         * </p>
         * 
         * @param customModelDeploymentArn
         *        The Amazon Resource Name (ARN) of the custom model deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customModelDeploymentArn(String customModelDeploymentArn);

        /**
         * <p>
         * The name of the custom model deployment.
         * </p>
         * 
         * @param modelDeploymentName
         *        The name of the custom model deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelDeploymentName(String modelDeploymentName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the custom model associated with this deployment.
         * </p>
         * 
         * @param modelArn
         *        The Amazon Resource Name (ARN) of the custom model associated with this deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelArn(String modelArn);

        /**
         * <p>
         * The date and time when the custom model deployment was created.
         * </p>
         * 
         * @param createdAt
         *        The date and time when the custom model deployment was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The status of the custom model deployment. Possible values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATING</code> - The deployment is being set up and prepared for inference.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACTIVE</code> - The deployment is ready and available for inference requests.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code> - The deployment failed to be created or became unavailable.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the custom model deployment. Possible values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATING</code> - The deployment is being set up and prepared for inference.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code> - The deployment is ready and available for inference requests.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code> - The deployment failed to be created or became unavailable.
         *        </p>
         *        </li>
         * @see CustomModelDeploymentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CustomModelDeploymentStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the custom model deployment. Possible values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATING</code> - The deployment is being set up and prepared for inference.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACTIVE</code> - The deployment is ready and available for inference requests.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code> - The deployment failed to be created or became unavailable.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the custom model deployment. Possible values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATING</code> - The deployment is being set up and prepared for inference.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code> - The deployment is ready and available for inference requests.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code> - The deployment failed to be created or became unavailable.
         *        </p>
         *        </li>
         * @see CustomModelDeploymentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CustomModelDeploymentStatus
         */
        Builder status(CustomModelDeploymentStatus status);

        /**
         * <p>
         * The description of the custom model deployment.
         * </p>
         * 
         * @param description
         *        The description of the custom model deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Details about any pending or completed updates to the custom model deployment, including the new model ARN
         * and update status.
         * </p>
         * 
         * @param updateDetails
         *        Details about any pending or completed updates to the custom model deployment, including the new model
         *        ARN and update status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateDetails(CustomModelDeploymentUpdateDetails updateDetails);

        /**
         * <p>
         * Details about any pending or completed updates to the custom model deployment, including the new model ARN
         * and update status.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link CustomModelDeploymentUpdateDetails.Builder} avoiding the need to create one manually via
         * {@link CustomModelDeploymentUpdateDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CustomModelDeploymentUpdateDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #updateDetails(CustomModelDeploymentUpdateDetails)}.
         * 
         * @param updateDetails
         *        a consumer that will call methods on {@link CustomModelDeploymentUpdateDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #updateDetails(CustomModelDeploymentUpdateDetails)
         */
        default Builder updateDetails(Consumer<CustomModelDeploymentUpdateDetails.Builder> updateDetails) {
            return updateDetails(CustomModelDeploymentUpdateDetails.builder().applyMutation(updateDetails).build());
        }

        /**
         * <p>
         * If the deployment status is <code>FAILED</code>, this field contains a message describing the failure reason.
         * </p>
         * 
         * @param failureMessage
         *        If the deployment status is <code>FAILED</code>, this field contains a message describing the failure
         *        reason.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureMessage(String failureMessage);

        /**
         * <p>
         * The date and time when the custom model deployment was last updated.
         * </p>
         * 
         * @param lastUpdatedAt
         *        The date and time when the custom model deployment was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Instant lastUpdatedAt);
    }

    static final class BuilderImpl extends BedrockResponse.BuilderImpl implements Builder {
        private String customModelDeploymentArn;

        private String modelDeploymentName;

        private String modelArn;

        private Instant createdAt;

        private String status;

        private String description;

        private CustomModelDeploymentUpdateDetails updateDetails;

        private String failureMessage;

        private Instant lastUpdatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCustomModelDeploymentResponse model) {
            super(model);
            customModelDeploymentArn(model.customModelDeploymentArn);
            modelDeploymentName(model.modelDeploymentName);
            modelArn(model.modelArn);
            createdAt(model.createdAt);
            status(model.status);
            description(model.description);
            updateDetails(model.updateDetails);
            failureMessage(model.failureMessage);
            lastUpdatedAt(model.lastUpdatedAt);
        }

        public final String getCustomModelDeploymentArn() {
            return customModelDeploymentArn;
        }

        public final void setCustomModelDeploymentArn(String customModelDeploymentArn) {
            this.customModelDeploymentArn = customModelDeploymentArn;
        }

        @Override
        public final Builder customModelDeploymentArn(String customModelDeploymentArn) {
            this.customModelDeploymentArn = customModelDeploymentArn;
            return this;
        }

        public final String getModelDeploymentName() {
            return modelDeploymentName;
        }

        public final void setModelDeploymentName(String modelDeploymentName) {
            this.modelDeploymentName = modelDeploymentName;
        }

        @Override
        public final Builder modelDeploymentName(String modelDeploymentName) {
            this.modelDeploymentName = modelDeploymentName;
            return this;
        }

        public final String getModelArn() {
            return modelArn;
        }

        public final void setModelArn(String modelArn) {
            this.modelArn = modelArn;
        }

        @Override
        public final Builder modelArn(String modelArn) {
            this.modelArn = modelArn;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CustomModelDeploymentStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final CustomModelDeploymentUpdateDetails.Builder getUpdateDetails() {
            return updateDetails != null ? updateDetails.toBuilder() : null;
        }

        public final void setUpdateDetails(CustomModelDeploymentUpdateDetails.BuilderImpl updateDetails) {
            this.updateDetails = updateDetails != null ? updateDetails.build() : null;
        }

        @Override
        public final Builder updateDetails(CustomModelDeploymentUpdateDetails updateDetails) {
            this.updateDetails = updateDetails;
            return this;
        }

        public final String getFailureMessage() {
            return failureMessage;
        }

        public final void setFailureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
        }

        @Override
        public final Builder failureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        @Override
        public GetCustomModelDeploymentResponse build() {
            return new GetCustomModelDeploymentResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
