/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A model customization configuration
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomizationConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<CustomizationConfig.Builder, CustomizationConfig> {
    private static final SdkField<DistillationConfig> DISTILLATION_CONFIG_FIELD = SdkField
            .<DistillationConfig> builder(MarshallingType.SDK_POJO).memberName("distillationConfig")
            .getter(getter(CustomizationConfig::distillationConfig)).setter(setter(Builder::distillationConfig))
            .constructor(DistillationConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("distillationConfig").build())
            .build();

    private static final SdkField<RFTConfig> RFT_CONFIG_FIELD = SdkField.<RFTConfig> builder(MarshallingType.SDK_POJO)
            .memberName("rftConfig").getter(getter(CustomizationConfig::rftConfig)).setter(setter(Builder::rftConfig))
            .constructor(RFTConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rftConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISTILLATION_CONFIG_FIELD,
            RFT_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final DistillationConfig distillationConfig;

    private final RFTConfig rftConfig;

    private final Type type;

    private CustomizationConfig(BuilderImpl builder) {
        this.distillationConfig = builder.distillationConfig;
        this.rftConfig = builder.rftConfig;
        this.type = builder.type;
    }

    /**
     * <p>
     * The Distillation configuration for the custom model.
     * </p>
     * 
     * @return The Distillation configuration for the custom model.
     */
    public final DistillationConfig distillationConfig() {
        return distillationConfig;
    }

    /**
     * <p>
     * Configuration settings for reinforcement fine-tuning (RFT) model customization, including grader configuration
     * and hyperparameters.
     * </p>
     * 
     * @return Configuration settings for reinforcement fine-tuning (RFT) model customization, including grader
     *         configuration and hyperparameters.
     */
    public final RFTConfig rftConfig() {
        return rftConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(distillationConfig());
        hashCode = 31 * hashCode + Objects.hashCode(rftConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomizationConfig)) {
            return false;
        }
        CustomizationConfig other = (CustomizationConfig) obj;
        return Objects.equals(distillationConfig(), other.distillationConfig()) && Objects.equals(rftConfig(), other.rftConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomizationConfig").add("DistillationConfig", distillationConfig())
                .add("RftConfig", rftConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "distillationConfig":
            return Optional.ofNullable(clazz.cast(distillationConfig()));
        case "rftConfig":
            return Optional.ofNullable(clazz.cast(rftConfig()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #distillationConfig()} initialized to the given value.
     *
     * <p>
     * The Distillation configuration for the custom model.
     * </p>
     * 
     * @param distillationConfig
     *        The Distillation configuration for the custom model.
     */
    public static CustomizationConfig fromDistillationConfig(DistillationConfig distillationConfig) {
        return builder().distillationConfig(distillationConfig).build();
    }

    /**
     * Create an instance of this class with {@link #distillationConfig()} initialized to the given value.
     *
     * <p>
     * The Distillation configuration for the custom model.
     * </p>
     * 
     * @param distillationConfig
     *        The Distillation configuration for the custom model.
     */
    public static CustomizationConfig fromDistillationConfig(Consumer<DistillationConfig.Builder> distillationConfig) {
        DistillationConfig.Builder builder = DistillationConfig.builder();
        distillationConfig.accept(builder);
        return fromDistillationConfig(builder.build());
    }

    /**
     * Create an instance of this class with {@link #rftConfig()} initialized to the given value.
     *
     * <p>
     * Configuration settings for reinforcement fine-tuning (RFT) model customization, including grader configuration
     * and hyperparameters.
     * </p>
     * 
     * @param rftConfig
     *        Configuration settings for reinforcement fine-tuning (RFT) model customization, including grader
     *        configuration and hyperparameters.
     */
    public static CustomizationConfig fromRftConfig(RFTConfig rftConfig) {
        return builder().rftConfig(rftConfig).build();
    }

    /**
     * Create an instance of this class with {@link #rftConfig()} initialized to the given value.
     *
     * <p>
     * Configuration settings for reinforcement fine-tuning (RFT) model customization, including grader configuration
     * and hyperparameters.
     * </p>
     * 
     * @param rftConfig
     *        Configuration settings for reinforcement fine-tuning (RFT) model customization, including grader
     *        configuration and hyperparameters.
     */
    public static CustomizationConfig fromRftConfig(Consumer<RFTConfig.Builder> rftConfig) {
        RFTConfig.Builder builder = RFTConfig.builder();
        rftConfig.accept(builder);
        return fromRftConfig(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("distillationConfig", DISTILLATION_CONFIG_FIELD);
        map.put("rftConfig", RFT_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CustomizationConfig, T> g) {
        return obj -> g.apply((CustomizationConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomizationConfig> {
        /**
         * <p>
         * The Distillation configuration for the custom model.
         * </p>
         * 
         * @param distillationConfig
         *        The Distillation configuration for the custom model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder distillationConfig(DistillationConfig distillationConfig);

        /**
         * <p>
         * The Distillation configuration for the custom model.
         * </p>
         * This is a convenience method that creates an instance of the {@link DistillationConfig.Builder} avoiding the
         * need to create one manually via {@link DistillationConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DistillationConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #distillationConfig(DistillationConfig)}.
         * 
         * @param distillationConfig
         *        a consumer that will call methods on {@link DistillationConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #distillationConfig(DistillationConfig)
         */
        default Builder distillationConfig(Consumer<DistillationConfig.Builder> distillationConfig) {
            return distillationConfig(DistillationConfig.builder().applyMutation(distillationConfig).build());
        }

        /**
         * <p>
         * Configuration settings for reinforcement fine-tuning (RFT) model customization, including grader
         * configuration and hyperparameters.
         * </p>
         * 
         * @param rftConfig
         *        Configuration settings for reinforcement fine-tuning (RFT) model customization, including grader
         *        configuration and hyperparameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rftConfig(RFTConfig rftConfig);

        /**
         * <p>
         * Configuration settings for reinforcement fine-tuning (RFT) model customization, including grader
         * configuration and hyperparameters.
         * </p>
         * This is a convenience method that creates an instance of the {@link RFTConfig.Builder} avoiding the need to
         * create one manually via {@link RFTConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RFTConfig.Builder#build()} is called immediately and its result
         * is passed to {@link #rftConfig(RFTConfig)}.
         * 
         * @param rftConfig
         *        a consumer that will call methods on {@link RFTConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rftConfig(RFTConfig)
         */
        default Builder rftConfig(Consumer<RFTConfig.Builder> rftConfig) {
            return rftConfig(RFTConfig.builder().applyMutation(rftConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private DistillationConfig distillationConfig;

        private RFTConfig rftConfig;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(CustomizationConfig model) {
            distillationConfig(model.distillationConfig);
            rftConfig(model.rftConfig);
        }

        public final DistillationConfig.Builder getDistillationConfig() {
            return distillationConfig != null ? distillationConfig.toBuilder() : null;
        }

        public final void setDistillationConfig(DistillationConfig.BuilderImpl distillationConfig) {
            Object oldValue = this.distillationConfig;
            this.distillationConfig = distillationConfig != null ? distillationConfig.build() : null;
            handleUnionValueChange(Type.DISTILLATION_CONFIG, oldValue, this.distillationConfig);
        }

        @Override
        public final Builder distillationConfig(DistillationConfig distillationConfig) {
            Object oldValue = this.distillationConfig;
            this.distillationConfig = distillationConfig;
            handleUnionValueChange(Type.DISTILLATION_CONFIG, oldValue, this.distillationConfig);
            return this;
        }

        public final RFTConfig.Builder getRftConfig() {
            return rftConfig != null ? rftConfig.toBuilder() : null;
        }

        public final void setRftConfig(RFTConfig.BuilderImpl rftConfig) {
            Object oldValue = this.rftConfig;
            this.rftConfig = rftConfig != null ? rftConfig.build() : null;
            handleUnionValueChange(Type.RFT_CONFIG, oldValue, this.rftConfig);
        }

        @Override
        public final Builder rftConfig(RFTConfig rftConfig) {
            Object oldValue = this.rftConfig;
            this.rftConfig = rftConfig;
            handleUnionValueChange(Type.RFT_CONFIG, oldValue, this.rftConfig);
            return this;
        }

        @Override
        public CustomizationConfig build() {
            return new CustomizationConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see CustomizationConfig#type()
     */
    public enum Type {
        DISTILLATION_CONFIG,

        RFT_CONFIG,

        UNKNOWN_TO_SDK_VERSION
    }
}
