/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains summary information about a custom model deployment, including its ARN, name, status, and associated custom
 * model.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomModelDeploymentSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<CustomModelDeploymentSummary.Builder, CustomModelDeploymentSummary> {
    private static final SdkField<String> CUSTOM_MODEL_DEPLOYMENT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("customModelDeploymentArn").getter(getter(CustomModelDeploymentSummary::customModelDeploymentArn))
            .setter(setter(Builder::customModelDeploymentArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customModelDeploymentArn").build())
            .build();

    private static final SdkField<String> CUSTOM_MODEL_DEPLOYMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("customModelDeploymentName").getter(getter(CustomModelDeploymentSummary::customModelDeploymentName))
            .setter(setter(Builder::customModelDeploymentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customModelDeploymentName").build())
            .build();

    private static final SdkField<String> MODEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("modelArn").getter(getter(CustomModelDeploymentSummary::modelArn)).setter(setter(Builder::modelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelArn").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(CustomModelDeploymentSummary::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(CustomModelDeploymentSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedAt")
            .getter(getter(CustomModelDeploymentSummary::lastUpdatedAt))
            .setter(setter(Builder::lastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> FAILURE_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("failureMessage").getter(getter(CustomModelDeploymentSummary::failureMessage))
            .setter(setter(Builder::failureMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CUSTOM_MODEL_DEPLOYMENT_ARN_FIELD, CUSTOM_MODEL_DEPLOYMENT_NAME_FIELD, MODEL_ARN_FIELD, CREATED_AT_FIELD,
            STATUS_FIELD, LAST_UPDATED_AT_FIELD, FAILURE_MESSAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String customModelDeploymentArn;

    private final String customModelDeploymentName;

    private final String modelArn;

    private final Instant createdAt;

    private final String status;

    private final Instant lastUpdatedAt;

    private final String failureMessage;

    private CustomModelDeploymentSummary(BuilderImpl builder) {
        this.customModelDeploymentArn = builder.customModelDeploymentArn;
        this.customModelDeploymentName = builder.customModelDeploymentName;
        this.modelArn = builder.modelArn;
        this.createdAt = builder.createdAt;
        this.status = builder.status;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.failureMessage = builder.failureMessage;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the custom model deployment.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the custom model deployment.
     */
    public final String customModelDeploymentArn() {
        return customModelDeploymentArn;
    }

    /**
     * <p>
     * The name of the custom model deployment.
     * </p>
     * 
     * @return The name of the custom model deployment.
     */
    public final String customModelDeploymentName() {
        return customModelDeploymentName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the custom model associated with this deployment.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the custom model associated with this deployment.
     */
    public final String modelArn() {
        return modelArn;
    }

    /**
     * <p>
     * The date and time when the custom model deployment was created.
     * </p>
     * 
     * @return The date and time when the custom model deployment was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The status of the custom model deployment. Possible values are <code>CREATING</code>, <code>ACTIVE</code>, and
     * <code>FAILED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CustomModelDeploymentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the custom model deployment. Possible values are <code>CREATING</code>, <code>ACTIVE</code>
     *         , and <code>FAILED</code>.
     * @see CustomModelDeploymentStatus
     */
    public final CustomModelDeploymentStatus status() {
        return CustomModelDeploymentStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the custom model deployment. Possible values are <code>CREATING</code>, <code>ACTIVE</code>, and
     * <code>FAILED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CustomModelDeploymentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the custom model deployment. Possible values are <code>CREATING</code>, <code>ACTIVE</code>
     *         , and <code>FAILED</code>.
     * @see CustomModelDeploymentStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The date and time when the custom model deployment was last modified.
     * </p>
     * 
     * @return The date and time when the custom model deployment was last modified.
     */
    public final Instant lastUpdatedAt() {
        return lastUpdatedAt;
    }

    /**
     * <p>
     * If the deployment status is <code>FAILED</code>, this field contains a message describing the failure reason.
     * </p>
     * 
     * @return If the deployment status is <code>FAILED</code>, this field contains a message describing the failure
     *         reason.
     */
    public final String failureMessage() {
        return failureMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(customModelDeploymentArn());
        hashCode = 31 * hashCode + Objects.hashCode(customModelDeploymentName());
        hashCode = 31 * hashCode + Objects.hashCode(modelArn());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(failureMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomModelDeploymentSummary)) {
            return false;
        }
        CustomModelDeploymentSummary other = (CustomModelDeploymentSummary) obj;
        return Objects.equals(customModelDeploymentArn(), other.customModelDeploymentArn())
                && Objects.equals(customModelDeploymentName(), other.customModelDeploymentName())
                && Objects.equals(modelArn(), other.modelArn()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(lastUpdatedAt(), other.lastUpdatedAt())
                && Objects.equals(failureMessage(), other.failureMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomModelDeploymentSummary").add("CustomModelDeploymentArn", customModelDeploymentArn())
                .add("CustomModelDeploymentName", customModelDeploymentName()).add("ModelArn", modelArn())
                .add("CreatedAt", createdAt()).add("Status", statusAsString()).add("LastUpdatedAt", lastUpdatedAt())
                .add("FailureMessage", failureMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "customModelDeploymentArn":
            return Optional.ofNullable(clazz.cast(customModelDeploymentArn()));
        case "customModelDeploymentName":
            return Optional.ofNullable(clazz.cast(customModelDeploymentName()));
        case "modelArn":
            return Optional.ofNullable(clazz.cast(modelArn()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "lastUpdatedAt":
            return Optional.ofNullable(clazz.cast(lastUpdatedAt()));
        case "failureMessage":
            return Optional.ofNullable(clazz.cast(failureMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("customModelDeploymentArn", CUSTOM_MODEL_DEPLOYMENT_ARN_FIELD);
        map.put("customModelDeploymentName", CUSTOM_MODEL_DEPLOYMENT_NAME_FIELD);
        map.put("modelArn", MODEL_ARN_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("lastUpdatedAt", LAST_UPDATED_AT_FIELD);
        map.put("failureMessage", FAILURE_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CustomModelDeploymentSummary, T> g) {
        return obj -> g.apply((CustomModelDeploymentSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomModelDeploymentSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the custom model deployment.
         * </p>
         * 
         * @param customModelDeploymentArn
         *        The Amazon Resource Name (ARN) of the custom model deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customModelDeploymentArn(String customModelDeploymentArn);

        /**
         * <p>
         * The name of the custom model deployment.
         * </p>
         * 
         * @param customModelDeploymentName
         *        The name of the custom model deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customModelDeploymentName(String customModelDeploymentName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the custom model associated with this deployment.
         * </p>
         * 
         * @param modelArn
         *        The Amazon Resource Name (ARN) of the custom model associated with this deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelArn(String modelArn);

        /**
         * <p>
         * The date and time when the custom model deployment was created.
         * </p>
         * 
         * @param createdAt
         *        The date and time when the custom model deployment was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The status of the custom model deployment. Possible values are <code>CREATING</code>, <code>ACTIVE</code>,
         * and <code>FAILED</code>.
         * </p>
         * 
         * @param status
         *        The status of the custom model deployment. Possible values are <code>CREATING</code>,
         *        <code>ACTIVE</code>, and <code>FAILED</code>.
         * @see CustomModelDeploymentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CustomModelDeploymentStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the custom model deployment. Possible values are <code>CREATING</code>, <code>ACTIVE</code>,
         * and <code>FAILED</code>.
         * </p>
         * 
         * @param status
         *        The status of the custom model deployment. Possible values are <code>CREATING</code>,
         *        <code>ACTIVE</code>, and <code>FAILED</code>.
         * @see CustomModelDeploymentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CustomModelDeploymentStatus
         */
        Builder status(CustomModelDeploymentStatus status);

        /**
         * <p>
         * The date and time when the custom model deployment was last modified.
         * </p>
         * 
         * @param lastUpdatedAt
         *        The date and time when the custom model deployment was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Instant lastUpdatedAt);

        /**
         * <p>
         * If the deployment status is <code>FAILED</code>, this field contains a message describing the failure reason.
         * </p>
         * 
         * @param failureMessage
         *        If the deployment status is <code>FAILED</code>, this field contains a message describing the failure
         *        reason.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureMessage(String failureMessage);
    }

    static final class BuilderImpl implements Builder {
        private String customModelDeploymentArn;

        private String customModelDeploymentName;

        private String modelArn;

        private Instant createdAt;

        private String status;

        private Instant lastUpdatedAt;

        private String failureMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomModelDeploymentSummary model) {
            customModelDeploymentArn(model.customModelDeploymentArn);
            customModelDeploymentName(model.customModelDeploymentName);
            modelArn(model.modelArn);
            createdAt(model.createdAt);
            status(model.status);
            lastUpdatedAt(model.lastUpdatedAt);
            failureMessage(model.failureMessage);
        }

        public final String getCustomModelDeploymentArn() {
            return customModelDeploymentArn;
        }

        public final void setCustomModelDeploymentArn(String customModelDeploymentArn) {
            this.customModelDeploymentArn = customModelDeploymentArn;
        }

        @Override
        public final Builder customModelDeploymentArn(String customModelDeploymentArn) {
            this.customModelDeploymentArn = customModelDeploymentArn;
            return this;
        }

        public final String getCustomModelDeploymentName() {
            return customModelDeploymentName;
        }

        public final void setCustomModelDeploymentName(String customModelDeploymentName) {
            this.customModelDeploymentName = customModelDeploymentName;
        }

        @Override
        public final Builder customModelDeploymentName(String customModelDeploymentName) {
            this.customModelDeploymentName = customModelDeploymentName;
            return this;
        }

        public final String getModelArn() {
            return modelArn;
        }

        public final void setModelArn(String modelArn) {
            this.modelArn = modelArn;
        }

        @Override
        public final Builder modelArn(String modelArn) {
            this.modelArn = modelArn;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CustomModelDeploymentStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final String getFailureMessage() {
            return failureMessage;
        }

        public final void setFailureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
        }

        @Override
        public final Builder failureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
            return this;
        }

        @Override
        public CustomModelDeploymentSummary build() {
            return new CustomModelDeploymentSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
