/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class AutomatedReasoningPolicyGeneratedTestCaseListCopier {
    static List<AutomatedReasoningPolicyGeneratedTestCase> copy(
            Collection<? extends AutomatedReasoningPolicyGeneratedTestCase> automatedReasoningPolicyGeneratedTestCaseListParam) {
        List<AutomatedReasoningPolicyGeneratedTestCase> list;
        if (automatedReasoningPolicyGeneratedTestCaseListParam == null
                || automatedReasoningPolicyGeneratedTestCaseListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<AutomatedReasoningPolicyGeneratedTestCase> modifiableList = new ArrayList<>(
                    automatedReasoningPolicyGeneratedTestCaseListParam.size());
            automatedReasoningPolicyGeneratedTestCaseListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<AutomatedReasoningPolicyGeneratedTestCase> copyFromBuilder(
            Collection<? extends AutomatedReasoningPolicyGeneratedTestCase.Builder> automatedReasoningPolicyGeneratedTestCaseListParam) {
        List<AutomatedReasoningPolicyGeneratedTestCase> list;
        if (automatedReasoningPolicyGeneratedTestCaseListParam == null
                || automatedReasoningPolicyGeneratedTestCaseListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<AutomatedReasoningPolicyGeneratedTestCase> modifiableList = new ArrayList<>(
                    automatedReasoningPolicyGeneratedTestCaseListParam.size());
            automatedReasoningPolicyGeneratedTestCaseListParam.forEach(entry -> {
                AutomatedReasoningPolicyGeneratedTestCase member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<AutomatedReasoningPolicyGeneratedTestCase.Builder> copyToBuilder(
            Collection<? extends AutomatedReasoningPolicyGeneratedTestCase> automatedReasoningPolicyGeneratedTestCaseListParam) {
        List<AutomatedReasoningPolicyGeneratedTestCase.Builder> list;
        if (automatedReasoningPolicyGeneratedTestCaseListParam == null
                || automatedReasoningPolicyGeneratedTestCaseListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<AutomatedReasoningPolicyGeneratedTestCase.Builder> modifiableList = new ArrayList<>(
                    automatedReasoningPolicyGeneratedTestCaseListParam.size());
            automatedReasoningPolicyGeneratedTestCaseListParam.forEach(entry -> {
                AutomatedReasoningPolicyGeneratedTestCase.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
