/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a message generated during a build step, providing information about what happened or any issues
 * encountered.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutomatedReasoningPolicyBuildStepMessage implements SdkPojo, Serializable,
        ToCopyableBuilder<AutomatedReasoningPolicyBuildStepMessage.Builder, AutomatedReasoningPolicyBuildStepMessage> {
    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("message")
            .getter(getter(AutomatedReasoningPolicyBuildStepMessage::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()).build();

    private static final SdkField<String> MESSAGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("messageType").getter(getter(AutomatedReasoningPolicyBuildStepMessage::messageTypeAsString))
            .setter(setter(Builder::messageType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messageType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGE_FIELD,
            MESSAGE_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String message;

    private final String messageType;

    private AutomatedReasoningPolicyBuildStepMessage(BuilderImpl builder) {
        this.message = builder.message;
        this.messageType = builder.messageType;
    }

    /**
     * <p>
     * The content of the message, describing what occurred during the build step.
     * </p>
     * 
     * @return The content of the message, describing what occurred during the build step.
     */
    public final String message() {
        return message;
    }

    /**
     * <p>
     * The type of message (e.g., INFO, WARNING, ERROR) indicating its severity and purpose.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #messageType} will
     * return {@link AutomatedReasoningPolicyBuildMessageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #messageTypeAsString}.
     * </p>
     * 
     * @return The type of message (e.g., INFO, WARNING, ERROR) indicating its severity and purpose.
     * @see AutomatedReasoningPolicyBuildMessageType
     */
    public final AutomatedReasoningPolicyBuildMessageType messageType() {
        return AutomatedReasoningPolicyBuildMessageType.fromValue(messageType);
    }

    /**
     * <p>
     * The type of message (e.g., INFO, WARNING, ERROR) indicating its severity and purpose.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #messageType} will
     * return {@link AutomatedReasoningPolicyBuildMessageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #messageTypeAsString}.
     * </p>
     * 
     * @return The type of message (e.g., INFO, WARNING, ERROR) indicating its severity and purpose.
     * @see AutomatedReasoningPolicyBuildMessageType
     */
    public final String messageTypeAsString() {
        return messageType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(messageTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomatedReasoningPolicyBuildStepMessage)) {
            return false;
        }
        AutomatedReasoningPolicyBuildStepMessage other = (AutomatedReasoningPolicyBuildStepMessage) obj;
        return Objects.equals(message(), other.message()) && Objects.equals(messageTypeAsString(), other.messageTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutomatedReasoningPolicyBuildStepMessage").add("Message", message())
                .add("MessageType", messageTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "message":
            return Optional.ofNullable(clazz.cast(message()));
        case "messageType":
            return Optional.ofNullable(clazz.cast(messageTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("message", MESSAGE_FIELD);
        map.put("messageType", MESSAGE_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutomatedReasoningPolicyBuildStepMessage, T> g) {
        return obj -> g.apply((AutomatedReasoningPolicyBuildStepMessage) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutomatedReasoningPolicyBuildStepMessage> {
        /**
         * <p>
         * The content of the message, describing what occurred during the build step.
         * </p>
         * 
         * @param message
         *        The content of the message, describing what occurred during the build step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * The type of message (e.g., INFO, WARNING, ERROR) indicating its severity and purpose.
         * </p>
         * 
         * @param messageType
         *        The type of message (e.g., INFO, WARNING, ERROR) indicating its severity and purpose.
         * @see AutomatedReasoningPolicyBuildMessageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutomatedReasoningPolicyBuildMessageType
         */
        Builder messageType(String messageType);

        /**
         * <p>
         * The type of message (e.g., INFO, WARNING, ERROR) indicating its severity and purpose.
         * </p>
         * 
         * @param messageType
         *        The type of message (e.g., INFO, WARNING, ERROR) indicating its severity and purpose.
         * @see AutomatedReasoningPolicyBuildMessageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutomatedReasoningPolicyBuildMessageType
         */
        Builder messageType(AutomatedReasoningPolicyBuildMessageType messageType);
    }

    static final class BuilderImpl implements Builder {
        private String message;

        private String messageType;

        private BuilderImpl() {
        }

        private BuilderImpl(AutomatedReasoningPolicyBuildStepMessage model) {
            message(model.message);
            messageType(model.messageType);
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final String getMessageType() {
            return messageType;
        }

        public final void setMessageType(String messageType) {
            this.messageType = messageType;
        }

        @Override
        public final Builder messageType(String messageType) {
            this.messageType = messageType;
            return this;
        }

        @Override
        public final Builder messageType(AutomatedReasoningPolicyBuildMessageType messageType) {
            this.messageType(messageType == null ? null : messageType.toString());
            return this;
        }

        @Override
        public AutomatedReasoningPolicyBuildStepMessage build() {
            return new AutomatedReasoningPolicyBuildStepMessage(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
