/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the various assets generated during a policy build workflow, including logs, quality reports, test cases,
 * and the final policy definition.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutomatedReasoningPolicyBuildResultAssets implements SdkPojo, Serializable,
        ToCopyableBuilder<AutomatedReasoningPolicyBuildResultAssets.Builder, AutomatedReasoningPolicyBuildResultAssets> {
    private static final SdkField<AutomatedReasoningPolicyDefinition> POLICY_DEFINITION_FIELD = SdkField
            .<AutomatedReasoningPolicyDefinition> builder(MarshallingType.SDK_POJO).memberName("policyDefinition")
            .getter(getter(AutomatedReasoningPolicyBuildResultAssets::policyDefinition))
            .setter(setter(Builder::policyDefinition)).constructor(AutomatedReasoningPolicyDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyDefinition").build()).build();

    private static final SdkField<AutomatedReasoningPolicyDefinitionQualityReport> QUALITY_REPORT_FIELD = SdkField
            .<AutomatedReasoningPolicyDefinitionQualityReport> builder(MarshallingType.SDK_POJO).memberName("qualityReport")
            .getter(getter(AutomatedReasoningPolicyBuildResultAssets::qualityReport)).setter(setter(Builder::qualityReport))
            .constructor(AutomatedReasoningPolicyDefinitionQualityReport::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("qualityReport").build()).build();

    private static final SdkField<AutomatedReasoningPolicyBuildLog> BUILD_LOG_FIELD = SdkField
            .<AutomatedReasoningPolicyBuildLog> builder(MarshallingType.SDK_POJO).memberName("buildLog")
            .getter(getter(AutomatedReasoningPolicyBuildResultAssets::buildLog)).setter(setter(Builder::buildLog))
            .constructor(AutomatedReasoningPolicyBuildLog::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("buildLog").build()).build();

    private static final SdkField<AutomatedReasoningPolicyGeneratedTestCases> GENERATED_TEST_CASES_FIELD = SdkField
            .<AutomatedReasoningPolicyGeneratedTestCases> builder(MarshallingType.SDK_POJO).memberName("generatedTestCases")
            .getter(getter(AutomatedReasoningPolicyBuildResultAssets::generatedTestCases))
            .setter(setter(Builder::generatedTestCases)).constructor(AutomatedReasoningPolicyGeneratedTestCases::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("generatedTestCases").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_DEFINITION_FIELD,
            QUALITY_REPORT_FIELD, BUILD_LOG_FIELD, GENERATED_TEST_CASES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AutomatedReasoningPolicyDefinition policyDefinition;

    private final AutomatedReasoningPolicyDefinitionQualityReport qualityReport;

    private final AutomatedReasoningPolicyBuildLog buildLog;

    private final AutomatedReasoningPolicyGeneratedTestCases generatedTestCases;

    private final Type type;

    private AutomatedReasoningPolicyBuildResultAssets(BuilderImpl builder) {
        this.policyDefinition = builder.policyDefinition;
        this.qualityReport = builder.qualityReport;
        this.buildLog = builder.buildLog;
        this.generatedTestCases = builder.generatedTestCases;
        this.type = builder.type;
    }

    /**
     * <p>
     * The complete policy definition generated by the build workflow, containing all rules, variables, and custom types
     * extracted from the source documents.
     * </p>
     * 
     * @return The complete policy definition generated by the build workflow, containing all rules, variables, and
     *         custom types extracted from the source documents.
     */
    public final AutomatedReasoningPolicyDefinition policyDefinition() {
        return policyDefinition;
    }

    /**
     * <p>
     * A comprehensive report analyzing the quality of the generated policy, including metrics about rule coverage,
     * potential conflicts, and unused elements.
     * </p>
     * 
     * @return A comprehensive report analyzing the quality of the generated policy, including metrics about rule
     *         coverage, potential conflicts, and unused elements.
     */
    public final AutomatedReasoningPolicyDefinitionQualityReport qualityReport() {
        return qualityReport;
    }

    /**
     * <p>
     * The complete build log containing detailed information about each step in the policy generation process.
     * </p>
     * 
     * @return The complete build log containing detailed information about each step in the policy generation process.
     */
    public final AutomatedReasoningPolicyBuildLog buildLog() {
        return buildLog;
    }

    /**
     * <p>
     * A comprehensive test suite generated by the build workflow, providing validation capabilities for automated
     * reasoning policies.
     * </p>
     * 
     * @return A comprehensive test suite generated by the build workflow, providing validation capabilities for
     *         automated reasoning policies.
     */
    public final AutomatedReasoningPolicyGeneratedTestCases generatedTestCases() {
        return generatedTestCases;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(policyDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(qualityReport());
        hashCode = 31 * hashCode + Objects.hashCode(buildLog());
        hashCode = 31 * hashCode + Objects.hashCode(generatedTestCases());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomatedReasoningPolicyBuildResultAssets)) {
            return false;
        }
        AutomatedReasoningPolicyBuildResultAssets other = (AutomatedReasoningPolicyBuildResultAssets) obj;
        return Objects.equals(policyDefinition(), other.policyDefinition())
                && Objects.equals(qualityReport(), other.qualityReport()) && Objects.equals(buildLog(), other.buildLog())
                && Objects.equals(generatedTestCases(), other.generatedTestCases());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutomatedReasoningPolicyBuildResultAssets").add("PolicyDefinition", policyDefinition())
                .add("QualityReport", qualityReport()).add("BuildLog", buildLog())
                .add("GeneratedTestCases", generatedTestCases()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "policyDefinition":
            return Optional.ofNullable(clazz.cast(policyDefinition()));
        case "qualityReport":
            return Optional.ofNullable(clazz.cast(qualityReport()));
        case "buildLog":
            return Optional.ofNullable(clazz.cast(buildLog()));
        case "generatedTestCases":
            return Optional.ofNullable(clazz.cast(generatedTestCases()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #policyDefinition()} initialized to the given value.
     *
     * <p>
     * The complete policy definition generated by the build workflow, containing all rules, variables, and custom types
     * extracted from the source documents.
     * </p>
     * 
     * @param policyDefinition
     *        The complete policy definition generated by the build workflow, containing all rules, variables, and
     *        custom types extracted from the source documents.
     */
    public static AutomatedReasoningPolicyBuildResultAssets fromPolicyDefinition(
            AutomatedReasoningPolicyDefinition policyDefinition) {
        return builder().policyDefinition(policyDefinition).build();
    }

    /**
     * Create an instance of this class with {@link #policyDefinition()} initialized to the given value.
     *
     * <p>
     * The complete policy definition generated by the build workflow, containing all rules, variables, and custom types
     * extracted from the source documents.
     * </p>
     * 
     * @param policyDefinition
     *        The complete policy definition generated by the build workflow, containing all rules, variables, and
     *        custom types extracted from the source documents.
     */
    public static AutomatedReasoningPolicyBuildResultAssets fromPolicyDefinition(
            Consumer<AutomatedReasoningPolicyDefinition.Builder> policyDefinition) {
        AutomatedReasoningPolicyDefinition.Builder builder = AutomatedReasoningPolicyDefinition.builder();
        policyDefinition.accept(builder);
        return fromPolicyDefinition(builder.build());
    }

    /**
     * Create an instance of this class with {@link #qualityReport()} initialized to the given value.
     *
     * <p>
     * A comprehensive report analyzing the quality of the generated policy, including metrics about rule coverage,
     * potential conflicts, and unused elements.
     * </p>
     * 
     * @param qualityReport
     *        A comprehensive report analyzing the quality of the generated policy, including metrics about rule
     *        coverage, potential conflicts, and unused elements.
     */
    public static AutomatedReasoningPolicyBuildResultAssets fromQualityReport(
            AutomatedReasoningPolicyDefinitionQualityReport qualityReport) {
        return builder().qualityReport(qualityReport).build();
    }

    /**
     * Create an instance of this class with {@link #qualityReport()} initialized to the given value.
     *
     * <p>
     * A comprehensive report analyzing the quality of the generated policy, including metrics about rule coverage,
     * potential conflicts, and unused elements.
     * </p>
     * 
     * @param qualityReport
     *        A comprehensive report analyzing the quality of the generated policy, including metrics about rule
     *        coverage, potential conflicts, and unused elements.
     */
    public static AutomatedReasoningPolicyBuildResultAssets fromQualityReport(
            Consumer<AutomatedReasoningPolicyDefinitionQualityReport.Builder> qualityReport) {
        AutomatedReasoningPolicyDefinitionQualityReport.Builder builder = AutomatedReasoningPolicyDefinitionQualityReport
                .builder();
        qualityReport.accept(builder);
        return fromQualityReport(builder.build());
    }

    /**
     * Create an instance of this class with {@link #buildLog()} initialized to the given value.
     *
     * <p>
     * The complete build log containing detailed information about each step in the policy generation process.
     * </p>
     * 
     * @param buildLog
     *        The complete build log containing detailed information about each step in the policy generation process.
     */
    public static AutomatedReasoningPolicyBuildResultAssets fromBuildLog(AutomatedReasoningPolicyBuildLog buildLog) {
        return builder().buildLog(buildLog).build();
    }

    /**
     * Create an instance of this class with {@link #buildLog()} initialized to the given value.
     *
     * <p>
     * The complete build log containing detailed information about each step in the policy generation process.
     * </p>
     * 
     * @param buildLog
     *        The complete build log containing detailed information about each step in the policy generation process.
     */
    public static AutomatedReasoningPolicyBuildResultAssets fromBuildLog(
            Consumer<AutomatedReasoningPolicyBuildLog.Builder> buildLog) {
        AutomatedReasoningPolicyBuildLog.Builder builder = AutomatedReasoningPolicyBuildLog.builder();
        buildLog.accept(builder);
        return fromBuildLog(builder.build());
    }

    /**
     * Create an instance of this class with {@link #generatedTestCases()} initialized to the given value.
     *
     * <p>
     * A comprehensive test suite generated by the build workflow, providing validation capabilities for automated
     * reasoning policies.
     * </p>
     * 
     * @param generatedTestCases
     *        A comprehensive test suite generated by the build workflow, providing validation capabilities for
     *        automated reasoning policies.
     */
    public static AutomatedReasoningPolicyBuildResultAssets fromGeneratedTestCases(
            AutomatedReasoningPolicyGeneratedTestCases generatedTestCases) {
        return builder().generatedTestCases(generatedTestCases).build();
    }

    /**
     * Create an instance of this class with {@link #generatedTestCases()} initialized to the given value.
     *
     * <p>
     * A comprehensive test suite generated by the build workflow, providing validation capabilities for automated
     * reasoning policies.
     * </p>
     * 
     * @param generatedTestCases
     *        A comprehensive test suite generated by the build workflow, providing validation capabilities for
     *        automated reasoning policies.
     */
    public static AutomatedReasoningPolicyBuildResultAssets fromGeneratedTestCases(
            Consumer<AutomatedReasoningPolicyGeneratedTestCases.Builder> generatedTestCases) {
        AutomatedReasoningPolicyGeneratedTestCases.Builder builder = AutomatedReasoningPolicyGeneratedTestCases.builder();
        generatedTestCases.accept(builder);
        return fromGeneratedTestCases(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("policyDefinition", POLICY_DEFINITION_FIELD);
        map.put("qualityReport", QUALITY_REPORT_FIELD);
        map.put("buildLog", BUILD_LOG_FIELD);
        map.put("generatedTestCases", GENERATED_TEST_CASES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutomatedReasoningPolicyBuildResultAssets, T> g) {
        return obj -> g.apply((AutomatedReasoningPolicyBuildResultAssets) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutomatedReasoningPolicyBuildResultAssets> {
        /**
         * <p>
         * The complete policy definition generated by the build workflow, containing all rules, variables, and custom
         * types extracted from the source documents.
         * </p>
         * 
         * @param policyDefinition
         *        The complete policy definition generated by the build workflow, containing all rules, variables, and
         *        custom types extracted from the source documents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyDefinition(AutomatedReasoningPolicyDefinition policyDefinition);

        /**
         * <p>
         * The complete policy definition generated by the build workflow, containing all rules, variables, and custom
         * types extracted from the source documents.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AutomatedReasoningPolicyDefinition.Builder} avoiding the need to create one manually via
         * {@link AutomatedReasoningPolicyDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutomatedReasoningPolicyDefinition.Builder#build()} is called
         * immediately and its result is passed to {@link #policyDefinition(AutomatedReasoningPolicyDefinition)}.
         * 
         * @param policyDefinition
         *        a consumer that will call methods on {@link AutomatedReasoningPolicyDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #policyDefinition(AutomatedReasoningPolicyDefinition)
         */
        default Builder policyDefinition(Consumer<AutomatedReasoningPolicyDefinition.Builder> policyDefinition) {
            return policyDefinition(AutomatedReasoningPolicyDefinition.builder().applyMutation(policyDefinition).build());
        }

        /**
         * <p>
         * A comprehensive report analyzing the quality of the generated policy, including metrics about rule coverage,
         * potential conflicts, and unused elements.
         * </p>
         * 
         * @param qualityReport
         *        A comprehensive report analyzing the quality of the generated policy, including metrics about rule
         *        coverage, potential conflicts, and unused elements.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder qualityReport(AutomatedReasoningPolicyDefinitionQualityReport qualityReport);

        /**
         * <p>
         * A comprehensive report analyzing the quality of the generated policy, including metrics about rule coverage,
         * potential conflicts, and unused elements.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AutomatedReasoningPolicyDefinitionQualityReport.Builder} avoiding the need to create one manually via
         * {@link AutomatedReasoningPolicyDefinitionQualityReport#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutomatedReasoningPolicyDefinitionQualityReport.Builder#build()}
         * is called immediately and its result is passed to
         * {@link #qualityReport(AutomatedReasoningPolicyDefinitionQualityReport)}.
         * 
         * @param qualityReport
         *        a consumer that will call methods on {@link AutomatedReasoningPolicyDefinitionQualityReport.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #qualityReport(AutomatedReasoningPolicyDefinitionQualityReport)
         */
        default Builder qualityReport(Consumer<AutomatedReasoningPolicyDefinitionQualityReport.Builder> qualityReport) {
            return qualityReport(AutomatedReasoningPolicyDefinitionQualityReport.builder().applyMutation(qualityReport).build());
        }

        /**
         * <p>
         * The complete build log containing detailed information about each step in the policy generation process.
         * </p>
         * 
         * @param buildLog
         *        The complete build log containing detailed information about each step in the policy generation
         *        process.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder buildLog(AutomatedReasoningPolicyBuildLog buildLog);

        /**
         * <p>
         * The complete build log containing detailed information about each step in the policy generation process.
         * </p>
         * This is a convenience method that creates an instance of the {@link AutomatedReasoningPolicyBuildLog.Builder}
         * avoiding the need to create one manually via {@link AutomatedReasoningPolicyBuildLog#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutomatedReasoningPolicyBuildLog.Builder#build()} is called
         * immediately and its result is passed to {@link #buildLog(AutomatedReasoningPolicyBuildLog)}.
         * 
         * @param buildLog
         *        a consumer that will call methods on {@link AutomatedReasoningPolicyBuildLog.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #buildLog(AutomatedReasoningPolicyBuildLog)
         */
        default Builder buildLog(Consumer<AutomatedReasoningPolicyBuildLog.Builder> buildLog) {
            return buildLog(AutomatedReasoningPolicyBuildLog.builder().applyMutation(buildLog).build());
        }

        /**
         * <p>
         * A comprehensive test suite generated by the build workflow, providing validation capabilities for automated
         * reasoning policies.
         * </p>
         * 
         * @param generatedTestCases
         *        A comprehensive test suite generated by the build workflow, providing validation capabilities for
         *        automated reasoning policies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder generatedTestCases(AutomatedReasoningPolicyGeneratedTestCases generatedTestCases);

        /**
         * <p>
         * A comprehensive test suite generated by the build workflow, providing validation capabilities for automated
         * reasoning policies.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AutomatedReasoningPolicyGeneratedTestCases.Builder} avoiding the need to create one manually via
         * {@link AutomatedReasoningPolicyGeneratedTestCases#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutomatedReasoningPolicyGeneratedTestCases.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #generatedTestCases(AutomatedReasoningPolicyGeneratedTestCases)}.
         * 
         * @param generatedTestCases
         *        a consumer that will call methods on {@link AutomatedReasoningPolicyGeneratedTestCases.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #generatedTestCases(AutomatedReasoningPolicyGeneratedTestCases)
         */
        default Builder generatedTestCases(Consumer<AutomatedReasoningPolicyGeneratedTestCases.Builder> generatedTestCases) {
            return generatedTestCases(AutomatedReasoningPolicyGeneratedTestCases.builder().applyMutation(generatedTestCases)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AutomatedReasoningPolicyDefinition policyDefinition;

        private AutomatedReasoningPolicyDefinitionQualityReport qualityReport;

        private AutomatedReasoningPolicyBuildLog buildLog;

        private AutomatedReasoningPolicyGeneratedTestCases generatedTestCases;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(AutomatedReasoningPolicyBuildResultAssets model) {
            policyDefinition(model.policyDefinition);
            qualityReport(model.qualityReport);
            buildLog(model.buildLog);
            generatedTestCases(model.generatedTestCases);
        }

        public final AutomatedReasoningPolicyDefinition.Builder getPolicyDefinition() {
            return policyDefinition != null ? policyDefinition.toBuilder() : null;
        }

        public final void setPolicyDefinition(AutomatedReasoningPolicyDefinition.BuilderImpl policyDefinition) {
            Object oldValue = this.policyDefinition;
            this.policyDefinition = policyDefinition != null ? policyDefinition.build() : null;
            handleUnionValueChange(Type.POLICY_DEFINITION, oldValue, this.policyDefinition);
        }

        @Override
        public final Builder policyDefinition(AutomatedReasoningPolicyDefinition policyDefinition) {
            Object oldValue = this.policyDefinition;
            this.policyDefinition = policyDefinition;
            handleUnionValueChange(Type.POLICY_DEFINITION, oldValue, this.policyDefinition);
            return this;
        }

        public final AutomatedReasoningPolicyDefinitionQualityReport.Builder getQualityReport() {
            return qualityReport != null ? qualityReport.toBuilder() : null;
        }

        public final void setQualityReport(AutomatedReasoningPolicyDefinitionQualityReport.BuilderImpl qualityReport) {
            Object oldValue = this.qualityReport;
            this.qualityReport = qualityReport != null ? qualityReport.build() : null;
            handleUnionValueChange(Type.QUALITY_REPORT, oldValue, this.qualityReport);
        }

        @Override
        public final Builder qualityReport(AutomatedReasoningPolicyDefinitionQualityReport qualityReport) {
            Object oldValue = this.qualityReport;
            this.qualityReport = qualityReport;
            handleUnionValueChange(Type.QUALITY_REPORT, oldValue, this.qualityReport);
            return this;
        }

        public final AutomatedReasoningPolicyBuildLog.Builder getBuildLog() {
            return buildLog != null ? buildLog.toBuilder() : null;
        }

        public final void setBuildLog(AutomatedReasoningPolicyBuildLog.BuilderImpl buildLog) {
            Object oldValue = this.buildLog;
            this.buildLog = buildLog != null ? buildLog.build() : null;
            handleUnionValueChange(Type.BUILD_LOG, oldValue, this.buildLog);
        }

        @Override
        public final Builder buildLog(AutomatedReasoningPolicyBuildLog buildLog) {
            Object oldValue = this.buildLog;
            this.buildLog = buildLog;
            handleUnionValueChange(Type.BUILD_LOG, oldValue, this.buildLog);
            return this;
        }

        public final AutomatedReasoningPolicyGeneratedTestCases.Builder getGeneratedTestCases() {
            return generatedTestCases != null ? generatedTestCases.toBuilder() : null;
        }

        public final void setGeneratedTestCases(AutomatedReasoningPolicyGeneratedTestCases.BuilderImpl generatedTestCases) {
            Object oldValue = this.generatedTestCases;
            this.generatedTestCases = generatedTestCases != null ? generatedTestCases.build() : null;
            handleUnionValueChange(Type.GENERATED_TEST_CASES, oldValue, this.generatedTestCases);
        }

        @Override
        public final Builder generatedTestCases(AutomatedReasoningPolicyGeneratedTestCases generatedTestCases) {
            Object oldValue = this.generatedTestCases;
            this.generatedTestCases = generatedTestCases;
            handleUnionValueChange(Type.GENERATED_TEST_CASES, oldValue, this.generatedTestCases);
            return this;
        }

        @Override
        public AutomatedReasoningPolicyBuildResultAssets build() {
            return new AutomatedReasoningPolicyBuildResultAssets(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see AutomatedReasoningPolicyBuildResultAssets#type()
     */
    public enum Type {
        POLICY_DEFINITION,

        QUALITY_REPORT,

        BUILD_LOG,

        GENERATED_TEST_CASES,

        UNKNOWN_TO_SDK_VERSION
    }
}
