/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains detailed logging information about the policy build process, including steps taken, decisions made, and any
 * issues encountered.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutomatedReasoningPolicyBuildLog implements SdkPojo, Serializable,
        ToCopyableBuilder<AutomatedReasoningPolicyBuildLog.Builder, AutomatedReasoningPolicyBuildLog> {
    private static final SdkField<List<AutomatedReasoningPolicyBuildLogEntry>> ENTRIES_FIELD = SdkField
            .<List<AutomatedReasoningPolicyBuildLogEntry>> builder(MarshallingType.LIST)
            .memberName("entries")
            .getter(getter(AutomatedReasoningPolicyBuildLog::entries))
            .setter(setter(Builder::entries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AutomatedReasoningPolicyBuildLogEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(AutomatedReasoningPolicyBuildLogEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTRIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<AutomatedReasoningPolicyBuildLogEntry> entries;

    private AutomatedReasoningPolicyBuildLog(BuilderImpl builder) {
        this.entries = builder.entries;
    }

    /**
     * For responses, this returns true if the service returned a value for the Entries property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasEntries() {
        return entries != null && !(entries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of log entries documenting each step in the policy build process, including timestamps, status, and
     * detailed messages.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEntries} method.
     * </p>
     * 
     * @return A list of log entries documenting each step in the policy build process, including timestamps, status,
     *         and detailed messages.
     */
    public final List<AutomatedReasoningPolicyBuildLogEntry> entries() {
        return entries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasEntries() ? entries() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomatedReasoningPolicyBuildLog)) {
            return false;
        }
        AutomatedReasoningPolicyBuildLog other = (AutomatedReasoningPolicyBuildLog) obj;
        return hasEntries() == other.hasEntries() && Objects.equals(entries(), other.entries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutomatedReasoningPolicyBuildLog").add("Entries", hasEntries() ? entries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "entries":
            return Optional.ofNullable(clazz.cast(entries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("entries", ENTRIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutomatedReasoningPolicyBuildLog, T> g) {
        return obj -> g.apply((AutomatedReasoningPolicyBuildLog) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutomatedReasoningPolicyBuildLog> {
        /**
         * <p>
         * A list of log entries documenting each step in the policy build process, including timestamps, status, and
         * detailed messages.
         * </p>
         * 
         * @param entries
         *        A list of log entries documenting each step in the policy build process, including timestamps, status,
         *        and detailed messages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entries(Collection<AutomatedReasoningPolicyBuildLogEntry> entries);

        /**
         * <p>
         * A list of log entries documenting each step in the policy build process, including timestamps, status, and
         * detailed messages.
         * </p>
         * 
         * @param entries
         *        A list of log entries documenting each step in the policy build process, including timestamps, status,
         *        and detailed messages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entries(AutomatedReasoningPolicyBuildLogEntry... entries);

        /**
         * <p>
         * A list of log entries documenting each step in the policy build process, including timestamps, status, and
         * detailed messages.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyBuildLogEntry.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyBuildLogEntry#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyBuildLogEntry.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #entries(List<AutomatedReasoningPolicyBuildLogEntry>)}.
         * 
         * @param entries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyBuildLogEntry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #entries(java.util.Collection<AutomatedReasoningPolicyBuildLogEntry>)
         */
        Builder entries(Consumer<AutomatedReasoningPolicyBuildLogEntry.Builder>... entries);
    }

    static final class BuilderImpl implements Builder {
        private List<AutomatedReasoningPolicyBuildLogEntry> entries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AutomatedReasoningPolicyBuildLog model) {
            entries(model.entries);
        }

        public final List<AutomatedReasoningPolicyBuildLogEntry.Builder> getEntries() {
            List<AutomatedReasoningPolicyBuildLogEntry.Builder> result = AutomatedReasoningPolicyBuildLogEntryListCopier
                    .copyToBuilder(this.entries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEntries(Collection<AutomatedReasoningPolicyBuildLogEntry.BuilderImpl> entries) {
            this.entries = AutomatedReasoningPolicyBuildLogEntryListCopier.copyFromBuilder(entries);
        }

        @Override
        public final Builder entries(Collection<AutomatedReasoningPolicyBuildLogEntry> entries) {
            this.entries = AutomatedReasoningPolicyBuildLogEntryListCopier.copy(entries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entries(AutomatedReasoningPolicyBuildLogEntry... entries) {
            entries(Arrays.asList(entries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entries(Consumer<AutomatedReasoningPolicyBuildLogEntry.Builder>... entries) {
            entries(Stream.of(entries).map(c -> AutomatedReasoningPolicyBuildLogEntry.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public AutomatedReasoningPolicyBuildLog build() {
            return new AutomatedReasoningPolicyBuildLog(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
