/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Indicates that the claims are definitively true and logically implied by the premises, with no possible alternative
 * interpretations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutomatedReasoningCheckValidFinding implements SdkPojo, Serializable,
        ToCopyableBuilder<AutomatedReasoningCheckValidFinding.Builder, AutomatedReasoningCheckValidFinding> {
    private static final SdkField<AutomatedReasoningCheckTranslation> TRANSLATION_FIELD = SdkField
            .<AutomatedReasoningCheckTranslation> builder(MarshallingType.SDK_POJO).memberName("translation")
            .getter(getter(AutomatedReasoningCheckValidFinding::translation)).setter(setter(Builder::translation))
            .constructor(AutomatedReasoningCheckTranslation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("translation").build()).build();

    private static final SdkField<AutomatedReasoningCheckScenario> CLAIMS_TRUE_SCENARIO_FIELD = SdkField
            .<AutomatedReasoningCheckScenario> builder(MarshallingType.SDK_POJO).memberName("claimsTrueScenario")
            .getter(getter(AutomatedReasoningCheckValidFinding::claimsTrueScenario)).setter(setter(Builder::claimsTrueScenario))
            .constructor(AutomatedReasoningCheckScenario::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("claimsTrueScenario").build())
            .build();

    private static final SdkField<List<AutomatedReasoningCheckRule>> SUPPORTING_RULES_FIELD = SdkField
            .<List<AutomatedReasoningCheckRule>> builder(MarshallingType.LIST)
            .memberName("supportingRules")
            .getter(getter(AutomatedReasoningCheckValidFinding::supportingRules))
            .setter(setter(Builder::supportingRules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("supportingRules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AutomatedReasoningCheckRule> builder(MarshallingType.SDK_POJO)
                                            .constructor(AutomatedReasoningCheckRule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<AutomatedReasoningCheckLogicWarning> LOGIC_WARNING_FIELD = SdkField
            .<AutomatedReasoningCheckLogicWarning> builder(MarshallingType.SDK_POJO).memberName("logicWarning")
            .getter(getter(AutomatedReasoningCheckValidFinding::logicWarning)).setter(setter(Builder::logicWarning))
            .constructor(AutomatedReasoningCheckLogicWarning::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logicWarning").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSLATION_FIELD,
            CLAIMS_TRUE_SCENARIO_FIELD, SUPPORTING_RULES_FIELD, LOGIC_WARNING_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AutomatedReasoningCheckTranslation translation;

    private final AutomatedReasoningCheckScenario claimsTrueScenario;

    private final List<AutomatedReasoningCheckRule> supportingRules;

    private final AutomatedReasoningCheckLogicWarning logicWarning;

    private AutomatedReasoningCheckValidFinding(BuilderImpl builder) {
        this.translation = builder.translation;
        this.claimsTrueScenario = builder.claimsTrueScenario;
        this.supportingRules = builder.supportingRules;
        this.logicWarning = builder.logicWarning;
    }

    /**
     * <p>
     * The logical translation of the input that this finding validates.
     * </p>
     * 
     * @return The logical translation of the input that this finding validates.
     */
    public final AutomatedReasoningCheckTranslation translation() {
        return translation;
    }

    /**
     * <p>
     * An example scenario demonstrating how the claims are logically true.
     * </p>
     * 
     * @return An example scenario demonstrating how the claims are logically true.
     */
    public final AutomatedReasoningCheckScenario claimsTrueScenario() {
        return claimsTrueScenario;
    }

    /**
     * For responses, this returns true if the service returned a value for the SupportingRules property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSupportingRules() {
        return supportingRules != null && !(supportingRules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The automated reasoning policy rules that support why this result is considered valid.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSupportingRules} method.
     * </p>
     * 
     * @return The automated reasoning policy rules that support why this result is considered valid.
     */
    public final List<AutomatedReasoningCheckRule> supportingRules() {
        return supportingRules;
    }

    /**
     * <p>
     * Indication of a logic issue with the translation without needing to consider the automated reasoning policy
     * rules.
     * </p>
     * 
     * @return Indication of a logic issue with the translation without needing to consider the automated reasoning
     *         policy rules.
     */
    public final AutomatedReasoningCheckLogicWarning logicWarning() {
        return logicWarning;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(translation());
        hashCode = 31 * hashCode + Objects.hashCode(claimsTrueScenario());
        hashCode = 31 * hashCode + Objects.hashCode(hasSupportingRules() ? supportingRules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(logicWarning());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomatedReasoningCheckValidFinding)) {
            return false;
        }
        AutomatedReasoningCheckValidFinding other = (AutomatedReasoningCheckValidFinding) obj;
        return Objects.equals(translation(), other.translation())
                && Objects.equals(claimsTrueScenario(), other.claimsTrueScenario())
                && hasSupportingRules() == other.hasSupportingRules()
                && Objects.equals(supportingRules(), other.supportingRules())
                && Objects.equals(logicWarning(), other.logicWarning());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutomatedReasoningCheckValidFinding").add("Translation", translation())
                .add("ClaimsTrueScenario", claimsTrueScenario())
                .add("SupportingRules", hasSupportingRules() ? supportingRules() : null).add("LogicWarning", logicWarning())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "translation":
            return Optional.ofNullable(clazz.cast(translation()));
        case "claimsTrueScenario":
            return Optional.ofNullable(clazz.cast(claimsTrueScenario()));
        case "supportingRules":
            return Optional.ofNullable(clazz.cast(supportingRules()));
        case "logicWarning":
            return Optional.ofNullable(clazz.cast(logicWarning()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("translation", TRANSLATION_FIELD);
        map.put("claimsTrueScenario", CLAIMS_TRUE_SCENARIO_FIELD);
        map.put("supportingRules", SUPPORTING_RULES_FIELD);
        map.put("logicWarning", LOGIC_WARNING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutomatedReasoningCheckValidFinding, T> g) {
        return obj -> g.apply((AutomatedReasoningCheckValidFinding) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutomatedReasoningCheckValidFinding> {
        /**
         * <p>
         * The logical translation of the input that this finding validates.
         * </p>
         * 
         * @param translation
         *        The logical translation of the input that this finding validates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder translation(AutomatedReasoningCheckTranslation translation);

        /**
         * <p>
         * The logical translation of the input that this finding validates.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AutomatedReasoningCheckTranslation.Builder} avoiding the need to create one manually via
         * {@link AutomatedReasoningCheckTranslation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutomatedReasoningCheckTranslation.Builder#build()} is called
         * immediately and its result is passed to {@link #translation(AutomatedReasoningCheckTranslation)}.
         * 
         * @param translation
         *        a consumer that will call methods on {@link AutomatedReasoningCheckTranslation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #translation(AutomatedReasoningCheckTranslation)
         */
        default Builder translation(Consumer<AutomatedReasoningCheckTranslation.Builder> translation) {
            return translation(AutomatedReasoningCheckTranslation.builder().applyMutation(translation).build());
        }

        /**
         * <p>
         * An example scenario demonstrating how the claims are logically true.
         * </p>
         * 
         * @param claimsTrueScenario
         *        An example scenario demonstrating how the claims are logically true.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder claimsTrueScenario(AutomatedReasoningCheckScenario claimsTrueScenario);

        /**
         * <p>
         * An example scenario demonstrating how the claims are logically true.
         * </p>
         * This is a convenience method that creates an instance of the {@link AutomatedReasoningCheckScenario.Builder}
         * avoiding the need to create one manually via {@link AutomatedReasoningCheckScenario#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutomatedReasoningCheckScenario.Builder#build()} is called
         * immediately and its result is passed to {@link #claimsTrueScenario(AutomatedReasoningCheckScenario)}.
         * 
         * @param claimsTrueScenario
         *        a consumer that will call methods on {@link AutomatedReasoningCheckScenario.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #claimsTrueScenario(AutomatedReasoningCheckScenario)
         */
        default Builder claimsTrueScenario(Consumer<AutomatedReasoningCheckScenario.Builder> claimsTrueScenario) {
            return claimsTrueScenario(AutomatedReasoningCheckScenario.builder().applyMutation(claimsTrueScenario).build());
        }

        /**
         * <p>
         * The automated reasoning policy rules that support why this result is considered valid.
         * </p>
         * 
         * @param supportingRules
         *        The automated reasoning policy rules that support why this result is considered valid.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportingRules(Collection<AutomatedReasoningCheckRule> supportingRules);

        /**
         * <p>
         * The automated reasoning policy rules that support why this result is considered valid.
         * </p>
         * 
         * @param supportingRules
         *        The automated reasoning policy rules that support why this result is considered valid.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportingRules(AutomatedReasoningCheckRule... supportingRules);

        /**
         * <p>
         * The automated reasoning policy rules that support why this result is considered valid.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrock.model.AutomatedReasoningCheckRule.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.bedrock.model.AutomatedReasoningCheckRule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrock.model.AutomatedReasoningCheckRule.Builder#build()} is called
         * immediately and its result is passed to {@link #supportingRules(List<AutomatedReasoningCheckRule>)}.
         * 
         * @param supportingRules
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrock.model.AutomatedReasoningCheckRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #supportingRules(java.util.Collection<AutomatedReasoningCheckRule>)
         */
        Builder supportingRules(Consumer<AutomatedReasoningCheckRule.Builder>... supportingRules);

        /**
         * <p>
         * Indication of a logic issue with the translation without needing to consider the automated reasoning policy
         * rules.
         * </p>
         * 
         * @param logicWarning
         *        Indication of a logic issue with the translation without needing to consider the automated reasoning
         *        policy rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logicWarning(AutomatedReasoningCheckLogicWarning logicWarning);

        /**
         * <p>
         * Indication of a logic issue with the translation without needing to consider the automated reasoning policy
         * rules.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AutomatedReasoningCheckLogicWarning.Builder} avoiding the need to create one manually via
         * {@link AutomatedReasoningCheckLogicWarning#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutomatedReasoningCheckLogicWarning.Builder#build()} is called
         * immediately and its result is passed to {@link #logicWarning(AutomatedReasoningCheckLogicWarning)}.
         * 
         * @param logicWarning
         *        a consumer that will call methods on {@link AutomatedReasoningCheckLogicWarning.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logicWarning(AutomatedReasoningCheckLogicWarning)
         */
        default Builder logicWarning(Consumer<AutomatedReasoningCheckLogicWarning.Builder> logicWarning) {
            return logicWarning(AutomatedReasoningCheckLogicWarning.builder().applyMutation(logicWarning).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AutomatedReasoningCheckTranslation translation;

        private AutomatedReasoningCheckScenario claimsTrueScenario;

        private List<AutomatedReasoningCheckRule> supportingRules = DefaultSdkAutoConstructList.getInstance();

        private AutomatedReasoningCheckLogicWarning logicWarning;

        private BuilderImpl() {
        }

        private BuilderImpl(AutomatedReasoningCheckValidFinding model) {
            translation(model.translation);
            claimsTrueScenario(model.claimsTrueScenario);
            supportingRules(model.supportingRules);
            logicWarning(model.logicWarning);
        }

        public final AutomatedReasoningCheckTranslation.Builder getTranslation() {
            return translation != null ? translation.toBuilder() : null;
        }

        public final void setTranslation(AutomatedReasoningCheckTranslation.BuilderImpl translation) {
            this.translation = translation != null ? translation.build() : null;
        }

        @Override
        public final Builder translation(AutomatedReasoningCheckTranslation translation) {
            this.translation = translation;
            return this;
        }

        public final AutomatedReasoningCheckScenario.Builder getClaimsTrueScenario() {
            return claimsTrueScenario != null ? claimsTrueScenario.toBuilder() : null;
        }

        public final void setClaimsTrueScenario(AutomatedReasoningCheckScenario.BuilderImpl claimsTrueScenario) {
            this.claimsTrueScenario = claimsTrueScenario != null ? claimsTrueScenario.build() : null;
        }

        @Override
        public final Builder claimsTrueScenario(AutomatedReasoningCheckScenario claimsTrueScenario) {
            this.claimsTrueScenario = claimsTrueScenario;
            return this;
        }

        public final List<AutomatedReasoningCheckRule.Builder> getSupportingRules() {
            List<AutomatedReasoningCheckRule.Builder> result = AutomatedReasoningCheckRuleListCopier
                    .copyToBuilder(this.supportingRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSupportingRules(Collection<AutomatedReasoningCheckRule.BuilderImpl> supportingRules) {
            this.supportingRules = AutomatedReasoningCheckRuleListCopier.copyFromBuilder(supportingRules);
        }

        @Override
        public final Builder supportingRules(Collection<AutomatedReasoningCheckRule> supportingRules) {
            this.supportingRules = AutomatedReasoningCheckRuleListCopier.copy(supportingRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportingRules(AutomatedReasoningCheckRule... supportingRules) {
            supportingRules(Arrays.asList(supportingRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportingRules(Consumer<AutomatedReasoningCheckRule.Builder>... supportingRules) {
            supportingRules(Stream.of(supportingRules).map(c -> AutomatedReasoningCheckRule.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final AutomatedReasoningCheckLogicWarning.Builder getLogicWarning() {
            return logicWarning != null ? logicWarning.toBuilder() : null;
        }

        public final void setLogicWarning(AutomatedReasoningCheckLogicWarning.BuilderImpl logicWarning) {
            this.logicWarning = logicWarning != null ? logicWarning.build() : null;
        }

        @Override
        public final Builder logicWarning(AutomatedReasoningCheckLogicWarning logicWarning) {
            this.logicWarning = logicWarning;
            return this;
        }

        @Override
        public AutomatedReasoningCheckValidFinding build() {
            return new AutomatedReasoningCheckValidFinding(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
