/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the result of an Automated Reasoning validation check, indicating whether the content is logically valid,
 * invalid, or falls into other categories based on the policy rules.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutomatedReasoningCheckFinding implements SdkPojo, Serializable,
        ToCopyableBuilder<AutomatedReasoningCheckFinding.Builder, AutomatedReasoningCheckFinding> {
    private static final SdkField<AutomatedReasoningCheckValidFinding> VALID_FIELD = SdkField
            .<AutomatedReasoningCheckValidFinding> builder(MarshallingType.SDK_POJO).memberName("valid")
            .getter(getter(AutomatedReasoningCheckFinding::valid)).setter(setter(Builder::valid))
            .constructor(AutomatedReasoningCheckValidFinding::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("valid").build()).build();

    private static final SdkField<AutomatedReasoningCheckInvalidFinding> INVALID_FIELD = SdkField
            .<AutomatedReasoningCheckInvalidFinding> builder(MarshallingType.SDK_POJO).memberName("invalid")
            .getter(getter(AutomatedReasoningCheckFinding::invalid)).setter(setter(Builder::invalid))
            .constructor(AutomatedReasoningCheckInvalidFinding::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("invalid").build()).build();

    private static final SdkField<AutomatedReasoningCheckSatisfiableFinding> SATISFIABLE_FIELD = SdkField
            .<AutomatedReasoningCheckSatisfiableFinding> builder(MarshallingType.SDK_POJO).memberName("satisfiable")
            .getter(getter(AutomatedReasoningCheckFinding::satisfiable)).setter(setter(Builder::satisfiable))
            .constructor(AutomatedReasoningCheckSatisfiableFinding::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("satisfiable").build()).build();

    private static final SdkField<AutomatedReasoningCheckImpossibleFinding> IMPOSSIBLE_FIELD = SdkField
            .<AutomatedReasoningCheckImpossibleFinding> builder(MarshallingType.SDK_POJO).memberName("impossible")
            .getter(getter(AutomatedReasoningCheckFinding::impossible)).setter(setter(Builder::impossible))
            .constructor(AutomatedReasoningCheckImpossibleFinding::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("impossible").build()).build();

    private static final SdkField<AutomatedReasoningCheckTranslationAmbiguousFinding> TRANSLATION_AMBIGUOUS_FIELD = SdkField
            .<AutomatedReasoningCheckTranslationAmbiguousFinding> builder(MarshallingType.SDK_POJO)
            .memberName("translationAmbiguous").getter(getter(AutomatedReasoningCheckFinding::translationAmbiguous))
            .setter(setter(Builder::translationAmbiguous))
            .constructor(AutomatedReasoningCheckTranslationAmbiguousFinding::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("translationAmbiguous").build())
            .build();

    private static final SdkField<AutomatedReasoningCheckTooComplexFinding> TOO_COMPLEX_FIELD = SdkField
            .<AutomatedReasoningCheckTooComplexFinding> builder(MarshallingType.SDK_POJO).memberName("tooComplex")
            .getter(getter(AutomatedReasoningCheckFinding::tooComplex)).setter(setter(Builder::tooComplex))
            .constructor(AutomatedReasoningCheckTooComplexFinding::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tooComplex").build()).build();

    private static final SdkField<AutomatedReasoningCheckNoTranslationsFinding> NO_TRANSLATIONS_FIELD = SdkField
            .<AutomatedReasoningCheckNoTranslationsFinding> builder(MarshallingType.SDK_POJO).memberName("noTranslations")
            .getter(getter(AutomatedReasoningCheckFinding::noTranslations)).setter(setter(Builder::noTranslations))
            .constructor(AutomatedReasoningCheckNoTranslationsFinding::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("noTranslations").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALID_FIELD, INVALID_FIELD,
            SATISFIABLE_FIELD, IMPOSSIBLE_FIELD, TRANSLATION_AMBIGUOUS_FIELD, TOO_COMPLEX_FIELD, NO_TRANSLATIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AutomatedReasoningCheckValidFinding valid;

    private final AutomatedReasoningCheckInvalidFinding invalid;

    private final AutomatedReasoningCheckSatisfiableFinding satisfiable;

    private final AutomatedReasoningCheckImpossibleFinding impossible;

    private final AutomatedReasoningCheckTranslationAmbiguousFinding translationAmbiguous;

    private final AutomatedReasoningCheckTooComplexFinding tooComplex;

    private final AutomatedReasoningCheckNoTranslationsFinding noTranslations;

    private final Type type;

    private AutomatedReasoningCheckFinding(BuilderImpl builder) {
        this.valid = builder.valid;
        this.invalid = builder.invalid;
        this.satisfiable = builder.satisfiable;
        this.impossible = builder.impossible;
        this.translationAmbiguous = builder.translationAmbiguous;
        this.tooComplex = builder.tooComplex;
        this.noTranslations = builder.noTranslations;
        this.type = builder.type;
    }

    /**
     * <p>
     * Indicates that the claims are true. The claims are implied by the premises and the Automated Reasoning policy.
     * Given the Automated Reasoning policy and premises, it is not possible for these claims to be false.
     * </p>
     * 
     * @return Indicates that the claims are true. The claims are implied by the premises and the Automated Reasoning
     *         policy. Given the Automated Reasoning policy and premises, it is not possible for these claims to be
     *         false.
     */
    public final AutomatedReasoningCheckValidFinding valid() {
        return valid;
    }

    /**
     * <p>
     * Indicates that the claims are false. The claims are not implied by the premises and Automated Reasoning policy.
     * Furthermore, there exist different claims that are consistent with the premises and Automated Reasoning policy.
     * </p>
     * 
     * @return Indicates that the claims are false. The claims are not implied by the premises and Automated Reasoning
     *         policy. Furthermore, there exist different claims that are consistent with the premises and Automated
     *         Reasoning policy.
     */
    public final AutomatedReasoningCheckInvalidFinding invalid() {
        return invalid;
    }

    /**
     * <p>
     * Indicates that the claims can be true or false. It depends on what assumptions are made for the claim to be
     * implied from the premises and Automated Reasoning policy rules. In this situation, different assumptions can make
     * input claims false and alternative claims true.
     * </p>
     * 
     * @return Indicates that the claims can be true or false. It depends on what assumptions are made for the claim to
     *         be implied from the premises and Automated Reasoning policy rules. In this situation, different
     *         assumptions can make input claims false and alternative claims true.
     */
    public final AutomatedReasoningCheckSatisfiableFinding satisfiable() {
        return satisfiable;
    }

    /**
     * <p>
     * Indicates that Automated Reasoning cannot make a statement about the claims. This can happen if the premises are
     * logically incorrect, or if there is a conflict within the Automated Reasoning policy itself.
     * </p>
     * 
     * @return Indicates that Automated Reasoning cannot make a statement about the claims. This can happen if the
     *         premises are logically incorrect, or if there is a conflict within the Automated Reasoning policy itself.
     */
    public final AutomatedReasoningCheckImpossibleFinding impossible() {
        return impossible;
    }

    /**
     * <p>
     * Indicates that an ambiguity was detected in the translation, making it unsound to continue with validity
     * checking. Additional context or follow-up questions might be needed to get translation to succeed.
     * </p>
     * 
     * @return Indicates that an ambiguity was detected in the translation, making it unsound to continue with validity
     *         checking. Additional context or follow-up questions might be needed to get translation to succeed.
     */
    public final AutomatedReasoningCheckTranslationAmbiguousFinding translationAmbiguous() {
        return translationAmbiguous;
    }

    /**
     * <p>
     * Indicates that the input contains too much information for Automated Reasoning to process within its latency
     * limits.
     * </p>
     * 
     * @return Indicates that the input contains too much information for Automated Reasoning to process within its
     *         latency limits.
     */
    public final AutomatedReasoningCheckTooComplexFinding tooComplex() {
        return tooComplex;
    }

    /**
     * <p>
     * Identifies that some or all of the input prompt wasn't translated into logic. This can happen if the input isn't
     * relevant to the Automated Reasoning policy, or if the policy doesn't have variables to model relevant input.
     * </p>
     * 
     * @return Identifies that some or all of the input prompt wasn't translated into logic. This can happen if the
     *         input isn't relevant to the Automated Reasoning policy, or if the policy doesn't have variables to model
     *         relevant input.
     */
    public final AutomatedReasoningCheckNoTranslationsFinding noTranslations() {
        return noTranslations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(valid());
        hashCode = 31 * hashCode + Objects.hashCode(invalid());
        hashCode = 31 * hashCode + Objects.hashCode(satisfiable());
        hashCode = 31 * hashCode + Objects.hashCode(impossible());
        hashCode = 31 * hashCode + Objects.hashCode(translationAmbiguous());
        hashCode = 31 * hashCode + Objects.hashCode(tooComplex());
        hashCode = 31 * hashCode + Objects.hashCode(noTranslations());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomatedReasoningCheckFinding)) {
            return false;
        }
        AutomatedReasoningCheckFinding other = (AutomatedReasoningCheckFinding) obj;
        return Objects.equals(valid(), other.valid()) && Objects.equals(invalid(), other.invalid())
                && Objects.equals(satisfiable(), other.satisfiable()) && Objects.equals(impossible(), other.impossible())
                && Objects.equals(translationAmbiguous(), other.translationAmbiguous())
                && Objects.equals(tooComplex(), other.tooComplex()) && Objects.equals(noTranslations(), other.noTranslations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutomatedReasoningCheckFinding").add("Valid", valid()).add("Invalid", invalid())
                .add("Satisfiable", satisfiable()).add("Impossible", impossible())
                .add("TranslationAmbiguous", translationAmbiguous()).add("TooComplex", tooComplex())
                .add("NoTranslations", noTranslations()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "valid":
            return Optional.ofNullable(clazz.cast(valid()));
        case "invalid":
            return Optional.ofNullable(clazz.cast(invalid()));
        case "satisfiable":
            return Optional.ofNullable(clazz.cast(satisfiable()));
        case "impossible":
            return Optional.ofNullable(clazz.cast(impossible()));
        case "translationAmbiguous":
            return Optional.ofNullable(clazz.cast(translationAmbiguous()));
        case "tooComplex":
            return Optional.ofNullable(clazz.cast(tooComplex()));
        case "noTranslations":
            return Optional.ofNullable(clazz.cast(noTranslations()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #valid()} initialized to the given value.
     *
     * <p>
     * Indicates that the claims are true. The claims are implied by the premises and the Automated Reasoning policy.
     * Given the Automated Reasoning policy and premises, it is not possible for these claims to be false.
     * </p>
     * 
     * @param valid
     *        Indicates that the claims are true. The claims are implied by the premises and the Automated Reasoning
     *        policy. Given the Automated Reasoning policy and premises, it is not possible for these claims to be
     *        false.
     */
    public static AutomatedReasoningCheckFinding fromValid(AutomatedReasoningCheckValidFinding valid) {
        return builder().valid(valid).build();
    }

    /**
     * Create an instance of this class with {@link #valid()} initialized to the given value.
     *
     * <p>
     * Indicates that the claims are true. The claims are implied by the premises and the Automated Reasoning policy.
     * Given the Automated Reasoning policy and premises, it is not possible for these claims to be false.
     * </p>
     * 
     * @param valid
     *        Indicates that the claims are true. The claims are implied by the premises and the Automated Reasoning
     *        policy. Given the Automated Reasoning policy and premises, it is not possible for these claims to be
     *        false.
     */
    public static AutomatedReasoningCheckFinding fromValid(Consumer<AutomatedReasoningCheckValidFinding.Builder> valid) {
        AutomatedReasoningCheckValidFinding.Builder builder = AutomatedReasoningCheckValidFinding.builder();
        valid.accept(builder);
        return fromValid(builder.build());
    }

    /**
     * Create an instance of this class with {@link #invalid()} initialized to the given value.
     *
     * <p>
     * Indicates that the claims are false. The claims are not implied by the premises and Automated Reasoning policy.
     * Furthermore, there exist different claims that are consistent with the premises and Automated Reasoning policy.
     * </p>
     * 
     * @param invalid
     *        Indicates that the claims are false. The claims are not implied by the premises and Automated Reasoning
     *        policy. Furthermore, there exist different claims that are consistent with the premises and Automated
     *        Reasoning policy.
     */
    public static AutomatedReasoningCheckFinding fromInvalid(AutomatedReasoningCheckInvalidFinding invalid) {
        return builder().invalid(invalid).build();
    }

    /**
     * Create an instance of this class with {@link #invalid()} initialized to the given value.
     *
     * <p>
     * Indicates that the claims are false. The claims are not implied by the premises and Automated Reasoning policy.
     * Furthermore, there exist different claims that are consistent with the premises and Automated Reasoning policy.
     * </p>
     * 
     * @param invalid
     *        Indicates that the claims are false. The claims are not implied by the premises and Automated Reasoning
     *        policy. Furthermore, there exist different claims that are consistent with the premises and Automated
     *        Reasoning policy.
     */
    public static AutomatedReasoningCheckFinding fromInvalid(Consumer<AutomatedReasoningCheckInvalidFinding.Builder> invalid) {
        AutomatedReasoningCheckInvalidFinding.Builder builder = AutomatedReasoningCheckInvalidFinding.builder();
        invalid.accept(builder);
        return fromInvalid(builder.build());
    }

    /**
     * Create an instance of this class with {@link #satisfiable()} initialized to the given value.
     *
     * <p>
     * Indicates that the claims can be true or false. It depends on what assumptions are made for the claim to be
     * implied from the premises and Automated Reasoning policy rules. In this situation, different assumptions can make
     * input claims false and alternative claims true.
     * </p>
     * 
     * @param satisfiable
     *        Indicates that the claims can be true or false. It depends on what assumptions are made for the claim to
     *        be implied from the premises and Automated Reasoning policy rules. In this situation, different
     *        assumptions can make input claims false and alternative claims true.
     */
    public static AutomatedReasoningCheckFinding fromSatisfiable(AutomatedReasoningCheckSatisfiableFinding satisfiable) {
        return builder().satisfiable(satisfiable).build();
    }

    /**
     * Create an instance of this class with {@link #satisfiable()} initialized to the given value.
     *
     * <p>
     * Indicates that the claims can be true or false. It depends on what assumptions are made for the claim to be
     * implied from the premises and Automated Reasoning policy rules. In this situation, different assumptions can make
     * input claims false and alternative claims true.
     * </p>
     * 
     * @param satisfiable
     *        Indicates that the claims can be true or false. It depends on what assumptions are made for the claim to
     *        be implied from the premises and Automated Reasoning policy rules. In this situation, different
     *        assumptions can make input claims false and alternative claims true.
     */
    public static AutomatedReasoningCheckFinding fromSatisfiable(
            Consumer<AutomatedReasoningCheckSatisfiableFinding.Builder> satisfiable) {
        AutomatedReasoningCheckSatisfiableFinding.Builder builder = AutomatedReasoningCheckSatisfiableFinding.builder();
        satisfiable.accept(builder);
        return fromSatisfiable(builder.build());
    }

    /**
     * Create an instance of this class with {@link #impossible()} initialized to the given value.
     *
     * <p>
     * Indicates that Automated Reasoning cannot make a statement about the claims. This can happen if the premises are
     * logically incorrect, or if there is a conflict within the Automated Reasoning policy itself.
     * </p>
     * 
     * @param impossible
     *        Indicates that Automated Reasoning cannot make a statement about the claims. This can happen if the
     *        premises are logically incorrect, or if there is a conflict within the Automated Reasoning policy itself.
     */
    public static AutomatedReasoningCheckFinding fromImpossible(AutomatedReasoningCheckImpossibleFinding impossible) {
        return builder().impossible(impossible).build();
    }

    /**
     * Create an instance of this class with {@link #impossible()} initialized to the given value.
     *
     * <p>
     * Indicates that Automated Reasoning cannot make a statement about the claims. This can happen if the premises are
     * logically incorrect, or if there is a conflict within the Automated Reasoning policy itself.
     * </p>
     * 
     * @param impossible
     *        Indicates that Automated Reasoning cannot make a statement about the claims. This can happen if the
     *        premises are logically incorrect, or if there is a conflict within the Automated Reasoning policy itself.
     */
    public static AutomatedReasoningCheckFinding fromImpossible(
            Consumer<AutomatedReasoningCheckImpossibleFinding.Builder> impossible) {
        AutomatedReasoningCheckImpossibleFinding.Builder builder = AutomatedReasoningCheckImpossibleFinding.builder();
        impossible.accept(builder);
        return fromImpossible(builder.build());
    }

    /**
     * Create an instance of this class with {@link #translationAmbiguous()} initialized to the given value.
     *
     * <p>
     * Indicates that an ambiguity was detected in the translation, making it unsound to continue with validity
     * checking. Additional context or follow-up questions might be needed to get translation to succeed.
     * </p>
     * 
     * @param translationAmbiguous
     *        Indicates that an ambiguity was detected in the translation, making it unsound to continue with validity
     *        checking. Additional context or follow-up questions might be needed to get translation to succeed.
     */
    public static AutomatedReasoningCheckFinding fromTranslationAmbiguous(
            AutomatedReasoningCheckTranslationAmbiguousFinding translationAmbiguous) {
        return builder().translationAmbiguous(translationAmbiguous).build();
    }

    /**
     * Create an instance of this class with {@link #translationAmbiguous()} initialized to the given value.
     *
     * <p>
     * Indicates that an ambiguity was detected in the translation, making it unsound to continue with validity
     * checking. Additional context or follow-up questions might be needed to get translation to succeed.
     * </p>
     * 
     * @param translationAmbiguous
     *        Indicates that an ambiguity was detected in the translation, making it unsound to continue with validity
     *        checking. Additional context or follow-up questions might be needed to get translation to succeed.
     */
    public static AutomatedReasoningCheckFinding fromTranslationAmbiguous(
            Consumer<AutomatedReasoningCheckTranslationAmbiguousFinding.Builder> translationAmbiguous) {
        AutomatedReasoningCheckTranslationAmbiguousFinding.Builder builder = AutomatedReasoningCheckTranslationAmbiguousFinding
                .builder();
        translationAmbiguous.accept(builder);
        return fromTranslationAmbiguous(builder.build());
    }

    /**
     * Create an instance of this class with {@link #tooComplex()} initialized to the given value.
     *
     * <p>
     * Indicates that the input contains too much information for Automated Reasoning to process within its latency
     * limits.
     * </p>
     * 
     * @param tooComplex
     *        Indicates that the input contains too much information for Automated Reasoning to process within its
     *        latency limits.
     */
    public static AutomatedReasoningCheckFinding fromTooComplex(AutomatedReasoningCheckTooComplexFinding tooComplex) {
        return builder().tooComplex(tooComplex).build();
    }

    /**
     * Create an instance of this class with {@link #tooComplex()} initialized to the given value.
     *
     * <p>
     * Indicates that the input contains too much information for Automated Reasoning to process within its latency
     * limits.
     * </p>
     * 
     * @param tooComplex
     *        Indicates that the input contains too much information for Automated Reasoning to process within its
     *        latency limits.
     */
    public static AutomatedReasoningCheckFinding fromTooComplex(
            Consumer<AutomatedReasoningCheckTooComplexFinding.Builder> tooComplex) {
        AutomatedReasoningCheckTooComplexFinding.Builder builder = AutomatedReasoningCheckTooComplexFinding.builder();
        tooComplex.accept(builder);
        return fromTooComplex(builder.build());
    }

    /**
     * Create an instance of this class with {@link #noTranslations()} initialized to the given value.
     *
     * <p>
     * Identifies that some or all of the input prompt wasn't translated into logic. This can happen if the input isn't
     * relevant to the Automated Reasoning policy, or if the policy doesn't have variables to model relevant input.
     * </p>
     * 
     * @param noTranslations
     *        Identifies that some or all of the input prompt wasn't translated into logic. This can happen if the input
     *        isn't relevant to the Automated Reasoning policy, or if the policy doesn't have variables to model
     *        relevant input.
     */
    public static AutomatedReasoningCheckFinding fromNoTranslations(AutomatedReasoningCheckNoTranslationsFinding noTranslations) {
        return builder().noTranslations(noTranslations).build();
    }

    /**
     * Create an instance of this class with {@link #noTranslations()} initialized to the given value.
     *
     * <p>
     * Identifies that some or all of the input prompt wasn't translated into logic. This can happen if the input isn't
     * relevant to the Automated Reasoning policy, or if the policy doesn't have variables to model relevant input.
     * </p>
     * 
     * @param noTranslations
     *        Identifies that some or all of the input prompt wasn't translated into logic. This can happen if the input
     *        isn't relevant to the Automated Reasoning policy, or if the policy doesn't have variables to model
     *        relevant input.
     */
    public static AutomatedReasoningCheckFinding fromNoTranslations(
            Consumer<AutomatedReasoningCheckNoTranslationsFinding.Builder> noTranslations) {
        AutomatedReasoningCheckNoTranslationsFinding.Builder builder = AutomatedReasoningCheckNoTranslationsFinding.builder();
        noTranslations.accept(builder);
        return fromNoTranslations(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("valid", VALID_FIELD);
        map.put("invalid", INVALID_FIELD);
        map.put("satisfiable", SATISFIABLE_FIELD);
        map.put("impossible", IMPOSSIBLE_FIELD);
        map.put("translationAmbiguous", TRANSLATION_AMBIGUOUS_FIELD);
        map.put("tooComplex", TOO_COMPLEX_FIELD);
        map.put("noTranslations", NO_TRANSLATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutomatedReasoningCheckFinding, T> g) {
        return obj -> g.apply((AutomatedReasoningCheckFinding) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutomatedReasoningCheckFinding> {
        /**
         * <p>
         * Indicates that the claims are true. The claims are implied by the premises and the Automated Reasoning
         * policy. Given the Automated Reasoning policy and premises, it is not possible for these claims to be false.
         * </p>
         * 
         * @param valid
         *        Indicates that the claims are true. The claims are implied by the premises and the Automated Reasoning
         *        policy. Given the Automated Reasoning policy and premises, it is not possible for these claims to be
         *        false.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder valid(AutomatedReasoningCheckValidFinding valid);

        /**
         * <p>
         * Indicates that the claims are true. The claims are implied by the premises and the Automated Reasoning
         * policy. Given the Automated Reasoning policy and premises, it is not possible for these claims to be false.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AutomatedReasoningCheckValidFinding.Builder} avoiding the need to create one manually via
         * {@link AutomatedReasoningCheckValidFinding#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutomatedReasoningCheckValidFinding.Builder#build()} is called
         * immediately and its result is passed to {@link #valid(AutomatedReasoningCheckValidFinding)}.
         * 
         * @param valid
         *        a consumer that will call methods on {@link AutomatedReasoningCheckValidFinding.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #valid(AutomatedReasoningCheckValidFinding)
         */
        default Builder valid(Consumer<AutomatedReasoningCheckValidFinding.Builder> valid) {
            return valid(AutomatedReasoningCheckValidFinding.builder().applyMutation(valid).build());
        }

        /**
         * <p>
         * Indicates that the claims are false. The claims are not implied by the premises and Automated Reasoning
         * policy. Furthermore, there exist different claims that are consistent with the premises and Automated
         * Reasoning policy.
         * </p>
         * 
         * @param invalid
         *        Indicates that the claims are false. The claims are not implied by the premises and Automated
         *        Reasoning policy. Furthermore, there exist different claims that are consistent with the premises and
         *        Automated Reasoning policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invalid(AutomatedReasoningCheckInvalidFinding invalid);

        /**
         * <p>
         * Indicates that the claims are false. The claims are not implied by the premises and Automated Reasoning
         * policy. Furthermore, there exist different claims that are consistent with the premises and Automated
         * Reasoning policy.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AutomatedReasoningCheckInvalidFinding.Builder} avoiding the need to create one manually via
         * {@link AutomatedReasoningCheckInvalidFinding#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutomatedReasoningCheckInvalidFinding.Builder#build()} is called
         * immediately and its result is passed to {@link #invalid(AutomatedReasoningCheckInvalidFinding)}.
         * 
         * @param invalid
         *        a consumer that will call methods on {@link AutomatedReasoningCheckInvalidFinding.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #invalid(AutomatedReasoningCheckInvalidFinding)
         */
        default Builder invalid(Consumer<AutomatedReasoningCheckInvalidFinding.Builder> invalid) {
            return invalid(AutomatedReasoningCheckInvalidFinding.builder().applyMutation(invalid).build());
        }

        /**
         * <p>
         * Indicates that the claims can be true or false. It depends on what assumptions are made for the claim to be
         * implied from the premises and Automated Reasoning policy rules. In this situation, different assumptions can
         * make input claims false and alternative claims true.
         * </p>
         * 
         * @param satisfiable
         *        Indicates that the claims can be true or false. It depends on what assumptions are made for the claim
         *        to be implied from the premises and Automated Reasoning policy rules. In this situation, different
         *        assumptions can make input claims false and alternative claims true.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder satisfiable(AutomatedReasoningCheckSatisfiableFinding satisfiable);

        /**
         * <p>
         * Indicates that the claims can be true or false. It depends on what assumptions are made for the claim to be
         * implied from the premises and Automated Reasoning policy rules. In this situation, different assumptions can
         * make input claims false and alternative claims true.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AutomatedReasoningCheckSatisfiableFinding.Builder} avoiding the need to create one manually via
         * {@link AutomatedReasoningCheckSatisfiableFinding#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutomatedReasoningCheckSatisfiableFinding.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #satisfiable(AutomatedReasoningCheckSatisfiableFinding)}.
         * 
         * @param satisfiable
         *        a consumer that will call methods on {@link AutomatedReasoningCheckSatisfiableFinding.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #satisfiable(AutomatedReasoningCheckSatisfiableFinding)
         */
        default Builder satisfiable(Consumer<AutomatedReasoningCheckSatisfiableFinding.Builder> satisfiable) {
            return satisfiable(AutomatedReasoningCheckSatisfiableFinding.builder().applyMutation(satisfiable).build());
        }

        /**
         * <p>
         * Indicates that Automated Reasoning cannot make a statement about the claims. This can happen if the premises
         * are logically incorrect, or if there is a conflict within the Automated Reasoning policy itself.
         * </p>
         * 
         * @param impossible
         *        Indicates that Automated Reasoning cannot make a statement about the claims. This can happen if the
         *        premises are logically incorrect, or if there is a conflict within the Automated Reasoning policy
         *        itself.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder impossible(AutomatedReasoningCheckImpossibleFinding impossible);

        /**
         * <p>
         * Indicates that Automated Reasoning cannot make a statement about the claims. This can happen if the premises
         * are logically incorrect, or if there is a conflict within the Automated Reasoning policy itself.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AutomatedReasoningCheckImpossibleFinding.Builder} avoiding the need to create one manually via
         * {@link AutomatedReasoningCheckImpossibleFinding#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutomatedReasoningCheckImpossibleFinding.Builder#build()} is
         * called immediately and its result is passed to {@link #impossible(AutomatedReasoningCheckImpossibleFinding)}.
         * 
         * @param impossible
         *        a consumer that will call methods on {@link AutomatedReasoningCheckImpossibleFinding.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #impossible(AutomatedReasoningCheckImpossibleFinding)
         */
        default Builder impossible(Consumer<AutomatedReasoningCheckImpossibleFinding.Builder> impossible) {
            return impossible(AutomatedReasoningCheckImpossibleFinding.builder().applyMutation(impossible).build());
        }

        /**
         * <p>
         * Indicates that an ambiguity was detected in the translation, making it unsound to continue with validity
         * checking. Additional context or follow-up questions might be needed to get translation to succeed.
         * </p>
         * 
         * @param translationAmbiguous
         *        Indicates that an ambiguity was detected in the translation, making it unsound to continue with
         *        validity checking. Additional context or follow-up questions might be needed to get translation to
         *        succeed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder translationAmbiguous(AutomatedReasoningCheckTranslationAmbiguousFinding translationAmbiguous);

        /**
         * <p>
         * Indicates that an ambiguity was detected in the translation, making it unsound to continue with validity
         * checking. Additional context or follow-up questions might be needed to get translation to succeed.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AutomatedReasoningCheckTranslationAmbiguousFinding.Builder} avoiding the need to create one manually
         * via {@link AutomatedReasoningCheckTranslationAmbiguousFinding#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link AutomatedReasoningCheckTranslationAmbiguousFinding.Builder#build()} is called immediately and its
         * result is passed to {@link #translationAmbiguous(AutomatedReasoningCheckTranslationAmbiguousFinding)}.
         * 
         * @param translationAmbiguous
         *        a consumer that will call methods on
         *        {@link AutomatedReasoningCheckTranslationAmbiguousFinding.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #translationAmbiguous(AutomatedReasoningCheckTranslationAmbiguousFinding)
         */
        default Builder translationAmbiguous(
                Consumer<AutomatedReasoningCheckTranslationAmbiguousFinding.Builder> translationAmbiguous) {
            return translationAmbiguous(AutomatedReasoningCheckTranslationAmbiguousFinding.builder()
                    .applyMutation(translationAmbiguous).build());
        }

        /**
         * <p>
         * Indicates that the input contains too much information for Automated Reasoning to process within its latency
         * limits.
         * </p>
         * 
         * @param tooComplex
         *        Indicates that the input contains too much information for Automated Reasoning to process within its
         *        latency limits.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tooComplex(AutomatedReasoningCheckTooComplexFinding tooComplex);

        /**
         * <p>
         * Indicates that the input contains too much information for Automated Reasoning to process within its latency
         * limits.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AutomatedReasoningCheckTooComplexFinding.Builder} avoiding the need to create one manually via
         * {@link AutomatedReasoningCheckTooComplexFinding#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutomatedReasoningCheckTooComplexFinding.Builder#build()} is
         * called immediately and its result is passed to {@link #tooComplex(AutomatedReasoningCheckTooComplexFinding)}.
         * 
         * @param tooComplex
         *        a consumer that will call methods on {@link AutomatedReasoningCheckTooComplexFinding.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tooComplex(AutomatedReasoningCheckTooComplexFinding)
         */
        default Builder tooComplex(Consumer<AutomatedReasoningCheckTooComplexFinding.Builder> tooComplex) {
            return tooComplex(AutomatedReasoningCheckTooComplexFinding.builder().applyMutation(tooComplex).build());
        }

        /**
         * <p>
         * Identifies that some or all of the input prompt wasn't translated into logic. This can happen if the input
         * isn't relevant to the Automated Reasoning policy, or if the policy doesn't have variables to model relevant
         * input.
         * </p>
         * 
         * @param noTranslations
         *        Identifies that some or all of the input prompt wasn't translated into logic. This can happen if the
         *        input isn't relevant to the Automated Reasoning policy, or if the policy doesn't have variables to
         *        model relevant input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder noTranslations(AutomatedReasoningCheckNoTranslationsFinding noTranslations);

        /**
         * <p>
         * Identifies that some or all of the input prompt wasn't translated into logic. This can happen if the input
         * isn't relevant to the Automated Reasoning policy, or if the policy doesn't have variables to model relevant
         * input.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AutomatedReasoningCheckNoTranslationsFinding.Builder} avoiding the need to create one manually via
         * {@link AutomatedReasoningCheckNoTranslationsFinding#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutomatedReasoningCheckNoTranslationsFinding.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #noTranslations(AutomatedReasoningCheckNoTranslationsFinding)}.
         * 
         * @param noTranslations
         *        a consumer that will call methods on {@link AutomatedReasoningCheckNoTranslationsFinding.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #noTranslations(AutomatedReasoningCheckNoTranslationsFinding)
         */
        default Builder noTranslations(Consumer<AutomatedReasoningCheckNoTranslationsFinding.Builder> noTranslations) {
            return noTranslations(AutomatedReasoningCheckNoTranslationsFinding.builder().applyMutation(noTranslations).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AutomatedReasoningCheckValidFinding valid;

        private AutomatedReasoningCheckInvalidFinding invalid;

        private AutomatedReasoningCheckSatisfiableFinding satisfiable;

        private AutomatedReasoningCheckImpossibleFinding impossible;

        private AutomatedReasoningCheckTranslationAmbiguousFinding translationAmbiguous;

        private AutomatedReasoningCheckTooComplexFinding tooComplex;

        private AutomatedReasoningCheckNoTranslationsFinding noTranslations;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(AutomatedReasoningCheckFinding model) {
            valid(model.valid);
            invalid(model.invalid);
            satisfiable(model.satisfiable);
            impossible(model.impossible);
            translationAmbiguous(model.translationAmbiguous);
            tooComplex(model.tooComplex);
            noTranslations(model.noTranslations);
        }

        public final AutomatedReasoningCheckValidFinding.Builder getValid() {
            return valid != null ? valid.toBuilder() : null;
        }

        public final void setValid(AutomatedReasoningCheckValidFinding.BuilderImpl valid) {
            Object oldValue = this.valid;
            this.valid = valid != null ? valid.build() : null;
            handleUnionValueChange(Type.VALID, oldValue, this.valid);
        }

        @Override
        public final Builder valid(AutomatedReasoningCheckValidFinding valid) {
            Object oldValue = this.valid;
            this.valid = valid;
            handleUnionValueChange(Type.VALID, oldValue, this.valid);
            return this;
        }

        public final AutomatedReasoningCheckInvalidFinding.Builder getInvalid() {
            return invalid != null ? invalid.toBuilder() : null;
        }

        public final void setInvalid(AutomatedReasoningCheckInvalidFinding.BuilderImpl invalid) {
            Object oldValue = this.invalid;
            this.invalid = invalid != null ? invalid.build() : null;
            handleUnionValueChange(Type.INVALID, oldValue, this.invalid);
        }

        @Override
        public final Builder invalid(AutomatedReasoningCheckInvalidFinding invalid) {
            Object oldValue = this.invalid;
            this.invalid = invalid;
            handleUnionValueChange(Type.INVALID, oldValue, this.invalid);
            return this;
        }

        public final AutomatedReasoningCheckSatisfiableFinding.Builder getSatisfiable() {
            return satisfiable != null ? satisfiable.toBuilder() : null;
        }

        public final void setSatisfiable(AutomatedReasoningCheckSatisfiableFinding.BuilderImpl satisfiable) {
            Object oldValue = this.satisfiable;
            this.satisfiable = satisfiable != null ? satisfiable.build() : null;
            handleUnionValueChange(Type.SATISFIABLE, oldValue, this.satisfiable);
        }

        @Override
        public final Builder satisfiable(AutomatedReasoningCheckSatisfiableFinding satisfiable) {
            Object oldValue = this.satisfiable;
            this.satisfiable = satisfiable;
            handleUnionValueChange(Type.SATISFIABLE, oldValue, this.satisfiable);
            return this;
        }

        public final AutomatedReasoningCheckImpossibleFinding.Builder getImpossible() {
            return impossible != null ? impossible.toBuilder() : null;
        }

        public final void setImpossible(AutomatedReasoningCheckImpossibleFinding.BuilderImpl impossible) {
            Object oldValue = this.impossible;
            this.impossible = impossible != null ? impossible.build() : null;
            handleUnionValueChange(Type.IMPOSSIBLE, oldValue, this.impossible);
        }

        @Override
        public final Builder impossible(AutomatedReasoningCheckImpossibleFinding impossible) {
            Object oldValue = this.impossible;
            this.impossible = impossible;
            handleUnionValueChange(Type.IMPOSSIBLE, oldValue, this.impossible);
            return this;
        }

        public final AutomatedReasoningCheckTranslationAmbiguousFinding.Builder getTranslationAmbiguous() {
            return translationAmbiguous != null ? translationAmbiguous.toBuilder() : null;
        }

        public final void setTranslationAmbiguous(
                AutomatedReasoningCheckTranslationAmbiguousFinding.BuilderImpl translationAmbiguous) {
            Object oldValue = this.translationAmbiguous;
            this.translationAmbiguous = translationAmbiguous != null ? translationAmbiguous.build() : null;
            handleUnionValueChange(Type.TRANSLATION_AMBIGUOUS, oldValue, this.translationAmbiguous);
        }

        @Override
        public final Builder translationAmbiguous(AutomatedReasoningCheckTranslationAmbiguousFinding translationAmbiguous) {
            Object oldValue = this.translationAmbiguous;
            this.translationAmbiguous = translationAmbiguous;
            handleUnionValueChange(Type.TRANSLATION_AMBIGUOUS, oldValue, this.translationAmbiguous);
            return this;
        }

        public final AutomatedReasoningCheckTooComplexFinding.Builder getTooComplex() {
            return tooComplex != null ? tooComplex.toBuilder() : null;
        }

        public final void setTooComplex(AutomatedReasoningCheckTooComplexFinding.BuilderImpl tooComplex) {
            Object oldValue = this.tooComplex;
            this.tooComplex = tooComplex != null ? tooComplex.build() : null;
            handleUnionValueChange(Type.TOO_COMPLEX, oldValue, this.tooComplex);
        }

        @Override
        public final Builder tooComplex(AutomatedReasoningCheckTooComplexFinding tooComplex) {
            Object oldValue = this.tooComplex;
            this.tooComplex = tooComplex;
            handleUnionValueChange(Type.TOO_COMPLEX, oldValue, this.tooComplex);
            return this;
        }

        public final AutomatedReasoningCheckNoTranslationsFinding.Builder getNoTranslations() {
            return noTranslations != null ? noTranslations.toBuilder() : null;
        }

        public final void setNoTranslations(AutomatedReasoningCheckNoTranslationsFinding.BuilderImpl noTranslations) {
            Object oldValue = this.noTranslations;
            this.noTranslations = noTranslations != null ? noTranslations.build() : null;
            handleUnionValueChange(Type.NO_TRANSLATIONS, oldValue, this.noTranslations);
        }

        @Override
        public final Builder noTranslations(AutomatedReasoningCheckNoTranslationsFinding noTranslations) {
            Object oldValue = this.noTranslations;
            this.noTranslations = noTranslations;
            handleUnionValueChange(Type.NO_TRANSLATIONS, oldValue, this.noTranslations);
            return this;
        }

        @Override
        public AutomatedReasoningCheckFinding build() {
            return new AutomatedReasoningCheckFinding(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see AutomatedReasoningCheckFinding#type()
     */
    public enum Type {
        VALID,

        INVALID,

        SATISFIABLE,

        IMPOSSIBLE,

        TRANSLATION_AMBIGUOUS,

        TOO_COMPLEX,

        NO_TRANSLATIONS,

        UNKNOWN_TO_SDK_VERSION
    }
}
