/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Account enforced guardrail output configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AccountEnforcedGuardrailOutputConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<AccountEnforcedGuardrailOutputConfiguration.Builder, AccountEnforcedGuardrailOutputConfiguration> {
    private static final SdkField<String> CONFIG_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("configId").getter(getter(AccountEnforcedGuardrailOutputConfiguration::configId))
            .setter(setter(Builder::configId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configId").build()).build();

    private static final SdkField<String> GUARDRAIL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("guardrailArn").getter(getter(AccountEnforcedGuardrailOutputConfiguration::guardrailArn))
            .setter(setter(Builder::guardrailArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("guardrailArn").build()).build();

    private static final SdkField<String> GUARDRAIL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("guardrailId").getter(getter(AccountEnforcedGuardrailOutputConfiguration::guardrailId))
            .setter(setter(Builder::guardrailId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("guardrailId").build()).build();

    private static final SdkField<String> INPUT_TAGS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("inputTags").getter(getter(AccountEnforcedGuardrailOutputConfiguration::inputTagsAsString))
            .setter(setter(Builder::inputTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputTags").build()).build();

    private static final SdkField<String> GUARDRAIL_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("guardrailVersion").getter(getter(AccountEnforcedGuardrailOutputConfiguration::guardrailVersion))
            .setter(setter(Builder::guardrailVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("guardrailVersion").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(AccountEnforcedGuardrailOutputConfiguration::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> CREATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("createdBy").getter(getter(AccountEnforcedGuardrailOutputConfiguration::createdBy))
            .setter(setter(Builder::createdBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt")
            .getter(getter(AccountEnforcedGuardrailOutputConfiguration::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> UPDATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("updatedBy").getter(getter(AccountEnforcedGuardrailOutputConfiguration::updatedBy))
            .setter(setter(Builder::updatedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedBy").build()).build();

    private static final SdkField<String> OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("owner")
            .getter(getter(AccountEnforcedGuardrailOutputConfiguration::ownerAsString)).setter(setter(Builder::owner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("owner").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIG_ID_FIELD,
            GUARDRAIL_ARN_FIELD, GUARDRAIL_ID_FIELD, INPUT_TAGS_FIELD, GUARDRAIL_VERSION_FIELD, CREATED_AT_FIELD,
            CREATED_BY_FIELD, UPDATED_AT_FIELD, UPDATED_BY_FIELD, OWNER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String configId;

    private final String guardrailArn;

    private final String guardrailId;

    private final String inputTags;

    private final String guardrailVersion;

    private final Instant createdAt;

    private final String createdBy;

    private final Instant updatedAt;

    private final String updatedBy;

    private final String owner;

    private AccountEnforcedGuardrailOutputConfiguration(BuilderImpl builder) {
        this.configId = builder.configId;
        this.guardrailArn = builder.guardrailArn;
        this.guardrailId = builder.guardrailId;
        this.inputTags = builder.inputTags;
        this.guardrailVersion = builder.guardrailVersion;
        this.createdAt = builder.createdAt;
        this.createdBy = builder.createdBy;
        this.updatedAt = builder.updatedAt;
        this.updatedBy = builder.updatedBy;
        this.owner = builder.owner;
    }

    /**
     * <p>
     * Unique ID for the account enforced configuration.
     * </p>
     * 
     * @return Unique ID for the account enforced configuration.
     */
    public final String configId() {
        return configId;
    }

    /**
     * <p>
     * ARN representation for the guardrail.
     * </p>
     * 
     * @return ARN representation for the guardrail.
     */
    public final String guardrailArn() {
        return guardrailArn;
    }

    /**
     * <p>
     * Unique ID for the guardrail.
     * </p>
     * 
     * @return Unique ID for the guardrail.
     */
    public final String guardrailId() {
        return guardrailId;
    }

    /**
     * <p>
     * Whether to honor or ignore input tags at runtime.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #inputTags} will
     * return {@link InputTags#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #inputTagsAsString}.
     * </p>
     * 
     * @return Whether to honor or ignore input tags at runtime.
     * @see InputTags
     */
    public final InputTags inputTags() {
        return InputTags.fromValue(inputTags);
    }

    /**
     * <p>
     * Whether to honor or ignore input tags at runtime.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #inputTags} will
     * return {@link InputTags#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #inputTagsAsString}.
     * </p>
     * 
     * @return Whether to honor or ignore input tags at runtime.
     * @see InputTags
     */
    public final String inputTagsAsString() {
        return inputTags;
    }

    /**
     * <p>
     * Numerical guardrail version.
     * </p>
     * 
     * @return Numerical guardrail version.
     */
    public final String guardrailVersion() {
        return guardrailVersion;
    }

    /**
     * <p>
     * Timestamp.
     * </p>
     * 
     * @return Timestamp.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The ARN of the role used to update the configuration.
     * </p>
     * 
     * @return The ARN of the role used to update the configuration.
     */
    public final String createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * Timestamp.
     * </p>
     * 
     * @return Timestamp.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * The ARN of the role used to update the configuration.
     * </p>
     * 
     * @return The ARN of the role used to update the configuration.
     */
    public final String updatedBy() {
        return updatedBy;
    }

    /**
     * <p>
     * Configuration owner type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #owner} will return
     * {@link ConfigurationOwner#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ownerAsString}.
     * </p>
     * 
     * @return Configuration owner type.
     * @see ConfigurationOwner
     */
    public final ConfigurationOwner owner() {
        return ConfigurationOwner.fromValue(owner);
    }

    /**
     * <p>
     * Configuration owner type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #owner} will return
     * {@link ConfigurationOwner#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ownerAsString}.
     * </p>
     * 
     * @return Configuration owner type.
     * @see ConfigurationOwner
     */
    public final String ownerAsString() {
        return owner;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(configId());
        hashCode = 31 * hashCode + Objects.hashCode(guardrailArn());
        hashCode = 31 * hashCode + Objects.hashCode(guardrailId());
        hashCode = 31 * hashCode + Objects.hashCode(inputTagsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(guardrailVersion());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedBy());
        hashCode = 31 * hashCode + Objects.hashCode(ownerAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountEnforcedGuardrailOutputConfiguration)) {
            return false;
        }
        AccountEnforcedGuardrailOutputConfiguration other = (AccountEnforcedGuardrailOutputConfiguration) obj;
        return Objects.equals(configId(), other.configId()) && Objects.equals(guardrailArn(), other.guardrailArn())
                && Objects.equals(guardrailId(), other.guardrailId())
                && Objects.equals(inputTagsAsString(), other.inputTagsAsString())
                && Objects.equals(guardrailVersion(), other.guardrailVersion()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(createdBy(), other.createdBy()) && Objects.equals(updatedAt(), other.updatedAt())
                && Objects.equals(updatedBy(), other.updatedBy()) && Objects.equals(ownerAsString(), other.ownerAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AccountEnforcedGuardrailOutputConfiguration").add("ConfigId", configId())
                .add("GuardrailArn", guardrailArn()).add("GuardrailId", guardrailId()).add("InputTags", inputTagsAsString())
                .add("GuardrailVersion", guardrailVersion()).add("CreatedAt", createdAt()).add("CreatedBy", createdBy())
                .add("UpdatedAt", updatedAt()).add("UpdatedBy", updatedBy()).add("Owner", ownerAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "configId":
            return Optional.ofNullable(clazz.cast(configId()));
        case "guardrailArn":
            return Optional.ofNullable(clazz.cast(guardrailArn()));
        case "guardrailId":
            return Optional.ofNullable(clazz.cast(guardrailId()));
        case "inputTags":
            return Optional.ofNullable(clazz.cast(inputTagsAsString()));
        case "guardrailVersion":
            return Optional.ofNullable(clazz.cast(guardrailVersion()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "createdBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "updatedBy":
            return Optional.ofNullable(clazz.cast(updatedBy()));
        case "owner":
            return Optional.ofNullable(clazz.cast(ownerAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("configId", CONFIG_ID_FIELD);
        map.put("guardrailArn", GUARDRAIL_ARN_FIELD);
        map.put("guardrailId", GUARDRAIL_ID_FIELD);
        map.put("inputTags", INPUT_TAGS_FIELD);
        map.put("guardrailVersion", GUARDRAIL_VERSION_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("createdBy", CREATED_BY_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("updatedBy", UPDATED_BY_FIELD);
        map.put("owner", OWNER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AccountEnforcedGuardrailOutputConfiguration, T> g) {
        return obj -> g.apply((AccountEnforcedGuardrailOutputConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AccountEnforcedGuardrailOutputConfiguration> {
        /**
         * <p>
         * Unique ID for the account enforced configuration.
         * </p>
         * 
         * @param configId
         *        Unique ID for the account enforced configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configId(String configId);

        /**
         * <p>
         * ARN representation for the guardrail.
         * </p>
         * 
         * @param guardrailArn
         *        ARN representation for the guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder guardrailArn(String guardrailArn);

        /**
         * <p>
         * Unique ID for the guardrail.
         * </p>
         * 
         * @param guardrailId
         *        Unique ID for the guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder guardrailId(String guardrailId);

        /**
         * <p>
         * Whether to honor or ignore input tags at runtime.
         * </p>
         * 
         * @param inputTags
         *        Whether to honor or ignore input tags at runtime.
         * @see InputTags
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputTags
         */
        Builder inputTags(String inputTags);

        /**
         * <p>
         * Whether to honor or ignore input tags at runtime.
         * </p>
         * 
         * @param inputTags
         *        Whether to honor or ignore input tags at runtime.
         * @see InputTags
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputTags
         */
        Builder inputTags(InputTags inputTags);

        /**
         * <p>
         * Numerical guardrail version.
         * </p>
         * 
         * @param guardrailVersion
         *        Numerical guardrail version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder guardrailVersion(String guardrailVersion);

        /**
         * <p>
         * Timestamp.
         * </p>
         * 
         * @param createdAt
         *        Timestamp.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The ARN of the role used to update the configuration.
         * </p>
         * 
         * @param createdBy
         *        The ARN of the role used to update the configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(String createdBy);

        /**
         * <p>
         * Timestamp.
         * </p>
         * 
         * @param updatedAt
         *        Timestamp.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * The ARN of the role used to update the configuration.
         * </p>
         * 
         * @param updatedBy
         *        The ARN of the role used to update the configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedBy(String updatedBy);

        /**
         * <p>
         * Configuration owner type.
         * </p>
         * 
         * @param owner
         *        Configuration owner type.
         * @see ConfigurationOwner
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfigurationOwner
         */
        Builder owner(String owner);

        /**
         * <p>
         * Configuration owner type.
         * </p>
         * 
         * @param owner
         *        Configuration owner type.
         * @see ConfigurationOwner
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfigurationOwner
         */
        Builder owner(ConfigurationOwner owner);
    }

    static final class BuilderImpl implements Builder {
        private String configId;

        private String guardrailArn;

        private String guardrailId;

        private String inputTags;

        private String guardrailVersion;

        private Instant createdAt;

        private String createdBy;

        private Instant updatedAt;

        private String updatedBy;

        private String owner;

        private BuilderImpl() {
        }

        private BuilderImpl(AccountEnforcedGuardrailOutputConfiguration model) {
            configId(model.configId);
            guardrailArn(model.guardrailArn);
            guardrailId(model.guardrailId);
            inputTags(model.inputTags);
            guardrailVersion(model.guardrailVersion);
            createdAt(model.createdAt);
            createdBy(model.createdBy);
            updatedAt(model.updatedAt);
            updatedBy(model.updatedBy);
            owner(model.owner);
        }

        public final String getConfigId() {
            return configId;
        }

        public final void setConfigId(String configId) {
            this.configId = configId;
        }

        @Override
        public final Builder configId(String configId) {
            this.configId = configId;
            return this;
        }

        public final String getGuardrailArn() {
            return guardrailArn;
        }

        public final void setGuardrailArn(String guardrailArn) {
            this.guardrailArn = guardrailArn;
        }

        @Override
        public final Builder guardrailArn(String guardrailArn) {
            this.guardrailArn = guardrailArn;
            return this;
        }

        public final String getGuardrailId() {
            return guardrailId;
        }

        public final void setGuardrailId(String guardrailId) {
            this.guardrailId = guardrailId;
        }

        @Override
        public final Builder guardrailId(String guardrailId) {
            this.guardrailId = guardrailId;
            return this;
        }

        public final String getInputTags() {
            return inputTags;
        }

        public final void setInputTags(String inputTags) {
            this.inputTags = inputTags;
        }

        @Override
        public final Builder inputTags(String inputTags) {
            this.inputTags = inputTags;
            return this;
        }

        @Override
        public final Builder inputTags(InputTags inputTags) {
            this.inputTags(inputTags == null ? null : inputTags.toString());
            return this;
        }

        public final String getGuardrailVersion() {
            return guardrailVersion;
        }

        public final void setGuardrailVersion(String guardrailVersion) {
            this.guardrailVersion = guardrailVersion;
        }

        @Override
        public final Builder guardrailVersion(String guardrailVersion) {
            this.guardrailVersion = guardrailVersion;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCreatedBy() {
            return createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getUpdatedBy() {
            return updatedBy;
        }

        public final void setUpdatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
        }

        @Override
        public final Builder updatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
            return this;
        }

        public final String getOwner() {
            return owner;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        @Override
        public final Builder owner(ConfigurationOwner owner) {
            this.owner(owner == null ? null : owner.toString());
            return this;
        }

        @Override
        public AccountEnforcedGuardrailOutputConfiguration build() {
            return new AccountEnforcedGuardrailOutputConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
