/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Account-level enforced guardrail input configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AccountEnforcedGuardrailInferenceInputConfiguration
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<AccountEnforcedGuardrailInferenceInputConfiguration.Builder, AccountEnforcedGuardrailInferenceInputConfiguration> {
    private static final SdkField<String> GUARDRAIL_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("guardrailIdentifier")
            .getter(getter(AccountEnforcedGuardrailInferenceInputConfiguration::guardrailIdentifier))
            .setter(setter(Builder::guardrailIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("guardrailIdentifier").build())
            .build();

    private static final SdkField<String> GUARDRAIL_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("guardrailVersion").getter(getter(AccountEnforcedGuardrailInferenceInputConfiguration::guardrailVersion))
            .setter(setter(Builder::guardrailVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("guardrailVersion").build()).build();

    private static final SdkField<String> INPUT_TAGS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("inputTags").getter(getter(AccountEnforcedGuardrailInferenceInputConfiguration::inputTagsAsString))
            .setter(setter(Builder::inputTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputTags").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GUARDRAIL_IDENTIFIER_FIELD,
            GUARDRAIL_VERSION_FIELD, INPUT_TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String guardrailIdentifier;

    private final String guardrailVersion;

    private final String inputTags;

    private AccountEnforcedGuardrailInferenceInputConfiguration(BuilderImpl builder) {
        this.guardrailIdentifier = builder.guardrailIdentifier;
        this.guardrailVersion = builder.guardrailVersion;
        this.inputTags = builder.inputTags;
    }

    /**
     * <p>
     * Identifier for the guardrail, could be the ID or the ARN.
     * </p>
     * 
     * @return Identifier for the guardrail, could be the ID or the ARN.
     */
    public final String guardrailIdentifier() {
        return guardrailIdentifier;
    }

    /**
     * <p>
     * Numerical guardrail version.
     * </p>
     * 
     * @return Numerical guardrail version.
     */
    public final String guardrailVersion() {
        return guardrailVersion;
    }

    /**
     * <p>
     * Whether to honor or ignore input tags at runtime.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #inputTags} will
     * return {@link InputTags#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #inputTagsAsString}.
     * </p>
     * 
     * @return Whether to honor or ignore input tags at runtime.
     * @see InputTags
     */
    public final InputTags inputTags() {
        return InputTags.fromValue(inputTags);
    }

    /**
     * <p>
     * Whether to honor or ignore input tags at runtime.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #inputTags} will
     * return {@link InputTags#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #inputTagsAsString}.
     * </p>
     * 
     * @return Whether to honor or ignore input tags at runtime.
     * @see InputTags
     */
    public final String inputTagsAsString() {
        return inputTags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(guardrailIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(guardrailVersion());
        hashCode = 31 * hashCode + Objects.hashCode(inputTagsAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountEnforcedGuardrailInferenceInputConfiguration)) {
            return false;
        }
        AccountEnforcedGuardrailInferenceInputConfiguration other = (AccountEnforcedGuardrailInferenceInputConfiguration) obj;
        return Objects.equals(guardrailIdentifier(), other.guardrailIdentifier())
                && Objects.equals(guardrailVersion(), other.guardrailVersion())
                && Objects.equals(inputTagsAsString(), other.inputTagsAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AccountEnforcedGuardrailInferenceInputConfiguration")
                .add("GuardrailIdentifier", guardrailIdentifier()).add("GuardrailVersion", guardrailVersion())
                .add("InputTags", inputTagsAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "guardrailIdentifier":
            return Optional.ofNullable(clazz.cast(guardrailIdentifier()));
        case "guardrailVersion":
            return Optional.ofNullable(clazz.cast(guardrailVersion()));
        case "inputTags":
            return Optional.ofNullable(clazz.cast(inputTagsAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("guardrailIdentifier", GUARDRAIL_IDENTIFIER_FIELD);
        map.put("guardrailVersion", GUARDRAIL_VERSION_FIELD);
        map.put("inputTags", INPUT_TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AccountEnforcedGuardrailInferenceInputConfiguration, T> g) {
        return obj -> g.apply((AccountEnforcedGuardrailInferenceInputConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AccountEnforcedGuardrailInferenceInputConfiguration> {
        /**
         * <p>
         * Identifier for the guardrail, could be the ID or the ARN.
         * </p>
         * 
         * @param guardrailIdentifier
         *        Identifier for the guardrail, could be the ID or the ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder guardrailIdentifier(String guardrailIdentifier);

        /**
         * <p>
         * Numerical guardrail version.
         * </p>
         * 
         * @param guardrailVersion
         *        Numerical guardrail version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder guardrailVersion(String guardrailVersion);

        /**
         * <p>
         * Whether to honor or ignore input tags at runtime.
         * </p>
         * 
         * @param inputTags
         *        Whether to honor or ignore input tags at runtime.
         * @see InputTags
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputTags
         */
        Builder inputTags(String inputTags);

        /**
         * <p>
         * Whether to honor or ignore input tags at runtime.
         * </p>
         * 
         * @param inputTags
         *        Whether to honor or ignore input tags at runtime.
         * @see InputTags
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputTags
         */
        Builder inputTags(InputTags inputTags);
    }

    static final class BuilderImpl implements Builder {
        private String guardrailIdentifier;

        private String guardrailVersion;

        private String inputTags;

        private BuilderImpl() {
        }

        private BuilderImpl(AccountEnforcedGuardrailInferenceInputConfiguration model) {
            guardrailIdentifier(model.guardrailIdentifier);
            guardrailVersion(model.guardrailVersion);
            inputTags(model.inputTags);
        }

        public final String getGuardrailIdentifier() {
            return guardrailIdentifier;
        }

        public final void setGuardrailIdentifier(String guardrailIdentifier) {
            this.guardrailIdentifier = guardrailIdentifier;
        }

        @Override
        public final Builder guardrailIdentifier(String guardrailIdentifier) {
            this.guardrailIdentifier = guardrailIdentifier;
            return this;
        }

        public final String getGuardrailVersion() {
            return guardrailVersion;
        }

        public final void setGuardrailVersion(String guardrailVersion) {
            this.guardrailVersion = guardrailVersion;
        }

        @Override
        public final Builder guardrailVersion(String guardrailVersion) {
            this.guardrailVersion = guardrailVersion;
            return this;
        }

        public final String getInputTags() {
            return inputTags;
        }

        public final void setInputTags(String inputTags) {
            this.inputTags = inputTags;
        }

        @Override
        public final Builder inputTags(String inputTags) {
            this.inputTags = inputTags;
            return this;
        }

        @Override
        public final Builder inputTags(InputTags inputTags) {
            this.inputTags(inputTags == null ? null : inputTags.toString());
            return this;
        }

        @Override
        public AccountEnforcedGuardrailInferenceInputConfiguration build() {
            return new AccountEnforcedGuardrailInferenceInputConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
