/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrock.model.GuardrailContentFilterConfig;
import software.amazon.awssdk.services.bedrock.model.GuardrailContentFiltersConfigCopier;
import software.amazon.awssdk.services.bedrock.model.GuardrailContentFiltersTierConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GuardrailContentPolicyConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GuardrailContentPolicyConfig> {
    private static final SdkField<List<GuardrailContentFilterConfig>> FILTERS_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("filtersConfig").getter(GuardrailContentPolicyConfig.getter(GuardrailContentPolicyConfig::filtersConfig)).setter(GuardrailContentPolicyConfig.setter(Builder::filtersConfig)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filtersConfig").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GuardrailContentFilterConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<GuardrailContentFiltersTierConfig> TIER_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("tierConfig").getter(GuardrailContentPolicyConfig.getter(GuardrailContentPolicyConfig::tierConfig)).setter(GuardrailContentPolicyConfig.setter(Builder::tierConfig)).constructor(GuardrailContentFiltersTierConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tierConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTERS_CONFIG_FIELD, TIER_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GuardrailContentPolicyConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<GuardrailContentFilterConfig> filtersConfig;
    private final GuardrailContentFiltersTierConfig tierConfig;

    private GuardrailContentPolicyConfig(BuilderImpl builder) {
        this.filtersConfig = builder.filtersConfig;
        this.tierConfig = builder.tierConfig;
    }

    public final boolean hasFiltersConfig() {
        return this.filtersConfig != null && !(this.filtersConfig instanceof SdkAutoConstructList);
    }

    public final List<GuardrailContentFilterConfig> filtersConfig() {
        return this.filtersConfig;
    }

    public final GuardrailContentFiltersTierConfig tierConfig() {
        return this.tierConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFiltersConfig() ? this.filtersConfig() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.tierConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GuardrailContentPolicyConfig)) {
            return false;
        }
        GuardrailContentPolicyConfig other = (GuardrailContentPolicyConfig)obj;
        return this.hasFiltersConfig() == other.hasFiltersConfig() && Objects.equals(this.filtersConfig(), other.filtersConfig()) && Objects.equals(this.tierConfig(), other.tierConfig());
    }

    public final String toString() {
        return ToString.builder((String)"GuardrailContentPolicyConfig").add("FiltersConfig", this.hasFiltersConfig() ? this.filtersConfig() : null).add("TierConfig", (Object)this.tierConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "filtersConfig": {
                return Optional.ofNullable(clazz.cast(this.filtersConfig()));
            }
            case "tierConfig": {
                return Optional.ofNullable(clazz.cast(this.tierConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("filtersConfig", FILTERS_CONFIG_FIELD);
        map.put("tierConfig", TIER_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GuardrailContentPolicyConfig, T> g) {
        return obj -> g.apply((GuardrailContentPolicyConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<GuardrailContentFilterConfig> filtersConfig = DefaultSdkAutoConstructList.getInstance();
        private GuardrailContentFiltersTierConfig tierConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(GuardrailContentPolicyConfig model) {
            this.filtersConfig(model.filtersConfig);
            this.tierConfig(model.tierConfig);
        }

        public final List<GuardrailContentFilterConfig.Builder> getFiltersConfig() {
            List<GuardrailContentFilterConfig.Builder> result = GuardrailContentFiltersConfigCopier.copyToBuilder(this.filtersConfig);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFiltersConfig(Collection<GuardrailContentFilterConfig.BuilderImpl> filtersConfig) {
            this.filtersConfig = GuardrailContentFiltersConfigCopier.copyFromBuilder(filtersConfig);
        }

        @Override
        public final Builder filtersConfig(Collection<GuardrailContentFilterConfig> filtersConfig) {
            this.filtersConfig = GuardrailContentFiltersConfigCopier.copy(filtersConfig);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filtersConfig(GuardrailContentFilterConfig ... filtersConfig) {
            this.filtersConfig(Arrays.asList(filtersConfig));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filtersConfig(Consumer<GuardrailContentFilterConfig.Builder> ... filtersConfig) {
            this.filtersConfig(Stream.of(filtersConfig).map(c -> (GuardrailContentFilterConfig)((GuardrailContentFilterConfig.Builder)GuardrailContentFilterConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final GuardrailContentFiltersTierConfig.Builder getTierConfig() {
            return this.tierConfig != null ? this.tierConfig.toBuilder() : null;
        }

        public final void setTierConfig(GuardrailContentFiltersTierConfig.BuilderImpl tierConfig) {
            this.tierConfig = tierConfig != null ? tierConfig.build() : null;
        }

        @Override
        public final Builder tierConfig(GuardrailContentFiltersTierConfig tierConfig) {
            this.tierConfig = tierConfig;
            return this;
        }

        public GuardrailContentPolicyConfig build() {
            return new GuardrailContentPolicyConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GuardrailContentPolicyConfig> {
        public Builder filtersConfig(Collection<GuardrailContentFilterConfig> var1);

        public Builder filtersConfig(GuardrailContentFilterConfig ... var1);

        public Builder filtersConfig(Consumer<GuardrailContentFilterConfig.Builder> ... var1);

        public Builder tierConfig(GuardrailContentFiltersTierConfig var1);

        default public Builder tierConfig(Consumer<GuardrailContentFiltersTierConfig.Builder> tierConfig) {
            return this.tierConfig((GuardrailContentFiltersTierConfig)((GuardrailContentFiltersTierConfig.Builder)GuardrailContentFiltersTierConfig.builder().applyMutation(tierConfig)).build());
        }
    }
}

