/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrock.model.GuardrailContextualGroundingAction;
import software.amazon.awssdk.services.bedrock.model.GuardrailContextualGroundingFilterType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GuardrailContextualGroundingFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GuardrailContextualGroundingFilter> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(GuardrailContextualGroundingFilter.getter(GuardrailContextualGroundingFilter::typeAsString)).setter(GuardrailContextualGroundingFilter.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<Double> THRESHOLD_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("threshold").getter(GuardrailContextualGroundingFilter.getter(GuardrailContextualGroundingFilter::threshold)).setter(GuardrailContextualGroundingFilter.setter(Builder::threshold)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("threshold").build()}).build();
    private static final SdkField<String> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("action").getter(GuardrailContextualGroundingFilter.getter(GuardrailContextualGroundingFilter::actionAsString)).setter(GuardrailContextualGroundingFilter.setter(Builder::action)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()}).build();
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enabled").getter(GuardrailContextualGroundingFilter.getter(GuardrailContextualGroundingFilter::enabled)).setter(GuardrailContextualGroundingFilter.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabled").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, THRESHOLD_FIELD, ACTION_FIELD, ENABLED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GuardrailContextualGroundingFilter.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String type;
    private final Double threshold;
    private final String action;
    private final Boolean enabled;

    private GuardrailContextualGroundingFilter(BuilderImpl builder) {
        this.type = builder.type;
        this.threshold = builder.threshold;
        this.action = builder.action;
        this.enabled = builder.enabled;
    }

    public final GuardrailContextualGroundingFilterType type() {
        return GuardrailContextualGroundingFilterType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final Double threshold() {
        return this.threshold;
    }

    public final GuardrailContextualGroundingAction action() {
        return GuardrailContextualGroundingAction.fromValue(this.action);
    }

    public final String actionAsString() {
        return this.action;
    }

    public final Boolean enabled() {
        return this.enabled;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.threshold());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GuardrailContextualGroundingFilter)) {
            return false;
        }
        GuardrailContextualGroundingFilter other = (GuardrailContextualGroundingFilter)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.threshold(), other.threshold()) && Objects.equals(this.actionAsString(), other.actionAsString()) && Objects.equals(this.enabled(), other.enabled());
    }

    public final String toString() {
        return ToString.builder((String)"GuardrailContextualGroundingFilter").add("Type", (Object)this.typeAsString()).add("Threshold", (Object)this.threshold()).add("Action", (Object)(this.actionAsString() == null ? null : "*** Sensitive Data Redacted ***")).add("Enabled", (Object)this.enabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "threshold": {
                return Optional.ofNullable(clazz.cast(this.threshold()));
            }
            case "action": {
                return Optional.ofNullable(clazz.cast(this.actionAsString()));
            }
            case "enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", TYPE_FIELD);
        map.put("threshold", THRESHOLD_FIELD);
        map.put("action", ACTION_FIELD);
        map.put("enabled", ENABLED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GuardrailContextualGroundingFilter, T> g) {
        return obj -> g.apply((GuardrailContextualGroundingFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private Double threshold;
        private String action;
        private Boolean enabled;

        private BuilderImpl() {
        }

        private BuilderImpl(GuardrailContextualGroundingFilter model) {
            this.type(model.type);
            this.threshold(model.threshold);
            this.action(model.action);
            this.enabled(model.enabled);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(GuardrailContextualGroundingFilterType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Double getThreshold() {
            return this.threshold;
        }

        public final void setThreshold(Double threshold) {
            this.threshold = threshold;
        }

        @Override
        public final Builder threshold(Double threshold) {
            this.threshold = threshold;
            return this;
        }

        public final String getAction() {
            return this.action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(GuardrailContextualGroundingAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public GuardrailContextualGroundingFilter build() {
            return new GuardrailContextualGroundingFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GuardrailContextualGroundingFilter> {
        public Builder type(String var1);

        public Builder type(GuardrailContextualGroundingFilterType var1);

        public Builder threshold(Double var1);

        public Builder action(String var1);

        public Builder action(GuardrailContextualGroundingAction var1);

        public Builder enabled(Boolean var1);
    }
}

