/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrock.model.BedrockRequest;
import software.amazon.awssdk.services.bedrock.model.GuardrailContentPolicyConfig;
import software.amazon.awssdk.services.bedrock.model.GuardrailContextualGroundingPolicyConfig;
import software.amazon.awssdk.services.bedrock.model.GuardrailCrossRegionConfig;
import software.amazon.awssdk.services.bedrock.model.GuardrailSensitiveInformationPolicyConfig;
import software.amazon.awssdk.services.bedrock.model.GuardrailTopicPolicyConfig;
import software.amazon.awssdk.services.bedrock.model.GuardrailWordPolicyConfig;
import software.amazon.awssdk.services.bedrock.model.Tag;
import software.amazon.awssdk.services.bedrock.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateGuardrailRequest
extends BedrockRequest
implements ToCopyableBuilder<Builder, CreateGuardrailRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateGuardrailRequest.getter(CreateGuardrailRequest::name)).setter(CreateGuardrailRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateGuardrailRequest.getter(CreateGuardrailRequest::description)).setter(CreateGuardrailRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<GuardrailTopicPolicyConfig> TOPIC_POLICY_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("topicPolicyConfig").getter(CreateGuardrailRequest.getter(CreateGuardrailRequest::topicPolicyConfig)).setter(CreateGuardrailRequest.setter(Builder::topicPolicyConfig)).constructor(GuardrailTopicPolicyConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("topicPolicyConfig").build()}).build();
    private static final SdkField<GuardrailContentPolicyConfig> CONTENT_POLICY_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("contentPolicyConfig").getter(CreateGuardrailRequest.getter(CreateGuardrailRequest::contentPolicyConfig)).setter(CreateGuardrailRequest.setter(Builder::contentPolicyConfig)).constructor(GuardrailContentPolicyConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentPolicyConfig").build()}).build();
    private static final SdkField<GuardrailWordPolicyConfig> WORD_POLICY_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("wordPolicyConfig").getter(CreateGuardrailRequest.getter(CreateGuardrailRequest::wordPolicyConfig)).setter(CreateGuardrailRequest.setter(Builder::wordPolicyConfig)).constructor(GuardrailWordPolicyConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("wordPolicyConfig").build()}).build();
    private static final SdkField<GuardrailSensitiveInformationPolicyConfig> SENSITIVE_INFORMATION_POLICY_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sensitiveInformationPolicyConfig").getter(CreateGuardrailRequest.getter(CreateGuardrailRequest::sensitiveInformationPolicyConfig)).setter(CreateGuardrailRequest.setter(Builder::sensitiveInformationPolicyConfig)).constructor(GuardrailSensitiveInformationPolicyConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sensitiveInformationPolicyConfig").build()}).build();
    private static final SdkField<GuardrailContextualGroundingPolicyConfig> CONTEXTUAL_GROUNDING_POLICY_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("contextualGroundingPolicyConfig").getter(CreateGuardrailRequest.getter(CreateGuardrailRequest::contextualGroundingPolicyConfig)).setter(CreateGuardrailRequest.setter(Builder::contextualGroundingPolicyConfig)).constructor(GuardrailContextualGroundingPolicyConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contextualGroundingPolicyConfig").build()}).build();
    private static final SdkField<GuardrailCrossRegionConfig> CROSS_REGION_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("crossRegionConfig").getter(CreateGuardrailRequest.getter(CreateGuardrailRequest::crossRegionConfig)).setter(CreateGuardrailRequest.setter(Builder::crossRegionConfig)).constructor(GuardrailCrossRegionConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("crossRegionConfig").build()}).build();
    private static final SdkField<String> BLOCKED_INPUT_MESSAGING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("blockedInputMessaging").getter(CreateGuardrailRequest.getter(CreateGuardrailRequest::blockedInputMessaging)).setter(CreateGuardrailRequest.setter(Builder::blockedInputMessaging)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blockedInputMessaging").build()}).build();
    private static final SdkField<String> BLOCKED_OUTPUTS_MESSAGING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("blockedOutputsMessaging").getter(CreateGuardrailRequest.getter(CreateGuardrailRequest::blockedOutputsMessaging)).setter(CreateGuardrailRequest.setter(Builder::blockedOutputsMessaging)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blockedOutputsMessaging").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kmsKeyId").getter(CreateGuardrailRequest.getter(CreateGuardrailRequest::kmsKeyId)).setter(CreateGuardrailRequest.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyId").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(CreateGuardrailRequest.getter(CreateGuardrailRequest::tags)).setter(CreateGuardrailRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientRequestToken").getter(CreateGuardrailRequest.getter(CreateGuardrailRequest::clientRequestToken)).setter(CreateGuardrailRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, TOPIC_POLICY_CONFIG_FIELD, CONTENT_POLICY_CONFIG_FIELD, WORD_POLICY_CONFIG_FIELD, SENSITIVE_INFORMATION_POLICY_CONFIG_FIELD, CONTEXTUAL_GROUNDING_POLICY_CONFIG_FIELD, CROSS_REGION_CONFIG_FIELD, BLOCKED_INPUT_MESSAGING_FIELD, BLOCKED_OUTPUTS_MESSAGING_FIELD, KMS_KEY_ID_FIELD, TAGS_FIELD, CLIENT_REQUEST_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateGuardrailRequest.memberNameToFieldInitializer();
    private final String name;
    private final String description;
    private final GuardrailTopicPolicyConfig topicPolicyConfig;
    private final GuardrailContentPolicyConfig contentPolicyConfig;
    private final GuardrailWordPolicyConfig wordPolicyConfig;
    private final GuardrailSensitiveInformationPolicyConfig sensitiveInformationPolicyConfig;
    private final GuardrailContextualGroundingPolicyConfig contextualGroundingPolicyConfig;
    private final GuardrailCrossRegionConfig crossRegionConfig;
    private final String blockedInputMessaging;
    private final String blockedOutputsMessaging;
    private final String kmsKeyId;
    private final List<Tag> tags;
    private final String clientRequestToken;

    private CreateGuardrailRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.topicPolicyConfig = builder.topicPolicyConfig;
        this.contentPolicyConfig = builder.contentPolicyConfig;
        this.wordPolicyConfig = builder.wordPolicyConfig;
        this.sensitiveInformationPolicyConfig = builder.sensitiveInformationPolicyConfig;
        this.contextualGroundingPolicyConfig = builder.contextualGroundingPolicyConfig;
        this.crossRegionConfig = builder.crossRegionConfig;
        this.blockedInputMessaging = builder.blockedInputMessaging;
        this.blockedOutputsMessaging = builder.blockedOutputsMessaging;
        this.kmsKeyId = builder.kmsKeyId;
        this.tags = builder.tags;
        this.clientRequestToken = builder.clientRequestToken;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final GuardrailTopicPolicyConfig topicPolicyConfig() {
        return this.topicPolicyConfig;
    }

    public final GuardrailContentPolicyConfig contentPolicyConfig() {
        return this.contentPolicyConfig;
    }

    public final GuardrailWordPolicyConfig wordPolicyConfig() {
        return this.wordPolicyConfig;
    }

    public final GuardrailSensitiveInformationPolicyConfig sensitiveInformationPolicyConfig() {
        return this.sensitiveInformationPolicyConfig;
    }

    public final GuardrailContextualGroundingPolicyConfig contextualGroundingPolicyConfig() {
        return this.contextualGroundingPolicyConfig;
    }

    public final GuardrailCrossRegionConfig crossRegionConfig() {
        return this.crossRegionConfig;
    }

    public final String blockedInputMessaging() {
        return this.blockedInputMessaging;
    }

    public final String blockedOutputsMessaging() {
        return this.blockedOutputsMessaging;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.topicPolicyConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentPolicyConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.wordPolicyConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.sensitiveInformationPolicyConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.contextualGroundingPolicyConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.crossRegionConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.blockedInputMessaging());
        hashCode = 31 * hashCode + Objects.hashCode(this.blockedOutputsMessaging());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGuardrailRequest)) {
            return false;
        }
        CreateGuardrailRequest other = (CreateGuardrailRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.topicPolicyConfig(), other.topicPolicyConfig()) && Objects.equals(this.contentPolicyConfig(), other.contentPolicyConfig()) && Objects.equals(this.wordPolicyConfig(), other.wordPolicyConfig()) && Objects.equals(this.sensitiveInformationPolicyConfig(), other.sensitiveInformationPolicyConfig()) && Objects.equals(this.contextualGroundingPolicyConfig(), other.contextualGroundingPolicyConfig()) && Objects.equals(this.crossRegionConfig(), other.crossRegionConfig()) && Objects.equals(this.blockedInputMessaging(), other.blockedInputMessaging()) && Objects.equals(this.blockedOutputsMessaging(), other.blockedOutputsMessaging()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken());
    }

    public final String toString() {
        return ToString.builder((String)"CreateGuardrailRequest").add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("TopicPolicyConfig", (Object)this.topicPolicyConfig()).add("ContentPolicyConfig", (Object)this.contentPolicyConfig()).add("WordPolicyConfig", (Object)this.wordPolicyConfig()).add("SensitiveInformationPolicyConfig", (Object)this.sensitiveInformationPolicyConfig()).add("ContextualGroundingPolicyConfig", (Object)this.contextualGroundingPolicyConfig()).add("CrossRegionConfig", (Object)this.crossRegionConfig()).add("BlockedInputMessaging", (Object)(this.blockedInputMessaging() == null ? null : "*** Sensitive Data Redacted ***")).add("BlockedOutputsMessaging", (Object)(this.blockedOutputsMessaging() == null ? null : "*** Sensitive Data Redacted ***")).add("KmsKeyId", (Object)this.kmsKeyId()).add("Tags", this.hasTags() ? this.tags() : null).add("ClientRequestToken", (Object)this.clientRequestToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "topicPolicyConfig": {
                return Optional.ofNullable(clazz.cast(this.topicPolicyConfig()));
            }
            case "contentPolicyConfig": {
                return Optional.ofNullable(clazz.cast(this.contentPolicyConfig()));
            }
            case "wordPolicyConfig": {
                return Optional.ofNullable(clazz.cast(this.wordPolicyConfig()));
            }
            case "sensitiveInformationPolicyConfig": {
                return Optional.ofNullable(clazz.cast(this.sensitiveInformationPolicyConfig()));
            }
            case "contextualGroundingPolicyConfig": {
                return Optional.ofNullable(clazz.cast(this.contextualGroundingPolicyConfig()));
            }
            case "crossRegionConfig": {
                return Optional.ofNullable(clazz.cast(this.crossRegionConfig()));
            }
            case "blockedInputMessaging": {
                return Optional.ofNullable(clazz.cast(this.blockedInputMessaging()));
            }
            case "blockedOutputsMessaging": {
                return Optional.ofNullable(clazz.cast(this.blockedOutputsMessaging()));
            }
            case "kmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "clientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("topicPolicyConfig", TOPIC_POLICY_CONFIG_FIELD);
        map.put("contentPolicyConfig", CONTENT_POLICY_CONFIG_FIELD);
        map.put("wordPolicyConfig", WORD_POLICY_CONFIG_FIELD);
        map.put("sensitiveInformationPolicyConfig", SENSITIVE_INFORMATION_POLICY_CONFIG_FIELD);
        map.put("contextualGroundingPolicyConfig", CONTEXTUAL_GROUNDING_POLICY_CONFIG_FIELD);
        map.put("crossRegionConfig", CROSS_REGION_CONFIG_FIELD);
        map.put("blockedInputMessaging", BLOCKED_INPUT_MESSAGING_FIELD);
        map.put("blockedOutputsMessaging", BLOCKED_OUTPUTS_MESSAGING_FIELD);
        map.put("kmsKeyId", KMS_KEY_ID_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("clientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateGuardrailRequest, T> g) {
        return obj -> g.apply((CreateGuardrailRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockRequest.BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private GuardrailTopicPolicyConfig topicPolicyConfig;
        private GuardrailContentPolicyConfig contentPolicyConfig;
        private GuardrailWordPolicyConfig wordPolicyConfig;
        private GuardrailSensitiveInformationPolicyConfig sensitiveInformationPolicyConfig;
        private GuardrailContextualGroundingPolicyConfig contextualGroundingPolicyConfig;
        private GuardrailCrossRegionConfig crossRegionConfig;
        private String blockedInputMessaging;
        private String blockedOutputsMessaging;
        private String kmsKeyId;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateGuardrailRequest model) {
            super(model);
            this.name(model.name);
            this.description(model.description);
            this.topicPolicyConfig(model.topicPolicyConfig);
            this.contentPolicyConfig(model.contentPolicyConfig);
            this.wordPolicyConfig(model.wordPolicyConfig);
            this.sensitiveInformationPolicyConfig(model.sensitiveInformationPolicyConfig);
            this.contextualGroundingPolicyConfig(model.contextualGroundingPolicyConfig);
            this.crossRegionConfig(model.crossRegionConfig);
            this.blockedInputMessaging(model.blockedInputMessaging);
            this.blockedOutputsMessaging(model.blockedOutputsMessaging);
            this.kmsKeyId(model.kmsKeyId);
            this.tags(model.tags);
            this.clientRequestToken(model.clientRequestToken);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final GuardrailTopicPolicyConfig.Builder getTopicPolicyConfig() {
            return this.topicPolicyConfig != null ? this.topicPolicyConfig.toBuilder() : null;
        }

        public final void setTopicPolicyConfig(GuardrailTopicPolicyConfig.BuilderImpl topicPolicyConfig) {
            this.topicPolicyConfig = topicPolicyConfig != null ? topicPolicyConfig.build() : null;
        }

        @Override
        public final Builder topicPolicyConfig(GuardrailTopicPolicyConfig topicPolicyConfig) {
            this.topicPolicyConfig = topicPolicyConfig;
            return this;
        }

        public final GuardrailContentPolicyConfig.Builder getContentPolicyConfig() {
            return this.contentPolicyConfig != null ? this.contentPolicyConfig.toBuilder() : null;
        }

        public final void setContentPolicyConfig(GuardrailContentPolicyConfig.BuilderImpl contentPolicyConfig) {
            this.contentPolicyConfig = contentPolicyConfig != null ? contentPolicyConfig.build() : null;
        }

        @Override
        public final Builder contentPolicyConfig(GuardrailContentPolicyConfig contentPolicyConfig) {
            this.contentPolicyConfig = contentPolicyConfig;
            return this;
        }

        public final GuardrailWordPolicyConfig.Builder getWordPolicyConfig() {
            return this.wordPolicyConfig != null ? this.wordPolicyConfig.toBuilder() : null;
        }

        public final void setWordPolicyConfig(GuardrailWordPolicyConfig.BuilderImpl wordPolicyConfig) {
            this.wordPolicyConfig = wordPolicyConfig != null ? wordPolicyConfig.build() : null;
        }

        @Override
        public final Builder wordPolicyConfig(GuardrailWordPolicyConfig wordPolicyConfig) {
            this.wordPolicyConfig = wordPolicyConfig;
            return this;
        }

        public final GuardrailSensitiveInformationPolicyConfig.Builder getSensitiveInformationPolicyConfig() {
            return this.sensitiveInformationPolicyConfig != null ? this.sensitiveInformationPolicyConfig.toBuilder() : null;
        }

        public final void setSensitiveInformationPolicyConfig(GuardrailSensitiveInformationPolicyConfig.BuilderImpl sensitiveInformationPolicyConfig) {
            this.sensitiveInformationPolicyConfig = sensitiveInformationPolicyConfig != null ? sensitiveInformationPolicyConfig.build() : null;
        }

        @Override
        public final Builder sensitiveInformationPolicyConfig(GuardrailSensitiveInformationPolicyConfig sensitiveInformationPolicyConfig) {
            this.sensitiveInformationPolicyConfig = sensitiveInformationPolicyConfig;
            return this;
        }

        public final GuardrailContextualGroundingPolicyConfig.Builder getContextualGroundingPolicyConfig() {
            return this.contextualGroundingPolicyConfig != null ? this.contextualGroundingPolicyConfig.toBuilder() : null;
        }

        public final void setContextualGroundingPolicyConfig(GuardrailContextualGroundingPolicyConfig.BuilderImpl contextualGroundingPolicyConfig) {
            this.contextualGroundingPolicyConfig = contextualGroundingPolicyConfig != null ? contextualGroundingPolicyConfig.build() : null;
        }

        @Override
        public final Builder contextualGroundingPolicyConfig(GuardrailContextualGroundingPolicyConfig contextualGroundingPolicyConfig) {
            this.contextualGroundingPolicyConfig = contextualGroundingPolicyConfig;
            return this;
        }

        public final GuardrailCrossRegionConfig.Builder getCrossRegionConfig() {
            return this.crossRegionConfig != null ? this.crossRegionConfig.toBuilder() : null;
        }

        public final void setCrossRegionConfig(GuardrailCrossRegionConfig.BuilderImpl crossRegionConfig) {
            this.crossRegionConfig = crossRegionConfig != null ? crossRegionConfig.build() : null;
        }

        @Override
        public final Builder crossRegionConfig(GuardrailCrossRegionConfig crossRegionConfig) {
            this.crossRegionConfig = crossRegionConfig;
            return this;
        }

        public final String getBlockedInputMessaging() {
            return this.blockedInputMessaging;
        }

        public final void setBlockedInputMessaging(String blockedInputMessaging) {
            this.blockedInputMessaging = blockedInputMessaging;
        }

        @Override
        public final Builder blockedInputMessaging(String blockedInputMessaging) {
            this.blockedInputMessaging = blockedInputMessaging;
            return this;
        }

        public final String getBlockedOutputsMessaging() {
            return this.blockedOutputsMessaging;
        }

        public final void setBlockedOutputsMessaging(String blockedOutputsMessaging) {
            this.blockedOutputsMessaging = blockedOutputsMessaging;
        }

        @Override
        public final Builder blockedOutputsMessaging(String blockedOutputsMessaging) {
            this.blockedOutputsMessaging = blockedOutputsMessaging;
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateGuardrailRequest build() {
            return new CreateGuardrailRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateGuardrailRequest> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder topicPolicyConfig(GuardrailTopicPolicyConfig var1);

        default public Builder topicPolicyConfig(Consumer<GuardrailTopicPolicyConfig.Builder> topicPolicyConfig) {
            return this.topicPolicyConfig((GuardrailTopicPolicyConfig)((GuardrailTopicPolicyConfig.Builder)GuardrailTopicPolicyConfig.builder().applyMutation(topicPolicyConfig)).build());
        }

        public Builder contentPolicyConfig(GuardrailContentPolicyConfig var1);

        default public Builder contentPolicyConfig(Consumer<GuardrailContentPolicyConfig.Builder> contentPolicyConfig) {
            return this.contentPolicyConfig((GuardrailContentPolicyConfig)((GuardrailContentPolicyConfig.Builder)GuardrailContentPolicyConfig.builder().applyMutation(contentPolicyConfig)).build());
        }

        public Builder wordPolicyConfig(GuardrailWordPolicyConfig var1);

        default public Builder wordPolicyConfig(Consumer<GuardrailWordPolicyConfig.Builder> wordPolicyConfig) {
            return this.wordPolicyConfig((GuardrailWordPolicyConfig)((GuardrailWordPolicyConfig.Builder)GuardrailWordPolicyConfig.builder().applyMutation(wordPolicyConfig)).build());
        }

        public Builder sensitiveInformationPolicyConfig(GuardrailSensitiveInformationPolicyConfig var1);

        default public Builder sensitiveInformationPolicyConfig(Consumer<GuardrailSensitiveInformationPolicyConfig.Builder> sensitiveInformationPolicyConfig) {
            return this.sensitiveInformationPolicyConfig((GuardrailSensitiveInformationPolicyConfig)((GuardrailSensitiveInformationPolicyConfig.Builder)GuardrailSensitiveInformationPolicyConfig.builder().applyMutation(sensitiveInformationPolicyConfig)).build());
        }

        public Builder contextualGroundingPolicyConfig(GuardrailContextualGroundingPolicyConfig var1);

        default public Builder contextualGroundingPolicyConfig(Consumer<GuardrailContextualGroundingPolicyConfig.Builder> contextualGroundingPolicyConfig) {
            return this.contextualGroundingPolicyConfig((GuardrailContextualGroundingPolicyConfig)((GuardrailContextualGroundingPolicyConfig.Builder)GuardrailContextualGroundingPolicyConfig.builder().applyMutation(contextualGroundingPolicyConfig)).build());
        }

        public Builder crossRegionConfig(GuardrailCrossRegionConfig var1);

        default public Builder crossRegionConfig(Consumer<GuardrailCrossRegionConfig.Builder> crossRegionConfig) {
            return this.crossRegionConfig((GuardrailCrossRegionConfig)((GuardrailCrossRegionConfig.Builder)GuardrailCrossRegionConfig.builder().applyMutation(crossRegionConfig)).build());
        }

        public Builder blockedInputMessaging(String var1);

        public Builder blockedOutputsMessaging(String var1);

        public Builder kmsKeyId(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder clientRequestToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

