/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrock.model.BedrockResponse;
import software.amazon.awssdk.services.bedrock.model.GuardrailSummariesCopier;
import software.amazon.awssdk.services.bedrock.model.GuardrailSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListGuardrailsResponse
extends BedrockResponse
implements ToCopyableBuilder<Builder, ListGuardrailsResponse> {
    private static final SdkField<List<GuardrailSummary>> GUARDRAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("guardrails").getter(ListGuardrailsResponse.getter(ListGuardrailsResponse::guardrails)).setter(ListGuardrailsResponse.setter(Builder::guardrails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("guardrails").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GuardrailSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListGuardrailsResponse.getter(ListGuardrailsResponse::nextToken)).setter(ListGuardrailsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GUARDRAILS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListGuardrailsResponse.memberNameToFieldInitializer();
    private final List<GuardrailSummary> guardrails;
    private final String nextToken;

    private ListGuardrailsResponse(BuilderImpl builder) {
        super(builder);
        this.guardrails = builder.guardrails;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasGuardrails() {
        return this.guardrails != null && !(this.guardrails instanceof SdkAutoConstructList);
    }

    public final List<GuardrailSummary> guardrails() {
        return this.guardrails;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGuardrails() ? this.guardrails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListGuardrailsResponse)) {
            return false;
        }
        ListGuardrailsResponse other = (ListGuardrailsResponse)((Object)obj);
        return this.hasGuardrails() == other.hasGuardrails() && Objects.equals(this.guardrails(), other.guardrails()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListGuardrailsResponse").add("Guardrails", this.hasGuardrails() ? this.guardrails() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "guardrails": {
                return Optional.ofNullable(clazz.cast(this.guardrails()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("guardrails", GUARDRAILS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListGuardrailsResponse, T> g) {
        return obj -> g.apply((ListGuardrailsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockResponse.BuilderImpl
    implements Builder {
        private List<GuardrailSummary> guardrails = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListGuardrailsResponse model) {
            super(model);
            this.guardrails(model.guardrails);
            this.nextToken(model.nextToken);
        }

        public final List<GuardrailSummary.Builder> getGuardrails() {
            List<GuardrailSummary.Builder> result = GuardrailSummariesCopier.copyToBuilder(this.guardrails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGuardrails(Collection<GuardrailSummary.BuilderImpl> guardrails) {
            this.guardrails = GuardrailSummariesCopier.copyFromBuilder(guardrails);
        }

        @Override
        public final Builder guardrails(Collection<GuardrailSummary> guardrails) {
            this.guardrails = GuardrailSummariesCopier.copy(guardrails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder guardrails(GuardrailSummary ... guardrails) {
            this.guardrails(Arrays.asList(guardrails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder guardrails(Consumer<GuardrailSummary.Builder> ... guardrails) {
            this.guardrails(Stream.of(guardrails).map(c -> (GuardrailSummary)((GuardrailSummary.Builder)GuardrailSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListGuardrailsResponse build() {
            return new ListGuardrailsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListGuardrailsResponse> {
        public Builder guardrails(Collection<GuardrailSummary> var1);

        public Builder guardrails(GuardrailSummary ... var1);

        public Builder guardrails(Consumer<GuardrailSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

