/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrock.model.BedrockRequest;
import software.amazon.awssdk.services.bedrock.model.ModelCopyJobStatus;
import software.amazon.awssdk.services.bedrock.model.SortJobsBy;
import software.amazon.awssdk.services.bedrock.model.SortOrder;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListModelCopyJobsRequest
extends BedrockRequest
implements ToCopyableBuilder<Builder, ListModelCopyJobsRequest> {
    private static final SdkField<Instant> CREATION_TIME_AFTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTimeAfter").getter(ListModelCopyJobsRequest.getter(ListModelCopyJobsRequest::creationTimeAfter)).setter(ListModelCopyJobsRequest.setter(Builder::creationTimeAfter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("creationTimeAfter").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> CREATION_TIME_BEFORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTimeBefore").getter(ListModelCopyJobsRequest.getter(ListModelCopyJobsRequest::creationTimeBefore)).setter(ListModelCopyJobsRequest.setter(Builder::creationTimeBefore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("creationTimeBefore").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> STATUS_EQUALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusEquals").getter(ListModelCopyJobsRequest.getter(ListModelCopyJobsRequest::statusEqualsAsString)).setter(ListModelCopyJobsRequest.setter(Builder::statusEquals)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("statusEquals").build()}).build();
    private static final SdkField<String> SOURCE_ACCOUNT_EQUALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceAccountEquals").getter(ListModelCopyJobsRequest.getter(ListModelCopyJobsRequest::sourceAccountEquals)).setter(ListModelCopyJobsRequest.setter(Builder::sourceAccountEquals)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("sourceAccountEquals").build()}).build();
    private static final SdkField<String> SOURCE_MODEL_ARN_EQUALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceModelArnEquals").getter(ListModelCopyJobsRequest.getter(ListModelCopyJobsRequest::sourceModelArnEquals)).setter(ListModelCopyJobsRequest.setter(Builder::sourceModelArnEquals)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("sourceModelArnEquals").build()}).build();
    private static final SdkField<String> TARGET_MODEL_NAME_CONTAINS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetModelNameContains").getter(ListModelCopyJobsRequest.getter(ListModelCopyJobsRequest::targetModelNameContains)).setter(ListModelCopyJobsRequest.setter(Builder::targetModelNameContains)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("outputModelNameContains").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListModelCopyJobsRequest.getter(ListModelCopyJobsRequest::maxResults)).setter(ListModelCopyJobsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListModelCopyJobsRequest.getter(ListModelCopyJobsRequest::nextToken)).setter(ListModelCopyJobsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final SdkField<String> SORT_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sortBy").getter(ListModelCopyJobsRequest.getter(ListModelCopyJobsRequest::sortByAsString)).setter(ListModelCopyJobsRequest.setter(Builder::sortBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("sortBy").build()}).build();
    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sortOrder").getter(ListModelCopyJobsRequest.getter(ListModelCopyJobsRequest::sortOrderAsString)).setter(ListModelCopyJobsRequest.setter(Builder::sortOrder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("sortOrder").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATION_TIME_AFTER_FIELD, CREATION_TIME_BEFORE_FIELD, STATUS_EQUALS_FIELD, SOURCE_ACCOUNT_EQUALS_FIELD, SOURCE_MODEL_ARN_EQUALS_FIELD, TARGET_MODEL_NAME_CONTAINS_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, SORT_BY_FIELD, SORT_ORDER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListModelCopyJobsRequest.memberNameToFieldInitializer();
    private final Instant creationTimeAfter;
    private final Instant creationTimeBefore;
    private final String statusEquals;
    private final String sourceAccountEquals;
    private final String sourceModelArnEquals;
    private final String targetModelNameContains;
    private final Integer maxResults;
    private final String nextToken;
    private final String sortBy;
    private final String sortOrder;

    private ListModelCopyJobsRequest(BuilderImpl builder) {
        super(builder);
        this.creationTimeAfter = builder.creationTimeAfter;
        this.creationTimeBefore = builder.creationTimeBefore;
        this.statusEquals = builder.statusEquals;
        this.sourceAccountEquals = builder.sourceAccountEquals;
        this.sourceModelArnEquals = builder.sourceModelArnEquals;
        this.targetModelNameContains = builder.targetModelNameContains;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.sortBy = builder.sortBy;
        this.sortOrder = builder.sortOrder;
    }

    public final Instant creationTimeAfter() {
        return this.creationTimeAfter;
    }

    public final Instant creationTimeBefore() {
        return this.creationTimeBefore;
    }

    public final ModelCopyJobStatus statusEquals() {
        return ModelCopyJobStatus.fromValue(this.statusEquals);
    }

    public final String statusEqualsAsString() {
        return this.statusEquals;
    }

    public final String sourceAccountEquals() {
        return this.sourceAccountEquals;
    }

    public final String sourceModelArnEquals() {
        return this.sourceModelArnEquals;
    }

    public final String targetModelNameContains() {
        return this.targetModelNameContains;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final SortJobsBy sortBy() {
        return SortJobsBy.fromValue(this.sortBy);
    }

    public final String sortByAsString() {
        return this.sortBy;
    }

    public final SortOrder sortOrder() {
        return SortOrder.fromValue(this.sortOrder);
    }

    public final String sortOrderAsString() {
        return this.sortOrder;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTimeAfter());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTimeBefore());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusEqualsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceAccountEquals());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceModelArnEquals());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetModelNameContains());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortOrderAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListModelCopyJobsRequest)) {
            return false;
        }
        ListModelCopyJobsRequest other = (ListModelCopyJobsRequest)((Object)obj);
        return Objects.equals(this.creationTimeAfter(), other.creationTimeAfter()) && Objects.equals(this.creationTimeBefore(), other.creationTimeBefore()) && Objects.equals(this.statusEqualsAsString(), other.statusEqualsAsString()) && Objects.equals(this.sourceAccountEquals(), other.sourceAccountEquals()) && Objects.equals(this.sourceModelArnEquals(), other.sourceModelArnEquals()) && Objects.equals(this.targetModelNameContains(), other.targetModelNameContains()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.sortByAsString(), other.sortByAsString()) && Objects.equals(this.sortOrderAsString(), other.sortOrderAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ListModelCopyJobsRequest").add("CreationTimeAfter", (Object)this.creationTimeAfter()).add("CreationTimeBefore", (Object)this.creationTimeBefore()).add("StatusEquals", (Object)this.statusEqualsAsString()).add("SourceAccountEquals", (Object)this.sourceAccountEquals()).add("SourceModelArnEquals", (Object)this.sourceModelArnEquals()).add("TargetModelNameContains", (Object)this.targetModelNameContains()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("SortBy", (Object)this.sortByAsString()).add("SortOrder", (Object)this.sortOrderAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "creationTimeAfter": {
                return Optional.ofNullable(clazz.cast(this.creationTimeAfter()));
            }
            case "creationTimeBefore": {
                return Optional.ofNullable(clazz.cast(this.creationTimeBefore()));
            }
            case "statusEquals": {
                return Optional.ofNullable(clazz.cast(this.statusEqualsAsString()));
            }
            case "sourceAccountEquals": {
                return Optional.ofNullable(clazz.cast(this.sourceAccountEquals()));
            }
            case "sourceModelArnEquals": {
                return Optional.ofNullable(clazz.cast(this.sourceModelArnEquals()));
            }
            case "targetModelNameContains": {
                return Optional.ofNullable(clazz.cast(this.targetModelNameContains()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "sortBy": {
                return Optional.ofNullable(clazz.cast(this.sortByAsString()));
            }
            case "sortOrder": {
                return Optional.ofNullable(clazz.cast(this.sortOrderAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("creationTimeAfter", CREATION_TIME_AFTER_FIELD);
        map.put("creationTimeBefore", CREATION_TIME_BEFORE_FIELD);
        map.put("statusEquals", STATUS_EQUALS_FIELD);
        map.put("sourceAccountEquals", SOURCE_ACCOUNT_EQUALS_FIELD);
        map.put("sourceModelArnEquals", SOURCE_MODEL_ARN_EQUALS_FIELD);
        map.put("outputModelNameContains", TARGET_MODEL_NAME_CONTAINS_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("sortBy", SORT_BY_FIELD);
        map.put("sortOrder", SORT_ORDER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListModelCopyJobsRequest, T> g) {
        return obj -> g.apply((ListModelCopyJobsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockRequest.BuilderImpl
    implements Builder {
        private Instant creationTimeAfter;
        private Instant creationTimeBefore;
        private String statusEquals;
        private String sourceAccountEquals;
        private String sourceModelArnEquals;
        private String targetModelNameContains;
        private Integer maxResults;
        private String nextToken;
        private String sortBy;
        private String sortOrder;

        private BuilderImpl() {
        }

        private BuilderImpl(ListModelCopyJobsRequest model) {
            super(model);
            this.creationTimeAfter(model.creationTimeAfter);
            this.creationTimeBefore(model.creationTimeBefore);
            this.statusEquals(model.statusEquals);
            this.sourceAccountEquals(model.sourceAccountEquals);
            this.sourceModelArnEquals(model.sourceModelArnEquals);
            this.targetModelNameContains(model.targetModelNameContains);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.sortBy(model.sortBy);
            this.sortOrder(model.sortOrder);
        }

        public final Instant getCreationTimeAfter() {
            return this.creationTimeAfter;
        }

        public final void setCreationTimeAfter(Instant creationTimeAfter) {
            this.creationTimeAfter = creationTimeAfter;
        }

        @Override
        public final Builder creationTimeAfter(Instant creationTimeAfter) {
            this.creationTimeAfter = creationTimeAfter;
            return this;
        }

        public final Instant getCreationTimeBefore() {
            return this.creationTimeBefore;
        }

        public final void setCreationTimeBefore(Instant creationTimeBefore) {
            this.creationTimeBefore = creationTimeBefore;
        }

        @Override
        public final Builder creationTimeBefore(Instant creationTimeBefore) {
            this.creationTimeBefore = creationTimeBefore;
            return this;
        }

        public final String getStatusEquals() {
            return this.statusEquals;
        }

        public final void setStatusEquals(String statusEquals) {
            this.statusEquals = statusEquals;
        }

        @Override
        public final Builder statusEquals(String statusEquals) {
            this.statusEquals = statusEquals;
            return this;
        }

        @Override
        public final Builder statusEquals(ModelCopyJobStatus statusEquals) {
            this.statusEquals(statusEquals == null ? null : statusEquals.toString());
            return this;
        }

        public final String getSourceAccountEquals() {
            return this.sourceAccountEquals;
        }

        public final void setSourceAccountEquals(String sourceAccountEquals) {
            this.sourceAccountEquals = sourceAccountEquals;
        }

        @Override
        public final Builder sourceAccountEquals(String sourceAccountEquals) {
            this.sourceAccountEquals = sourceAccountEquals;
            return this;
        }

        public final String getSourceModelArnEquals() {
            return this.sourceModelArnEquals;
        }

        public final void setSourceModelArnEquals(String sourceModelArnEquals) {
            this.sourceModelArnEquals = sourceModelArnEquals;
        }

        @Override
        public final Builder sourceModelArnEquals(String sourceModelArnEquals) {
            this.sourceModelArnEquals = sourceModelArnEquals;
            return this;
        }

        public final String getTargetModelNameContains() {
            return this.targetModelNameContains;
        }

        public final void setTargetModelNameContains(String targetModelNameContains) {
            this.targetModelNameContains = targetModelNameContains;
        }

        @Override
        public final Builder targetModelNameContains(String targetModelNameContains) {
            this.targetModelNameContains = targetModelNameContains;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getSortBy() {
            return this.sortBy;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public final Builder sortBy(SortJobsBy sortBy) {
            this.sortBy(sortBy == null ? null : sortBy.toString());
            return this;
        }

        public final String getSortOrder() {
            return this.sortOrder;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListModelCopyJobsRequest build() {
            return new ListModelCopyJobsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListModelCopyJobsRequest> {
        public Builder creationTimeAfter(Instant var1);

        public Builder creationTimeBefore(Instant var1);

        public Builder statusEquals(String var1);

        public Builder statusEquals(ModelCopyJobStatus var1);

        public Builder sourceAccountEquals(String var1);

        public Builder sourceModelArnEquals(String var1);

        public Builder targetModelNameContains(String var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder sortBy(String var1);

        public Builder sortBy(SortJobsBy var1);

        public Builder sortOrder(String var1);

        public Builder sortOrder(SortOrder var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

