/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrock.model.EvaluationModelConfigSummary;
import software.amazon.awssdk.services.bedrock.model.EvaluationRagConfigSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EvaluationInferenceConfigSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EvaluationInferenceConfigSummary> {
    private static final SdkField<EvaluationModelConfigSummary> MODEL_CONFIG_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("modelConfigSummary").getter(EvaluationInferenceConfigSummary.getter(EvaluationInferenceConfigSummary::modelConfigSummary)).setter(EvaluationInferenceConfigSummary.setter(Builder::modelConfigSummary)).constructor(EvaluationModelConfigSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelConfigSummary").build()}).build();
    private static final SdkField<EvaluationRagConfigSummary> RAG_CONFIG_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ragConfigSummary").getter(EvaluationInferenceConfigSummary.getter(EvaluationInferenceConfigSummary::ragConfigSummary)).setter(EvaluationInferenceConfigSummary.setter(Builder::ragConfigSummary)).constructor(EvaluationRagConfigSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ragConfigSummary").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_CONFIG_SUMMARY_FIELD, RAG_CONFIG_SUMMARY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EvaluationInferenceConfigSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final EvaluationModelConfigSummary modelConfigSummary;
    private final EvaluationRagConfigSummary ragConfigSummary;

    private EvaluationInferenceConfigSummary(BuilderImpl builder) {
        this.modelConfigSummary = builder.modelConfigSummary;
        this.ragConfigSummary = builder.ragConfigSummary;
    }

    public final EvaluationModelConfigSummary modelConfigSummary() {
        return this.modelConfigSummary;
    }

    public final EvaluationRagConfigSummary ragConfigSummary() {
        return this.ragConfigSummary;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.modelConfigSummary());
        hashCode = 31 * hashCode + Objects.hashCode(this.ragConfigSummary());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationInferenceConfigSummary)) {
            return false;
        }
        EvaluationInferenceConfigSummary other = (EvaluationInferenceConfigSummary)obj;
        return Objects.equals(this.modelConfigSummary(), other.modelConfigSummary()) && Objects.equals(this.ragConfigSummary(), other.ragConfigSummary());
    }

    public final String toString() {
        return ToString.builder((String)"EvaluationInferenceConfigSummary").add("ModelConfigSummary", (Object)this.modelConfigSummary()).add("RagConfigSummary", (Object)this.ragConfigSummary()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "modelConfigSummary": {
                return Optional.ofNullable(clazz.cast(this.modelConfigSummary()));
            }
            case "ragConfigSummary": {
                return Optional.ofNullable(clazz.cast(this.ragConfigSummary()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("modelConfigSummary", MODEL_CONFIG_SUMMARY_FIELD);
        map.put("ragConfigSummary", RAG_CONFIG_SUMMARY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EvaluationInferenceConfigSummary, T> g) {
        return obj -> g.apply((EvaluationInferenceConfigSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private EvaluationModelConfigSummary modelConfigSummary;
        private EvaluationRagConfigSummary ragConfigSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationInferenceConfigSummary model) {
            this.modelConfigSummary(model.modelConfigSummary);
            this.ragConfigSummary(model.ragConfigSummary);
        }

        public final EvaluationModelConfigSummary.Builder getModelConfigSummary() {
            return this.modelConfigSummary != null ? this.modelConfigSummary.toBuilder() : null;
        }

        public final void setModelConfigSummary(EvaluationModelConfigSummary.BuilderImpl modelConfigSummary) {
            this.modelConfigSummary = modelConfigSummary != null ? modelConfigSummary.build() : null;
        }

        @Override
        public final Builder modelConfigSummary(EvaluationModelConfigSummary modelConfigSummary) {
            this.modelConfigSummary = modelConfigSummary;
            return this;
        }

        public final EvaluationRagConfigSummary.Builder getRagConfigSummary() {
            return this.ragConfigSummary != null ? this.ragConfigSummary.toBuilder() : null;
        }

        public final void setRagConfigSummary(EvaluationRagConfigSummary.BuilderImpl ragConfigSummary) {
            this.ragConfigSummary = ragConfigSummary != null ? ragConfigSummary.build() : null;
        }

        @Override
        public final Builder ragConfigSummary(EvaluationRagConfigSummary ragConfigSummary) {
            this.ragConfigSummary = ragConfigSummary;
            return this;
        }

        public EvaluationInferenceConfigSummary build() {
            return new EvaluationInferenceConfigSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EvaluationInferenceConfigSummary> {
        public Builder modelConfigSummary(EvaluationModelConfigSummary var1);

        default public Builder modelConfigSummary(Consumer<EvaluationModelConfigSummary.Builder> modelConfigSummary) {
            return this.modelConfigSummary((EvaluationModelConfigSummary)((EvaluationModelConfigSummary.Builder)EvaluationModelConfigSummary.builder().applyMutation(modelConfigSummary)).build());
        }

        public Builder ragConfigSummary(EvaluationRagConfigSummary var1);

        default public Builder ragConfigSummary(Consumer<EvaluationRagConfigSummary.Builder> ragConfigSummary) {
            return this.ragConfigSummary((EvaluationRagConfigSummary)((EvaluationRagConfigSummary.Builder)EvaluationRagConfigSummary.builder().applyMutation(ragConfigSummary)).build());
        }
    }
}

