/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrock.model.BedrockRequest;
import software.amazon.awssdk.services.bedrock.model.EvaluationJobIdentifiersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchDeleteEvaluationJobRequest
extends BedrockRequest
implements ToCopyableBuilder<Builder, BatchDeleteEvaluationJobRequest> {
    private static final SdkField<List<String>> JOB_IDENTIFIERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("jobIdentifiers").getter(BatchDeleteEvaluationJobRequest.getter(BatchDeleteEvaluationJobRequest::jobIdentifiers)).setter(BatchDeleteEvaluationJobRequest.setter(Builder::jobIdentifiers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobIdentifiers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_IDENTIFIERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchDeleteEvaluationJobRequest.memberNameToFieldInitializer();
    private final List<String> jobIdentifiers;

    private BatchDeleteEvaluationJobRequest(BuilderImpl builder) {
        super(builder);
        this.jobIdentifiers = builder.jobIdentifiers;
    }

    public final boolean hasJobIdentifiers() {
        return this.jobIdentifiers != null && !(this.jobIdentifiers instanceof SdkAutoConstructList);
    }

    public final List<String> jobIdentifiers() {
        return this.jobIdentifiers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasJobIdentifiers() ? this.jobIdentifiers() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDeleteEvaluationJobRequest)) {
            return false;
        }
        BatchDeleteEvaluationJobRequest other = (BatchDeleteEvaluationJobRequest)((Object)obj);
        return this.hasJobIdentifiers() == other.hasJobIdentifiers() && Objects.equals(this.jobIdentifiers(), other.jobIdentifiers());
    }

    public final String toString() {
        return ToString.builder((String)"BatchDeleteEvaluationJobRequest").add("JobIdentifiers", (Object)(this.jobIdentifiers() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jobIdentifiers": {
                return Optional.ofNullable(clazz.cast(this.jobIdentifiers()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<String>>> map = new HashMap<String, SdkField<List<String>>>();
        map.put("jobIdentifiers", JOB_IDENTIFIERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchDeleteEvaluationJobRequest, T> g) {
        return obj -> g.apply((BatchDeleteEvaluationJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockRequest.BuilderImpl
    implements Builder {
        private List<String> jobIdentifiers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDeleteEvaluationJobRequest model) {
            super(model);
            this.jobIdentifiers(model.jobIdentifiers);
        }

        public final Collection<String> getJobIdentifiers() {
            if (this.jobIdentifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.jobIdentifiers;
        }

        public final void setJobIdentifiers(Collection<String> jobIdentifiers) {
            this.jobIdentifiers = EvaluationJobIdentifiersCopier.copy(jobIdentifiers);
        }

        @Override
        public final Builder jobIdentifiers(Collection<String> jobIdentifiers) {
            this.jobIdentifiers = EvaluationJobIdentifiersCopier.copy(jobIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobIdentifiers(String ... jobIdentifiers) {
            this.jobIdentifiers(Arrays.asList(jobIdentifiers));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchDeleteEvaluationJobRequest build() {
            return new BatchDeleteEvaluationJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchDeleteEvaluationJobRequest> {
        public Builder jobIdentifiers(Collection<String> var1);

        public Builder jobIdentifiers(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

