/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrock.BedrockClient;
import software.amazon.awssdk.services.bedrock.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrock.model.ListModelImportJobsRequest;
import software.amazon.awssdk.services.bedrock.model.ListModelImportJobsResponse;
import software.amazon.awssdk.services.bedrock.model.ModelImportJobSummary;

public class ListModelImportJobsIterable
implements SdkIterable<ListModelImportJobsResponse> {
    private final BedrockClient client;
    private final ListModelImportJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListModelImportJobsIterable(BedrockClient client, ListModelImportJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListModelImportJobsResponseFetcher();
    }

    public Iterator<ListModelImportJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ModelImportJobSummary> modelImportJobSummaries() {
        Function<ListModelImportJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.modelImportJobSummaries() != null) {
                return response.modelImportJobSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListModelImportJobsResponseFetcher
    implements SyncPageFetcher<ListModelImportJobsResponse> {
        private ListModelImportJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListModelImportJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListModelImportJobsResponse nextPage(ListModelImportJobsResponse previousPage) {
            if (previousPage == null) {
                return ListModelImportJobsIterable.this.client.listModelImportJobs(ListModelImportJobsIterable.this.firstRequest);
            }
            return ListModelImportJobsIterable.this.client.listModelImportJobs((ListModelImportJobsRequest)((Object)ListModelImportJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

