/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrock.BedrockClient;
import software.amazon.awssdk.services.bedrock.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrock.model.ListProvisionedModelThroughputsRequest;
import software.amazon.awssdk.services.bedrock.model.ListProvisionedModelThroughputsResponse;
import software.amazon.awssdk.services.bedrock.model.ProvisionedModelSummary;

public class ListProvisionedModelThroughputsIterable
implements SdkIterable<ListProvisionedModelThroughputsResponse> {
    private final BedrockClient client;
    private final ListProvisionedModelThroughputsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListProvisionedModelThroughputsIterable(BedrockClient client, ListProvisionedModelThroughputsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListProvisionedModelThroughputsResponseFetcher();
    }

    public Iterator<ListProvisionedModelThroughputsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ProvisionedModelSummary> provisionedModelSummaries() {
        Function<ListProvisionedModelThroughputsResponse, Iterator> getIterator = response -> {
            if (response != null && response.provisionedModelSummaries() != null) {
                return response.provisionedModelSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListProvisionedModelThroughputsResponseFetcher
    implements SyncPageFetcher<ListProvisionedModelThroughputsResponse> {
        private ListProvisionedModelThroughputsResponseFetcher() {
        }

        public boolean hasNextPage(ListProvisionedModelThroughputsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListProvisionedModelThroughputsResponse nextPage(ListProvisionedModelThroughputsResponse previousPage) {
            if (previousPage == null) {
                return ListProvisionedModelThroughputsIterable.this.client.listProvisionedModelThroughputs(ListProvisionedModelThroughputsIterable.this.firstRequest);
            }
            return ListProvisionedModelThroughputsIterable.this.client.listProvisionedModelThroughputs((ListProvisionedModelThroughputsRequest)((Object)ListProvisionedModelThroughputsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

