/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about a teacher model used for model customization.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TeacherModelConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<TeacherModelConfig.Builder, TeacherModelConfig> {
    private static final SdkField<String> TEACHER_MODEL_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("teacherModelIdentifier").getter(getter(TeacherModelConfig::teacherModelIdentifier))
            .setter(setter(Builder::teacherModelIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("teacherModelIdentifier").build())
            .build();

    private static final SdkField<Integer> MAX_RESPONSE_LENGTH_FOR_INFERENCE_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResponseLengthForInference")
            .getter(getter(TeacherModelConfig::maxResponseLengthForInference))
            .setter(setter(Builder::maxResponseLengthForInference))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResponseLengthForInference")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            TEACHER_MODEL_IDENTIFIER_FIELD, MAX_RESPONSE_LENGTH_FOR_INFERENCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String teacherModelIdentifier;

    private final Integer maxResponseLengthForInference;

    private TeacherModelConfig(BuilderImpl builder) {
        this.teacherModelIdentifier = builder.teacherModelIdentifier;
        this.maxResponseLengthForInference = builder.maxResponseLengthForInference;
    }

    /**
     * <p>
     * The identifier of the teacher model.
     * </p>
     * 
     * @return The identifier of the teacher model.
     */
    public final String teacherModelIdentifier() {
        return teacherModelIdentifier;
    }

    /**
     * <p>
     * The maximum number of tokens requested when the customization job invokes the teacher model.
     * </p>
     * 
     * @return The maximum number of tokens requested when the customization job invokes the teacher model.
     */
    public final Integer maxResponseLengthForInference() {
        return maxResponseLengthForInference;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(teacherModelIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(maxResponseLengthForInference());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TeacherModelConfig)) {
            return false;
        }
        TeacherModelConfig other = (TeacherModelConfig) obj;
        return Objects.equals(teacherModelIdentifier(), other.teacherModelIdentifier())
                && Objects.equals(maxResponseLengthForInference(), other.maxResponseLengthForInference());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TeacherModelConfig").add("TeacherModelIdentifier", teacherModelIdentifier())
                .add("MaxResponseLengthForInference", maxResponseLengthForInference()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "teacherModelIdentifier":
            return Optional.ofNullable(clazz.cast(teacherModelIdentifier()));
        case "maxResponseLengthForInference":
            return Optional.ofNullable(clazz.cast(maxResponseLengthForInference()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("teacherModelIdentifier", TEACHER_MODEL_IDENTIFIER_FIELD);
        map.put("maxResponseLengthForInference", MAX_RESPONSE_LENGTH_FOR_INFERENCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TeacherModelConfig, T> g) {
        return obj -> g.apply((TeacherModelConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TeacherModelConfig> {
        /**
         * <p>
         * The identifier of the teacher model.
         * </p>
         * 
         * @param teacherModelIdentifier
         *        The identifier of the teacher model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder teacherModelIdentifier(String teacherModelIdentifier);

        /**
         * <p>
         * The maximum number of tokens requested when the customization job invokes the teacher model.
         * </p>
         * 
         * @param maxResponseLengthForInference
         *        The maximum number of tokens requested when the customization job invokes the teacher model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResponseLengthForInference(Integer maxResponseLengthForInference);
    }

    static final class BuilderImpl implements Builder {
        private String teacherModelIdentifier;

        private Integer maxResponseLengthForInference;

        private BuilderImpl() {
        }

        private BuilderImpl(TeacherModelConfig model) {
            teacherModelIdentifier(model.teacherModelIdentifier);
            maxResponseLengthForInference(model.maxResponseLengthForInference);
        }

        public final String getTeacherModelIdentifier() {
            return teacherModelIdentifier;
        }

        public final void setTeacherModelIdentifier(String teacherModelIdentifier) {
            this.teacherModelIdentifier = teacherModelIdentifier;
        }

        @Override
        public final Builder teacherModelIdentifier(String teacherModelIdentifier) {
            this.teacherModelIdentifier = teacherModelIdentifier;
            return this;
        }

        public final Integer getMaxResponseLengthForInference() {
            return maxResponseLengthForInference;
        }

        public final void setMaxResponseLengthForInference(Integer maxResponseLengthForInference) {
            this.maxResponseLengthForInference = maxResponseLengthForInference;
        }

        @Override
        public final Builder maxResponseLengthForInference(Integer maxResponseLengthForInference) {
            this.maxResponseLengthForInference = maxResponseLengthForInference;
            return this;
        }

        @Override
        public TeacherModelConfig build() {
            return new TeacherModelConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
